/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.client;

import com.sun.dhcpmgr.bridge.BridgeException;
import com.sun.dhcpmgr.client.DataManager;
import com.sun.dhcpmgr.client.MacroView;
import com.sun.dhcpmgr.client.ResourceStrings;
import com.sun.dhcpmgr.data.Macro;
import com.sun.dhcpmgr.ui.SwingWorker;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

class MacroLoader
extends SwingWorker {
    MacroLoader() {
    }

    public Object construct() {
        try {
            return DataManager.get().getMacros(true);
        }
        catch (BridgeException bridgeException) {
            SwingUtilities.invokeLater(new Runnable(bridgeException){
                Object[] args;
                {
                    this.args = new Object[]{bridgeException.getMessage()};
                }

                public void run() {
                    MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("error_loading_macros"));
                    JOptionPane.showMessageDialog(null, messageFormat.format(this.args), ResourceStrings.getString("server_error_title"), 0);
                }
            });
            return null;
        }
    }

    public void finished() {
        Macro[] macroArray = (Macro[])this.get();
        if (macroArray == null) {
            macroArray = new Macro[]{};
        }
        MacroView.macroTreeModel.getRootNode().setMacros(macroArray);
    }
}

