/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.client;

import com.sun.dhcpmgr.client.DataManager;
import com.sun.dhcpmgr.client.DhcpmgrDialog;
import com.sun.dhcpmgr.client.ResourceStrings;
import com.sun.dhcpmgr.data.DhcpdOptions;
import com.sun.dhcpmgr.ui.IPAddressList;
import com.sun.dhcpmgr.ui.Wizard;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ConfigureRelayDialog
extends DhcpmgrDialog {
    private IPAddressList serverList;

    public ConfigureRelayDialog(Frame frame) {
        super(frame, false);
        this.setTitle(ResourceStrings.getString("configure_relay_title"));
        this.buttonPanel.setOkEnabled(true);
    }

    protected void doCancel() {
        this.fireActionPerformed(this, "cancel");
        super.doCancel();
    }

    protected void doOk() {
        if (this.serverList.getListSize() == 0) {
            JOptionPane.showMessageDialog(this, ResourceStrings.getString("configure_relay_err_server_list"), ResourceStrings.getString("input_error"), 0);
            return;
        }
        DhcpdOptions dhcpdOptions = new DhcpdOptions();
        dhcpdOptions.setDaemonEnabled(true);
        dhcpdOptions.setRelay(true, this.serverList.getAddressListString());
        try {
            DataManager.get().getDhcpServiceMgr().writeDefaults(dhcpdOptions);
            DataManager.get().getDhcpServiceMgr().startup();
            this.fireActionPerformed(this, "ok");
            ((Component)this).setVisible(false);
            this.dispose();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void fireActionPerformed() {
    }

    protected String getHelpKey() {
        return "configure_relay";
    }

    protected JPanel getMainPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(10, 20, 10, 20)));
        jPanel.add((Component)Wizard.createTextArea(ResourceStrings.getString("configure_relay_explain"), 3, 30), "North");
        this.serverList = new IPAddressList();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), ResourceStrings.getString("dhcp_servers"));
        this.serverList.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jPanel.add((Component)this.serverList, "South");
        return jPanel;
    }
}

