/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#ifndef _AUTOFS_PROT_H_RPCGEN
#define	_AUTOFS_PROT_H_RPCGEN

#include <rpc/rpc.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Copyright 1993-2002 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#pragma ident	"@(#)autofs_prot.x	1.19	02/07/12 SMI"

#include <sys/vfs.h>
#include <sys/dirent.h>
#include <sys/types.h>
#include <sys/types32.h>

#define	xdr_dev_t xdr_u_int
#define	xdr_bool_t xdr_bool

#define	AUTOFS_MAXPATHLEN 1024
#define	AUTOFS_MAXCOMPONENTLEN 255
#define	AUTOFS_MAXOPTSLEN 1024
#define	AUTOFS_DAEMONCOOKIE 100000

enum autofs_stat {
	AUTOFS_ACTION = 0,
	AUTOFS_DONE = 1
};
typedef enum autofs_stat autofs_stat;

enum autofs_action {
	AUTOFS_MOUNT_RQ = 0,
	AUTOFS_LINK_RQ = 1,
	AUTOFS_NONE = 2
};
typedef enum autofs_action autofs_action;

enum autofs_res {
	AUTOFS_OK = 0,
	AUTOFS_NOENT = 2,
	AUTOFS_ECOMM = 5,
	AUTOFS_NOMEM = 12,
	AUTOFS_NOTDIR = 20,
	AUTOFS_SHUTDOWN = 1000
};
typedef enum autofs_res autofs_res;

struct autofs_lookupargs {
	char *map;
	char *path;
	char *name;
	char *subdir;
	char *opts;
	bool_t isdirect;
};
typedef struct autofs_lookupargs autofs_lookupargs;

struct linka {
	char *dir;
	char *link;
};
typedef struct linka linka;

struct autofs_args {
	struct netbuf addr;
	char *path;
	char *opts;
	char *map;
	char *subdir;
	char *key;
	int mount_to;
	int rpc_to;
	int direct;
};
typedef struct autofs_args autofs_args;
#ifdef _SYSCALL32
/*
 * This is an LP64 representation of the ILP32 autofs_args data structure
 * for use by autofs_mount which may receive the data structure "raw"
 * from a 32-bit program without being processed by XDR.  rpcgen doesn't
 * need to see this structure since RPC/XDR only deals with the "native"
 * version of autofs_args.  If this isn't hidden from rpcgen then it will
 * insist on generating unnecessary code to deal with it.
 */
struct autofs_args32 {
	struct netbuf32	addr;		/* daemon address */
	caddr32_t	path;		/* autofs mountpoint */
	caddr32_t	opts;		/* default mount options */
	caddr32_t	map;		/* name of map */
	caddr32_t	subdir;		/* subdir within map */
	caddr32_t	key;		/* used in direct mounts */
	int32_t		mount_to;	/* time in sec the fs is to remain */
					/* mounted after last reference */
	int32_t		rpc_to;		/* timeout for rpc calls */
	int32_t		direct;		/* 1 = direct mount */
};
#endif	/* _SYSCALL32 */

struct action_list_entry {
	autofs_action action;
	union {
		struct mounta mounta;
		struct linka linka;
	} action_list_entry_u;
};
typedef struct action_list_entry action_list_entry;

struct action_list {
	action_list_entry action;
	struct action_list *next;
};
typedef struct action_list action_list;

struct mount_result_type {
	autofs_stat status;
	union {
		action_list *list;
		int error;
	} mount_result_type_u;
};
typedef struct mount_result_type mount_result_type;

struct autofs_mountres {
	mount_result_type mr_type;
	int mr_verbose;
};
typedef struct autofs_mountres autofs_mountres;

struct lookup_result_type {
	autofs_action action;
	union {
		struct linka lt_linka;
	} lookup_result_type_u;
};
typedef struct lookup_result_type lookup_result_type;

struct autofs_lookupres {
	enum autofs_res lu_res;
	lookup_result_type lu_type;
	int lu_verbose;
};
typedef struct autofs_lookupres autofs_lookupres;

struct umntrequest {
	bool_t isdirect;
	char *mntresource;
	char *mntpnt;
	char *fstype;
	char *mntopts;
	struct umntrequest *next;
};
typedef struct umntrequest umntrequest;

struct umntres {
	int status;
};
typedef struct umntres umntres;

struct autofs_rddirargs {
	char *rda_map;
	u_int rda_offset;
	u_int rda_count;
};
typedef struct autofs_rddirargs autofs_rddirargs;

struct autofsrddir {
	u_int rddir_offset;
	u_int rddir_size;
	bool_t rddir_eof;
	struct dirent64 *rddir_entries;
};
typedef struct autofsrddir autofsrddir;

struct autofs_rddirres {
	enum autofs_res rd_status;
	u_int rd_bufsize;
	struct autofsrddir rd_rddir;
};
typedef struct autofs_rddirres autofs_rddirres;

#define	AUTOFS_PROG	100099
#define	AUTOFS_VERS	4

#if defined(__STDC__) || defined(__cplusplus)
#define	AUTOFS_NULL	0
extern  void * autofs_null_4(void *, CLIENT *);
extern  void * autofs_null_4_svc(void *, struct svc_req *);
#define	AUTOFS_MOUNT	1
extern  autofs_mountres * autofs_mount_4(autofs_lookupargs *, CLIENT *);
extern  autofs_mountres * autofs_mount_4_svc(autofs_lookupargs *, struct svc_req *);
#define	AUTOFS_UNMOUNT	2
extern  umntres * autofs_unmount_4(umntrequest *, CLIENT *);
extern  umntres * autofs_unmount_4_svc(umntrequest *, struct svc_req *);
#define	AUTOFS_READDIR	3
extern  autofs_rddirres * autofs_readdir_4(autofs_rddirargs *, CLIENT *);
extern  autofs_rddirres * autofs_readdir_4_svc(autofs_rddirargs *, struct svc_req *);
#define	AUTOFS_LOOKUP	4
extern  autofs_lookupres * autofs_lookup_4(autofs_lookupargs *, CLIENT *);
extern  autofs_lookupres * autofs_lookup_4_svc(autofs_lookupargs *, struct svc_req *);
extern int autofs_prog_4_freeresult(SVCXPRT *, xdrproc_t, caddr_t);

#else /* K&R C */
#define	AUTOFS_NULL	0
extern  void * autofs_null_4();
extern  void * autofs_null_4_svc();
#define	AUTOFS_MOUNT	1
extern  autofs_mountres * autofs_mount_4();
extern  autofs_mountres * autofs_mount_4_svc();
#define	AUTOFS_UNMOUNT	2
extern  umntres * autofs_unmount_4();
extern  umntres * autofs_unmount_4_svc();
#define	AUTOFS_READDIR	3
extern  autofs_rddirres * autofs_readdir_4();
extern  autofs_rddirres * autofs_readdir_4_svc();
#define	AUTOFS_LOOKUP	4
extern  autofs_lookupres * autofs_lookup_4();
extern  autofs_lookupres * autofs_lookup_4_svc();
extern int autofs_prog_4_freeresult();
#endif /* K&R C */

/* the xdr functions */

#if defined(__STDC__) || defined(__cplusplus)
extern  bool_t xdr_autofs_stat(XDR *, autofs_stat*);
extern  bool_t xdr_autofs_action(XDR *, autofs_action*);
extern  bool_t xdr_autofs_res(XDR *, autofs_res*);
extern  bool_t xdr_autofs_lookupargs(XDR *, autofs_lookupargs*);
extern  bool_t xdr_linka(XDR *, linka*);
extern  bool_t xdr_autofs_args(XDR *, autofs_args*);
extern  bool_t xdr_action_list_entry(XDR *, action_list_entry*);
extern  bool_t xdr_action_list(XDR *, action_list*);
extern  bool_t xdr_mount_result_type(XDR *, mount_result_type*);
extern  bool_t xdr_autofs_mountres(XDR *, autofs_mountres*);
extern  bool_t xdr_lookup_result_type(XDR *, lookup_result_type*);
extern  bool_t xdr_autofs_lookupres(XDR *, autofs_lookupres*);
extern  bool_t xdr_umntrequest(XDR *, umntrequest*);
extern  bool_t xdr_umntres(XDR *, umntres*);
extern  bool_t xdr_autofs_rddirargs(XDR *, autofs_rddirargs*);
extern  bool_t xdr_autofsrddir(XDR *, autofsrddir*);
extern  bool_t xdr_autofs_rddirres(XDR *, autofs_rddirres*);

#else /* K&R C */
extern bool_t xdr_autofs_stat();
extern bool_t xdr_autofs_action();
extern bool_t xdr_autofs_res();
extern bool_t xdr_autofs_lookupargs();
extern bool_t xdr_linka();
extern bool_t xdr_autofs_args();
extern bool_t xdr_action_list_entry();
extern bool_t xdr_action_list();
extern bool_t xdr_mount_result_type();
extern bool_t xdr_autofs_mountres();
extern bool_t xdr_lookup_result_type();
extern bool_t xdr_autofs_lookupres();
extern bool_t xdr_umntrequest();
extern bool_t xdr_umntres();
extern bool_t xdr_autofs_rddirargs();
extern bool_t xdr_autofsrddir();
extern bool_t xdr_autofs_rddirres();

#endif /* K&R C */

#ifdef __cplusplus
}
#endif

#endif /* !_AUTOFS_PROT_H_RPCGEN */
