
/*
 * Copyright (c) 1999-2000 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef _I2C_CLIENT_H
#define	_I2C_CLIENT_H

#pragma ident	"@(#)i2c_client.h	1.1	00/01/03 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * Common IOCTL definitions for client drivers.
 */

#define	I2C_BASE_IOCTL	('M' << 8)

#define	I2C_GET_PORT		(I2C_BASE_IOCTL | 0)
#define	I2C_SET_PORT		(I2C_BASE_IOCTL | 1)
#define	I2C_GET_BIT		(I2C_BASE_IOCTL | 2)
#define	I2C_SET_BIT		(I2C_BASE_IOCTL | 3)
#define	I2C_GET_REG		(I2C_BASE_IOCTL | 4)
#define	I2C_SET_REG		(I2C_BASE_IOCTL | 5)
#define	I2C_SELF_TEST		(I2C_BASE_IOCTL | 6)
#define	I2C_GET_TEMPERATURE	(I2C_BASE_IOCTL | 7)
#define	I2C_GET_FAN_SPEED	(I2C_BASE_IOCTL | 8)
#define	I2C_SET_FAN_SPEED	(I2C_BASE_IOCTL | 9)
#define	I2C_SET_OUTPUT		(I2C_BASE_IOCTL | 10)
#define	I2C_GET_OUTPUT		(I2C_BASE_IOCTL | 11)
#define	I2C_GET_INPUT		(I2C_BASE_IOCTL | 12)
#define	I2C_SET_MODE		(I2C_BASE_IOCTL | 13)
#define	I2C_GET_MODE		(I2C_BASE_IOCTL | 14)

/*
 * ARGS for I2C_*_MODE
 */
#define	I2C_NORMAL	0
#define	I2C_DEBUG	1

#ifdef	__cplusplus
}
#endif

#endif /* _I2C_CLIENT_H */
