/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.MailSync;

import com.sun.pdasync.Conduits.MailSync.MailPasswdKey;
import com.sun.pdasync.Conduits.MailSync.MailPasswdProtector;
import com.sun.pdasync.Conduits.MailSync.MailSyncProperties;
import com.sun.pdasync.Conduits.MailSync.UnrecoverablePasswdException;
import com.sun.pdasync.SharedUI.CommandPane;
import com.sun.pdasync.SharedUI.PDASyncHelp;
import com.sun.pdasync.SharedUI.PropsUI;
import com.sun.pdasync.SharedUI.SyncIcons;
import com.sun.pdasync.SyncUtils.SyncConstants;
import com.sun.pdasync.SyncUtils.SyncUtils;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.ResourceBundle;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.mail.PasswordAuthentication;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public final class MailSyncUI {
    private static Locale theLocale;
    private static ResourceBundle mailRes;
    private static ResourceBundle mailTips;
    private static ResourceBundle commonRes;
    private static ResourceBundle commonTips;
    private static final int FIELD_LEN = 14;
    private static final String PASSWORD_FILE = ".MailSyncConduitExtra.def";
    private static final String passwdFile;
    private MailSyncPropsUI mailPropsUI;
    private MailSyncLogin mailLogin;
    private MailSyncProperties mailSyncProps;
    private boolean isPropsUIShown;
    private boolean isLoginShown;
    private boolean isLoginContinue;
    private boolean cancelAuthentication;
    private Thread savePasswordThread = null;

    static {
        try {
            theLocale = Locale.getDefault();
            mailRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.MailSyncUIMessages", theLocale);
            commonRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.CommonUIMessages", theLocale);
            mailTips = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.MailSyncUITips", theLocale);
            commonTips = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.CommonTips", theLocale);
        }
        catch (MissingResourceException e) {
            System.err.println("PDASync: can't find properties");
            System.err.println("PDASync:" + e.getMessage());
            System.exit(1);
        }
        passwdFile = new String(String.valueOf(SyncConstants.USER_PROPS_DIR_PATH) + PASSWORD_FILE);
    }

    public MailSyncUI(JFrame parent, MailSyncProperties mailProps) {
        this.mailSyncProps = mailProps;
        this.mailPropsUI = new MailSyncPropsUI(parent);
        this.mailLogin = new MailSyncLogin(parent);
        this.isLoginShown = false;
        this.isPropsUIShown = false;
    }

    static /* synthetic */ Thread access$2(MailSyncUI $0) {
        return $0.savePasswordThread;
    }

    static /* synthetic */ void access$3(MailSyncUI $0, Thread $1) {
        $0.savePasswordThread = $1;
    }

    static /* synthetic */ boolean access$7(MailSyncUI $0) {
        return $0.isLoginContinue;
    }

    static /* synthetic */ void access$8(MailSyncUI $0, boolean $1) {
        $0.isLoginContinue = $1;
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        PasswordAuthentication auth;
        this.cancelAuthentication = false;
        if (this.isLoginShown) {
            if (this.isLoginContinue) {
                auth = new PasswordAuthentication(this.mailSyncProps.loginText, new String(this.mailLogin.passwdText.getPassword()));
            } else {
                this.cancelAuthentication = true;
                auth = null;
            }
        } else if (this.isPropsUIShown) {
            char[] passwd = this.mailPropsUI.passwdText.getPassword();
            auth = passwd == null || passwd.length == 0 ? null : new PasswordAuthentication(this.mailSyncProps.loginText, new String(this.mailPropsUI.passwdText.getPassword()));
            if (passwd != null) {
                SyncUtils.fillArray((char[])passwd, (byte)0);
                passwd = null;
            }
        } else if (this.mailSyncProps.saveLogin) {
            byte[] plainPasswd = this.readPassword();
            if (plainPasswd == null) {
                auth = null;
            } else {
                auth = new PasswordAuthentication(this.mailSyncProps.loginText, new String(plainPasswd));
                SyncUtils.fillArray((byte[])plainPasswd, (byte)0);
            }
        } else {
            auth = null;
        }
        if (!this.mailSyncProps.saveLogin) {
            this.removePasswdFile();
        }
        return auth;
    }

    public boolean isLoginCanceled() {
        return this.cancelAuthentication;
    }

    public static void main(String[] args) {
        JFrame fr = new JFrame("MailSync Test");
        WindowAdapter winEvents = new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }
        };
        fr.addWindowListener(winEvents);
        JButton showProps = new JButton("Show Props");
        JButton showLogin = new JButton("Show Login");
        JPanel pane = new JPanel();
        pane.add(showProps);
        pane.add(showLogin);
        pane.validate();
        fr.setContentPane(pane);
        fr.pack();
        MailSyncProperties mailProps = new MailSyncProperties();
        MailSyncUI mailUI = new MailSyncUI(fr, mailProps);
        ActionListener showDialog = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (ev.getActionCommand().equals("Show Props")) {
                    MailSyncUI.this.showPropsUI();
                    MailSyncUI.this.setResizableOfProps(false);
                } else {
                    MailSyncUI.this.showLogin();
                    MailSyncUI.this.setResizableOfLogin(false);
                }
            }
        };
        showProps.addActionListener(showDialog);
        showLogin.addActionListener(showDialog);
        ((Component)fr).setVisible(true);
    }

    private byte[] readPassword() {
        byte[] password;
        MailPasswdProtector protector;
        byte[] byArray;
        byte[] bytes;
        int seed;
        block24: {
            File file = new File(passwdFile);
            if (!file.exists()) {
                return null;
            }
            if (this.savePasswordThread != null) {
                try {
                    this.savePasswordThread.join();
                }
                catch (InterruptedException interruptedException) {}
                this.savePasswordThread = null;
            }
            DataInputStream in = null;
            seed = -1;
            bytes = null;
            try {
                try {
                    in = new DataInputStream(new FileInputStream(passwdFile));
                    seed = in.readInt();
                    int size = in.available();
                    bytes = new byte[size];
                    in.read(bytes);
                }
                catch (Exception exception) {
                    System.out.println("Cannot read password.");
                    byte[] byArray2 = null;
                    Object var7_9 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                        in = null;
                    }
                    return byArray2;
                }
                byArray = null;
                if (in == null) break block24;
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    in = null;
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
            in = null;
        }
        MailPasswdKey key = new MailPasswdKey(seed);
        try {
            try {
                protector = new MailPasswdProtector(key);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                System.out.println("Cannot recover password: Algorithm is not supported");
                byArray = null;
                Object var9_14 = null;
                if (key != null) {
                    key = null;
                }
                return byArray;
            }
            Object var9_15 = null;
            if (key != null) {
                key = null;
            }
        }
        catch (Throwable size) {
            Object var9_16 = null;
            if (key != null) {
                key = null;
            }
            throw size;
        }
        try {
            password = protector.recover(bytes);
        }
        catch (UnrecoverablePasswdException unrecoverablePasswdException) {
            System.out.println("Cannot recover password.");
            return null;
        }
        return password;
    }

    private void removePasswdFile() {
        File file = new File(passwdFile);
        if (file.exists()) {
            file.delete();
        }
        file = null;
    }

    public void setResizableOfLogin(boolean state) {
        this.mailLogin.setResizable(state);
    }

    public void setResizableOfProps(boolean state) {
        ((Dialog)((Object)this.mailPropsUI)).setResizable(state);
    }

    public void showLogin() {
        this.isLoginShown = true;
        this.isLoginContinue = false;
        this.mailLogin.updateUI();
        this.mailLogin.initFlags();
        this.mailLogin.show();
    }

    public void showPropsUI() {
        this.isPropsUIShown = true;
        this.mailPropsUI.setDialogParameters();
        this.mailPropsUI.initFlags();
        ((Dialog)((Object)this.mailPropsUI)).show();
    }

    private final class MailSyncPropsUI
    extends PropsUI {
        protected JPanel mailPanel;
        protected ServerPanel serverPanel;
        protected JRadioButton imapServer;
        protected JRadioButton localMbox;
        protected JTextField serverText;
        protected JTextField loginText;
        protected JPasswordField passwdText;
        protected JCheckBox saveLogin;
        protected JTextField localText;
        protected JCheckBox dtOverwritesPDA;

        public MailSyncPropsUI(JFrame parent) {
            super(parent, mailRes.getString("Configure Mail Conduit"));
            this.userProperties = MailSyncUI.this.mailSyncProps;
            this.setDialogMessage(this.createPropsPanel());
            ((JDialog)((Object)this)).setContentPane(this.propsOptions);
            this.ok.addActionListener(new ActionListener(this){
                private final /* synthetic */ MailSyncPropsUI this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ev) {
                    if (ServerPanel.access$0(this.this$1.serverPanel)) {
                        if (this.this$1.imapServer.isSelected()) {
                            MailSyncUI mailSyncUI = MailSyncPropsUI.access$0(this.this$1);
                            mailSyncUI.getClass();
                            SavePassword sp = mailSyncUI.new SavePassword(this.this$1.passwdText, this.this$1.saveLogin);
                            MailSyncUI.access$3(MailSyncPropsUI.access$0(this.this$1), new Thread(sp));
                            MailSyncUI.access$2(MailSyncPropsUI.access$0(this.this$1)).start();
                        }
                        ServerPanel.access$1(this.this$1.serverPanel, false);
                    }
                }
            });
            ((Container)((Object)this)).validate();
            ((Window)((Object)this)).pack();
        }

        static /* synthetic */ MailSyncUI access$0(MailSyncPropsUI $0) {
            return $0.MailSyncUI.this;
        }

        private Object createPropsPanel() {
            HelpBroker helpBroker = null;
            PropsUI.PropsUIChangeListener propsChangedListener = new PropsUI.PropsUIChangeListener((PropsUI)this);
            this.mailPanel = new JPanel(new GridBagLayout(), true){

                public Insets getInsets() {
                    return new Insets(0, 0, 0, 10);
                }
            };
            int gridY = 0;
            JLabel otherSyncOptions = new JLabel(mailRes.getString("Other mail synchronization options are"));
            JLabel otherSyncOptions2 = new JLabel(mailRes.getString("configured on the PalmPilot"));
            try {
                CommandPane.addComponent((Container)this.mailPanel, (Component)otherSyncOptions, (int)0, (int)gridY, (int)0, (int)1, (int)1, (int)17, (Insets)new Insets(10, 0, 0, 15));
                ++gridY;
            }
            catch (AWTException aWTException) {}
            try {
                CommandPane.addComponent((Container)this.mailPanel, (Component)otherSyncOptions2, (int)0, (int)-1, (int)0, (int)1, (int)1, (int)17, null);
                ++gridY;
            }
            catch (AWTException aWTException) {}
            JLabel inboxLabel = new JLabel(mailRes.getString("INBOX Location:"));
            try {
                CommandPane.addComponent((Container)this.mailPanel, (Component)inboxLabel, (int)0, (int)gridY, (int)0, (int)1, (int)1, (int)17, (Insets)new Insets(15, 0, 0, 0));
                ++gridY;
            }
            catch (AWTException aWTException) {}
            ButtonGroup inboxGroup = new ButtonGroup();
            this.imapServer = new JRadioButton(mailRes.getString("IMAP"));
            this.localMbox = new JRadioButton(mailRes.getString("Local"));
            ProtocolRadioButtonListener protocalRadioButtonListener = new ProtocolRadioButtonListener();
            this.imapServer.addActionListener(protocalRadioButtonListener);
            this.localMbox.addActionListener(protocalRadioButtonListener);
            inboxGroup.add(this.imapServer);
            inboxGroup.add(this.localMbox);
            JPanel imapPanel = new JPanel(new GridBagLayout(), true);
            try {
                CommandPane.addComponent((Container)imapPanel, (Component)this.imapServer, (int)0, (int)0, (int)1, (int)1, (int)3, (int)17, (Insets)new Insets(10, 0, 0, 0));
            }
            catch (AWTException aWTException) {}
            this.serverPanel = new ServerPanel(mailRes.getString("IMAP"), (DocumentListener)propsChangedListener, (ItemListener)propsChangedListener);
            try {
                CommandPane.addComponent((Container)imapPanel, (Component)this.serverPanel.getPanel(), (int)0, (int)1, (int)0, (int)1, (int)0, (int)17, (Insets)new Insets(5, 0, 0, 0));
            }
            catch (AWTException aWTException) {}
            this.serverText = this.serverPanel.serverText;
            this.loginText = this.serverPanel.loginText;
            this.passwdText = this.serverPanel.passwdText;
            this.saveLogin = this.serverPanel.saveLogin;
            try {
                CommandPane.addComponent((Container)this.mailPanel, (Component)imapPanel, (int)0, (int)gridY, (int)0, (int)1, (int)3, (int)17, (Insets)new Insets(0, 10, 0, 0));
                ++gridY;
            }
            catch (AWTException aWTException) {}
            JPanel localPanel = new JPanel(new GridBagLayout(), true);
            try {
                CommandPane.addComponent((Container)localPanel, (Component)this.localMbox, (int)0, (int)0, (int)1, (int)1, (int)1, (int)17, (Insets)new Insets(10, 0, 0, 0));
            }
            catch (AWTException aWTException) {}
            this.localText = new JTextField(14);
            this.localText.setToolTipText(mailTips.getString("Local Mailbox Location"));
            this.localText.getDocument().addDocumentListener((DocumentListener)propsChangedListener);
            try {
                CommandPane.addComponent((Container)localPanel, (Component)this.localText, (int)1, (int)1, (int)1, (int)1, (int)0, (int)17, (Insets)new Insets(5, 13, 0, 0));
            }
            catch (AWTException aWTException) {}
            try {
                CommandPane.addComponent((Container)this.mailPanel, (Component)localPanel, (int)0, (int)gridY, (int)0, (int)1, (int)3, (int)17, (Insets)new Insets(0, 10, 0, 0));
                ++gridY;
            }
            catch (AWTException aWTException) {}
            this.dtOverwritesPDA = new JCheckBox(mailRes.getString("Desktop overwrites PDA"), true);
            this.dtOverwritesPDA.setToolTipText(mailTips.getString("Desktop overwrites PDA"));
            this.dtOverwritesPDA.addItemListener((ItemListener)propsChangedListener);
            try {
                CommandPane.addComponent((Container)this.mailPanel, (Component)this.dtOverwritesPDA, (int)0, (int)gridY, (int)0, (int)1, (int)1, (int)17, (Insets)new Insets(15, 0, 10, 0));
                ++gridY;
            }
            catch (AWTException aWTException) {}
            try {
                CommandPane.addComponent((Container)this.mailPanel, (Component)new JSeparator(), (int)0, (int)gridY, (int)0, (int)1, (int)1, (int)10, null);
            }
            catch (AWTException aWTException) {}
            this.setDialogParameters();
            helpBroker = PDASyncHelp.enableContextHelp((Component)this.help, (String)"pda_mailConfig");
            if (helpBroker == null) {
                this.help.setEnabled(false);
            } else {
                this.help.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(helpBroker));
            }
            ((Container)((Object)this)).validate();
            ((Window)((Object)this)).pack();
            this.initFlags();
            return this.mailPanel;
        }

        public void initFlags() {
            this.propsChanged = false;
            this.serverPanel.passwdChanged = false;
        }

        public void setDialogParameters() {
            if (((MailSyncUI)MailSyncUI.this).mailSyncProps.mailProtocol == 1) {
                this.setServerFields(true);
                this.setLocalFields(false);
            } else {
                this.setServerFields(false);
                this.setLocalFields(true);
            }
            this.dtOverwritesPDA.setSelected(((MailSyncUI)MailSyncUI.this).mailSyncProps.dtOverwritesPDA);
        }

        private void setLocalFields(boolean state) {
            if (state) {
                this.localMbox.setSelected(state);
            }
            this.localText.setText(((MailSyncUI)MailSyncUI.this).mailSyncProps.localText);
            this.localText.setEnabled(state);
        }

        private void setServerFields(boolean state) {
            if (state) {
                this.imapServer.setSelected(state);
            }
            this.serverPanel.setServerFields();
            this.setServerFieldsEnabled(state);
        }

        private void setServerFieldsEnabled(boolean state) {
            this.serverText.setEnabled(state);
            this.loginText.setEnabled(state);
            this.passwdText.setEnabled(state);
            this.saveLogin.setEnabled(state);
        }

        public void updateFromUI() {
            ((MailSyncUI)MailSyncUI.this).mailSyncProps.mailProtocol = this.imapServer.isSelected() ? 1 : 2;
            ((MailSyncUI)MailSyncUI.this).mailSyncProps.serverText = this.serverText.getText();
            ((MailSyncUI)MailSyncUI.this).mailSyncProps.loginText = this.loginText.getText();
            ((MailSyncUI)MailSyncUI.this).mailSyncProps.saveLogin = this.saveLogin.isSelected();
            ((MailSyncUI)MailSyncUI.this).mailSyncProps.localText = this.localText.getText();
            ((MailSyncUI)MailSyncUI.this).mailSyncProps.dtOverwritesPDA = this.dtOverwritesPDA.isSelected();
        }

        class ProtocolRadioButtonListener
        implements ActionListener {
            ProtocolRadioButtonListener() {
            }

            public void actionPerformed(ActionEvent ev) {
                MailSyncPropsUI.this.propsChanged = true;
                if (ev.getActionCommand().equals(mailRes.getString("IMAP"))) {
                    MailSyncPropsUI.this.setServerFieldsEnabled(true);
                    MailSyncPropsUI.this.localText.setEnabled(false);
                } else {
                    MailSyncPropsUI.this.setServerFieldsEnabled(false);
                    MailSyncPropsUI.this.localText.setEnabled(true);
                }
            }
        }
    }

    private final class MailSyncLogin
    extends JDialog {
        protected JOptionPane loginOptions = new JOptionPane();
        protected ServerPanel serverPanel;
        protected JTextField serverText;
        protected JTextField loginText;
        protected JPasswordField passwdText;
        protected JCheckBox saveLogin;
        protected JButton contBtn;
        protected JButton cancelBtn;
        protected JButton helpBtn;
        protected boolean propsChanged;

        public MailSyncLogin(JFrame parent) {
            super(parent, mailRes.getString("Mail Login"), true);
            JPanel loginPane = new JPanel(new GridBagLayout(), false){

                public Insets getInsets() {
                    return new Insets(0, 0, 0, 10);
                }
            };
            int gridY = 0;
            JLabel label1 = new JLabel(mailRes.getString("To continue with mail synchronization,"));
            JLabel label2 = new JLabel(mailRes.getString("please fill in these fields:"));
            try {
                CommandPane.addComponent((Container)loginPane, (Component)label1, (int)0, (int)gridY, (int)0, (int)1, (int)1, (int)17, (Insets)new Insets(10, 0, 0, 0));
                ++gridY;
            }
            catch (AWTException aWTException) {}
            try {
                CommandPane.addComponent((Container)loginPane, (Component)label2, (int)0, (int)-1, (int)0, (int)1, (int)1, (int)17, null);
                ++gridY;
            }
            catch (AWTException aWTException) {}
            LoginPropsListener loginPropsListener = new LoginPropsListener();
            MailSyncUI mailSyncUI = MailSyncUI.this;
            mailSyncUI.getClass();
            this.serverPanel = mailSyncUI.new ServerPanel(mailRes.getString("Login"), loginPropsListener, loginPropsListener);
            try {
                CommandPane.addComponent((Container)loginPane, (Component)this.serverPanel.getPanel(), (int)0, (int)gridY, (int)1, (int)1, (int)1, (int)17, (Insets)new Insets(15, 0, 0, 0));
                ++gridY;
            }
            catch (AWTException aWTException) {}
            this.serverText = this.serverPanel.serverText;
            this.loginText = this.serverPanel.loginText;
            this.passwdText = this.serverPanel.passwdText;
            this.saveLogin = this.serverPanel.saveLogin;
            this.passwdText.setActionCommand("Continue");
            this.updateUI();
            try {
                CommandPane.addComponent((Container)loginPane, (Component)new JSeparator(), (int)0, (int)gridY, (int)0, (int)1, (int)1, (int)10, (Insets)new Insets(10, 0, 0, 0));
                ++gridY;
            }
            catch (AWTException aWTException) {}
            int btnCnt = 0;
            this.contBtn = new JButton(commonRes.getString("Continue"));
            this.contBtn.setToolTipText(mailTips.getString("Continue with Mail Synchronization."));
            this.contBtn.setMargin(new Insets(4, 4, 4, 4));
            this.contBtn.setActionCommand("Continue");
            ++btnCnt;
            this.cancelBtn = new JButton(commonRes.getString("Cancel"));
            this.cancelBtn.setToolTipText(commonTips.getString("Dismiss dialog."));
            this.cancelBtn.setMargin(new Insets(4, 4, 4, 4));
            this.cancelBtn.setActionCommand("Cancel");
            ++btnCnt;
            this.helpBtn = new JButton(SyncIcons.HELP);
            this.helpBtn.setToolTipText(commonTips.getString("Display help."));
            this.helpBtn.setMargin(new Insets(-1, -1, -1, -1));
            ++btnCnt;
            HelpBroker helpBroker = PDASyncHelp.enableContextHelp((Component)this.helpBtn, (String)"pda_mailConfig");
            if (helpBroker == null) {
                this.helpBtn.setEnabled(false);
            } else {
                this.helpBtn.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(helpBroker));
            }
            this.loginOptions.setMessage(loginPane);
            this.loginOptions.setMessageType(-1);
            Object[] buttons = new Object[btnCnt];
            buttons[0] = this.contBtn;
            buttons[1] = this.cancelBtn;
            buttons[2] = this.helpBtn;
            this.loginOptions.setOptions(buttons);
            this.loginOptions.setOptionType(-1);
            this.loginOptions.setInitialValue(this.contBtn);
            this.loginOptions.validate();
            ActionListener enterLogin = new ActionListener(this){
                private final /* synthetic */ MailSyncLogin this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ev) {
                    String cmd = ev.getActionCommand();
                    if (cmd.equals("Continue")) {
                        MailSyncUI.access$8(MailSyncLogin.access$0(this.this$1), true);
                        if (this.this$1.propsChanged) {
                            this.this$1.updateFromUI();
                            MailSyncUI.access$1(MailSyncLogin.access$0(this.this$1)).saveProperties();
                            this.this$1.propsChanged = false;
                        }
                        if (this.this$1.saveLogin.isSelected() && ServerPanel.access$0(this.this$1.serverPanel)) {
                            MailSyncUI mailSyncUI = MailSyncLogin.access$0(this.this$1);
                            mailSyncUI.getClass();
                            SavePassword sp = mailSyncUI.new SavePassword(this.this$1.passwdText, this.this$1.saveLogin);
                            MailSyncUI.access$3(MailSyncLogin.access$0(this.this$1), new Thread(sp));
                            MailSyncUI.access$2(MailSyncLogin.access$0(this.this$1)).start();
                            ServerPanel.access$1(this.this$1.serverPanel, false);
                        }
                    } else {
                        MailSyncUI.access$8(MailSyncLogin.access$0(this.this$1), false);
                    }
                    ((Component)this.this$1).setVisible(false);
                }
            };
            this.passwdText.addActionListener(enterLogin);
            this.contBtn.addActionListener(enterLogin);
            this.cancelBtn.addActionListener(enterLogin);
            this.setContentPane(this.loginOptions);
            this.validate();
            this.pack();
            this.initFlags();
        }

        static /* synthetic */ MailSyncUI access$0(MailSyncLogin $0) {
            return $0.MailSyncUI.this;
        }

        public void initFlags() {
            this.propsChanged = false;
            this.serverPanel.passwdChanged = false;
        }

        public void updateFromUI() {
            ((MailSyncUI)MailSyncUI.this).mailSyncProps.serverText = this.serverText.getText();
            ((MailSyncUI)MailSyncUI.this).mailSyncProps.loginText = this.loginText.getText();
            ((MailSyncUI)MailSyncUI.this).mailSyncProps.saveLogin = this.saveLogin.isSelected();
        }

        public void updateUI() {
            this.serverPanel.setServerFields();
        }

        private class LoginPropsListener
        implements DocumentListener,
        ItemListener {
            LoginPropsListener() {
            }

            public void changedUpdate(DocumentEvent e) {
                MailSyncLogin.this.propsChanged = true;
            }

            public void insertUpdate(DocumentEvent e) {
                MailSyncLogin.this.propsChanged = true;
            }

            public void itemStateChanged(ItemEvent ev) {
                MailSyncLogin.this.propsChanged = true;
            }

            public void removeUpdate(DocumentEvent e) {
                MailSyncLogin.this.propsChanged = true;
            }
        }
    }

    private class ServerPanel {
        private JPanel serverPanel = new JPanel(new GridBagLayout(), true);
        private JTextField serverText;
        private JTextField loginText;
        private JPasswordField passwdText;
        private JCheckBox saveLogin;
        private boolean passwdChanged;

        public ServerPanel(String dialogName, DocumentListener textfListener, ItemListener chkboxListener) {
            int leftInset;
            JLabel serverLabel;
            if (dialogName.equals(mailRes.getString("Login"))) {
                serverLabel = new JLabel(mailRes.getString("IMAP Server:"));
                leftInset = 70;
            } else {
                serverLabel = new JLabel(mailRes.getString("Server:"));
                leftInset = 50;
            }
            try {
                CommandPane.addComponent((Container)this.serverPanel, (Component)serverLabel, (int)0, (int)1, (int)1, (int)1, (int)3, (int)13, (Insets)new Insets(0, 0, 0, 2));
            }
            catch (AWTException aWTException) {}
            this.serverText = new JTextField("jurassic.eng", 14);
            this.serverText.setToolTipText(mailTips.getString("Mail Server - server.domain"));
            this.serverText.getDocument().addDocumentListener(textfListener);
            try {
                CommandPane.addComponent((Container)this.serverPanel, (Component)this.serverText, (int)1, (int)1, (int)1, (int)1, (int)3, (int)17, (Insets)new Insets(0, 5, 0, 0));
            }
            catch (AWTException aWTException) {}
            JLabel loginLabel = new JLabel(mailRes.getString("Login:"));
            try {
                CommandPane.addComponent((Container)this.serverPanel, (Component)loginLabel, (int)0, (int)2, (int)1, (int)1, (int)3, (int)13, (Insets)new Insets(5, 0, 0, 2));
            }
            catch (AWTException aWTException) {}
            this.loginText = new JTextField("mcapucci", 14);
            this.loginText.setToolTipText(mailTips.getString("Login - IMAP account name"));
            this.loginText.getDocument().addDocumentListener(textfListener);
            try {
                CommandPane.addComponent((Container)this.serverPanel, (Component)this.loginText, (int)1, (int)2, (int)1, (int)1, (int)0, (int)17, (Insets)new Insets(5, 5, 0, 0));
            }
            catch (AWTException aWTException) {}
            JLabel passwordLabel = new JLabel(mailRes.getString("Password:"));
            try {
                CommandPane.addComponent((Container)this.serverPanel, (Component)passwordLabel, (int)0, (int)3, (int)1, (int)1, (int)3, (int)13, (Insets)new Insets(5, 0, 0, 2));
            }
            catch (AWTException aWTException) {}
            this.passwdText = new JPasswordField("", 14);
            this.passwdText.setToolTipText(mailTips.getString("Account Password"));
            this.passwdText.getDocument().addDocumentListener(new DocumentListener(this){
                private final /* synthetic */ ServerPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void changedUpdate(DocumentEvent e) {
                    ServerPanel.access$1(this.this$1, true);
                }

                public void insertUpdate(DocumentEvent e) {
                    ServerPanel.access$1(this.this$1, true);
                }

                public void removeUpdate(DocumentEvent e) {
                    ServerPanel.access$1(this.this$1, true);
                }
            });
            try {
                CommandPane.addComponent((Container)this.serverPanel, (Component)this.passwdText, (int)1, (int)3, (int)1, (int)1, (int)0, (int)17, (Insets)new Insets(5, 5, 0, 0));
            }
            catch (AWTException aWTException) {}
            this.saveLogin = new JCheckBox("  " + mailRes.getString("Save login and password"), true);
            this.saveLogin.setToolTipText(mailTips.getString("Save login and password"));
            this.saveLogin.addItemListener(chkboxListener);
            try {
                CommandPane.addComponent((Container)this.serverPanel, (Component)this.saveLogin, (int)0, (int)4, (int)2, (int)1, (int)0, (int)17, (Insets)new Insets(5, leftInset, 0, 0));
            }
            catch (AWTException aWTException) {}
        }

        static /* synthetic */ boolean access$0(ServerPanel $0) {
            return $0.passwdChanged;
        }

        JPanel getPanel() {
            return this.serverPanel;
        }

        void setServerFields() {
            this.serverText.setText(((MailSyncUI)MailSyncUI.this).mailSyncProps.serverText);
            this.saveLogin.setSelected(((MailSyncUI)MailSyncUI.this).mailSyncProps.saveLogin);
            this.loginText.setText(((MailSyncUI)MailSyncUI.this).mailSyncProps.loginText);
            if (((MailSyncUI)MailSyncUI.this).mailSyncProps.saveLogin) {
                byte[] plainBytes = MailSyncUI.this.readPassword();
                if (plainBytes != null) {
                    ((JTextComponent)this.passwdText).setText(new String(plainBytes));
                    SyncUtils.fillArray((byte[])plainBytes, (byte)0);
                } else {
                    ((JTextComponent)this.passwdText).setText(null);
                }
                Object var1_1 = null;
            }
        }
    }

    private class SavePassword
    implements Runnable {
        JPasswordField passwdText;
        JCheckBox saveLogin;

        public SavePassword(JPasswordField passwdText, JCheckBox saveLogin) {
            this.passwdText = passwdText;
            this.saveLogin = saveLogin;
        }

        public synchronized void run() {
            boolean changeMode;
            byte[] bytes;
            MailPasswdKey key;
            FilterOutputStream out;
            block19: {
                if (!this.saveLogin.isSelected()) {
                    MailSyncUI.this.removePasswdFile();
                    return;
                }
                File file = new File(passwdFile);
                out = null;
                key = null;
                bytes = null;
                changeMode = false;
                int seed = new Random().nextInt();
                char[] password = this.passwdText.getPassword();
                if (password.length == 0) {
                    System.out.println("Not save the empty password");
                    return;
                }
                try {
                    try {
                        key = new MailPasswdKey(seed);
                        MailPasswdProtector protector = new MailPasswdProtector(key);
                        bytes = protector.protect(password);
                        if (file.exists()) {
                            file.delete();
                            file = null;
                        }
                        out = new DataOutputStream(new FileOutputStream(passwdFile));
                        ((DataOutputStream)out).writeInt(seed);
                        out.write(bytes);
                        changeMode = true;
                    }
                    catch (Exception exception) {
                        System.out.println("Cannot save password.");
                    }
                    Object var9_9 = null;
                    if (password == null) break block19;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    if (password != null) {
                        SyncUtils.fillArray((char[])password, (byte)0);
                        password = null;
                    }
                    if (key != null) {
                        key = null;
                    }
                    if (bytes != null) {
                        SyncUtils.fillArray(bytes, (byte)0);
                        bytes = null;
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                        out = null;
                    }
                    if (changeMode) {
                        SyncUtils.setFilePermission((String)passwdFile, (String)"400");
                    }
                    throw throwable;
                }
                SyncUtils.fillArray((char[])password, (byte)0);
                password = null;
            }
            if (key != null) {
                key = null;
            }
            if (bytes != null) {
                SyncUtils.fillArray((byte[])bytes, (byte)0);
                bytes = null;
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
                out = null;
            }
            if (changeMode) {
                SyncUtils.setFilePermission((String)passwdFile, (String)"400");
            }
        }
    }
}

