/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.MailSync;

import com.sun.pdasync.Properties.UserProps;
import com.sun.pdasync.SyncUtils.ObjDump;
import com.sun.pdasync.SyncUtils.SyncConstants;
import com.sun.pdasync.SyncUtils.SyncUtils;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class MailSyncProperties
extends UserProps
implements ObjDump {
    private static Locale theLocale;
    private static ResourceBundle mailRes;
    private static ResourceBundle mailTips;
    public static final String MAIL_PROTOCAL = "mailconduit.mailprotocal";
    public static final String SERVER_TEXT = "mailconduit.servertext";
    public static final String LOGIN_TEXT = "mailconduit.logintext";
    public static final String SAVE_LOGIN = "mailconduit.savelogin";
    public static final String LOCAL_TEXT = "mailconduit.localtext";
    public static final String DT_OVERWRITES_PDA = "mailconduit.dtoverwritespda";
    public static final String IMAP_PROTOCOL_STRING = "IMAP";
    public static final String MBOX_PROTOCOL_STRING = "MBOX";
    public int mailProtocol;
    public String serverText;
    public String loginText;
    public boolean saveLogin;
    public String localText;
    public boolean dtOverwritesPDA;

    static {
        try {
            theLocale = Locale.getDefault();
            mailRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.MailSyncUIMessages", theLocale);
        }
        catch (MissingResourceException e) {
            System.err.println("PDASync: MailSyncProperties can't find properties");
            System.err.println("PDASync:" + e.getMessage());
            System.exit(1);
        }
    }

    public MailSyncProperties() {
        super("MailSyncConduit.def", "Mail Synchronization Properties");
        this.getProperties();
    }

    public String dump() {
        return ((Object)((Object)this)).toString();
    }

    public String dumpFormatted() {
        return this.dumpFormatted(0);
    }

    public String dumpFormatted(int numTabs) {
        String tabs = SyncUtils.makeTabsString((int)numTabs);
        return String.valueOf(tabs) + "MailProperties\n" + tabs + "  {\n" + tabs + "    mailProtocol:   " + this.mailProtocol + "\n" + tabs + "    serverText:    " + this.serverText + "\n" + tabs + "    loginText:    " + this.loginText + "\n" + tabs + "    saveLogin:    " + this.saveLogin + "\n" + tabs + "    localText:    " + this.serverText + "\n" + tabs + "    dtOverwritesPDA:    " + this.dtOverwritesPDA + "\n" + tabs + "  }\n";
    }

    public void printProps(String msg, Properties props) {
    }

    protected void savePropertiesError() {
    }

    public void setDefaultSettings(Properties userSettings) {
        ((Hashtable)userSettings).put(MAIL_PROTOCAL, mailRes.getString(IMAP_PROTOCOL_STRING));
        ((Hashtable)userSettings).put(SERVER_TEXT, mailRes.getString("server.domain"));
        ((Hashtable)userSettings).put(LOGIN_TEXT, SyncConstants.USER_NAME);
        ((Hashtable)userSettings).put(SAVE_LOGIN, Boolean.FALSE.toString());
        ((Hashtable)userSettings).put(LOCAL_TEXT, "/var/mail/" + SyncConstants.USER_NAME);
        ((Hashtable)userSettings).put(DT_OVERWRITES_PDA, Boolean.FALSE.toString());
    }

    protected void setProperties() {
        if (this.mailProtocol == 1) {
            ((Hashtable)this.userProps).put(MAIL_PROTOCAL, mailRes.getString(IMAP_PROTOCOL_STRING));
        } else if (this.mailProtocol == 2) {
            ((Hashtable)this.userProps).put(MAIL_PROTOCAL, mailRes.getString(MBOX_PROTOCOL_STRING));
        } else {
            ((Hashtable)this.userProps).put(MAIL_PROTOCAL, " ");
        }
        ((Hashtable)this.userProps).put(SERVER_TEXT, this.serverText);
        ((Hashtable)this.userProps).put(LOGIN_TEXT, this.loginText);
        ((Hashtable)this.userProps).put(SAVE_LOGIN, new Boolean(this.saveLogin).toString());
        ((Hashtable)this.userProps).put(LOCAL_TEXT, this.localText);
        ((Hashtable)this.userProps).put(DT_OVERWRITES_PDA, new Boolean(this.dtOverwritesPDA).toString());
    }

    protected void setSettings() {
        String tmp = this.userProps.getProperty(MAIL_PROTOCAL);
        if (tmp != null) {
            this.mailProtocol = tmp.equals(mailRes.getString(IMAP_PROTOCOL_STRING)) ? 1 : (tmp.equals(mailRes.getString(MBOX_PROTOCOL_STRING)) ? 2 : 0);
        }
        if ((tmp = this.userProps.getProperty(SERVER_TEXT)) != null) {
            this.serverText = new String(tmp);
        }
        if ((tmp = this.userProps.getProperty(LOGIN_TEXT)) != null) {
            this.loginText = new String(tmp);
        }
        if ((tmp = this.userProps.getProperty(SAVE_LOGIN)) != null) {
            this.saveLogin = new Boolean(tmp);
        }
        if ((tmp = this.userProps.getProperty(LOCAL_TEXT)) != null) {
            this.localText = new String(tmp);
        }
        if ((tmp = this.userProps.getProperty(DT_OVERWRITES_PDA)) != null) {
            this.dtOverwritesPDA = new Boolean(tmp);
        }
    }
}

