/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.MailSync;

import com.sun.pdasync.Conduits.MailSync.MailPref;
import com.sun.pdasync.Conduits.MailSync.MailRecord;
import com.sun.pdasync.Conduits.MailSync.MailSyncDesktopMgr;
import com.sun.pdasync.Conduits.MailSync.MailSyncException;
import com.sun.pdasync.Conduits.MailSync.MailSyncLocalDBMgr;
import com.sun.pdasync.Conduits.MailSync.MailSyncProperties;
import com.sun.pdasync.Conduits.MailSync.MailSyncUI;
import com.sun.pdasync.Conduits.MailSync.MailSyncUtils;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.event.ConnectionEvent;
import javax.mail.event.ConnectionListener;
import palm.conduit.Record;
import palm.conduit.SyncException;
import palm.conduit.SyncManager;
import palm.conduit.SyncProperties;

public class MailSyncManager
implements ConnectionListener {
    public static ResourceBundle mailRes;
    SyncProperties syncProps;
    MailSyncLocalDBMgr localDBMgr;
    MailSyncDesktopMgr desktopMgr;
    Class recordClass;
    int pilotDB;
    MailPref mailPref;
    MailSyncProperties mailProps;
    boolean mailboxInterrupt = false;

    public MailSyncManager(MailSyncUI mailUI, SyncProperties props, MailSyncProperties mailProps) throws MailSyncException {
        this.syncProps = props;
        this.mailProps = mailProps;
        try {
            this.desktopMgr = new MailSyncDesktopMgr(mailUI, mailProps);
        }
        catch (MailSyncException me) {
            throw me;
        }
        catch (Throwable throwable) {
            throw new MailSyncException(4117);
        }
        this.desktopMgr.addMailboxConnectionListener(this);
        this.localDBMgr = new MailSyncLocalDBMgr(this.desktopMgr);
        this.pilotDB = -1;
    }

    public void cleanUp() {
        try {
            this.closePilotDB();
            this.desktopMgr.closeInbox();
        }
        catch (Throwable throwable) {}
    }

    public void closeLocalDB() throws IOException {
        this.localDBMgr.close();
        MailSyncUtils.doDebug("finish closing local database...");
    }

    public void closePilotDB() throws SyncException {
        if (this.pilotDB != -1) {
            SyncManager.closeDB((int)this.pilotDB);
            MailSyncUtils.doDebug("finish SyncManager.closeDB...");
            this.pilotDB = -1;
        }
    }

    public void closed(ConnectionEvent ce) {
        this.handleConnectionEvent(ce);
    }

    public void copyDesktopToPilot() throws MailSyncException {
        String errMessage = mailRes.getString("Error in copy DT to HH: ");
        if (MailPref.getSyncType() != 1) {
            try {
                SyncManager.purgeAllRecs((int)this.pilotDB);
            }
            catch (SyncException se) {
                MailSyncUtils.doDebug("Error in SyncManager.purgeAllRecs." + se.getMessage());
            }
            try {
                Message[] mailMsgs = this.readDesktopMsgs();
                if (mailMsgs == null || mailMsgs.length == 0) {
                    throw new MailSyncException(4119);
                }
                this.localDBMgr.loadDesktopDB(mailMsgs, MailPref.getMaxLength());
            }
            catch (MailSyncException mse) {
                throw new MailSyncException(errMessage, mse);
            }
            this.localDBMgr.addNewRecordsToPilot();
            this.desktopMgr.closeInbox();
            try {
                SyncManager.resetSyncFlags((int)this.pilotDB);
            }
            catch (SyncException se) {
                MailSyncUtils.doDebug("Cannot reset HH SyncFlags. " + se.getMessage());
            }
            MailSyncUtils.doLog(mailRes.getString("Copied Records from desktop to device."));
        }
    }

    public void disconnected(ConnectionEvent ce) {
        this.handleConnectionEvent(ce);
    }

    private Record getNewRecord() {
        Record hhRecord = null;
        try {
            hhRecord = (Record)this.recordClass.newInstance();
        }
        catch (Throwable t) {
            System.out.println("Uncaught exception: " + t);
            t.printStackTrace();
        }
        return hhRecord;
    }

    private void handleConnectionEvent(ConnectionEvent ce) {
        this.mailboxInterrupt = true;
    }

    public boolean isMailboxInterrupted() {
        return this.mailboxInterrupt;
    }

    public void openLocalDB() {
        this.localDBMgr.open();
    }

    public void openPilotDB() throws MailSyncException {
        try {
            this.recordClass = Class.forName("com.sun.pdasync.Conduits.MailSync.MailRecord");
        }
        catch (Exception e) {
            throw new MailSyncException(4100, e);
        }
        try {
            this.pilotDB = SyncManager.openDB((String)this.syncProps.remoteNames[0], (int)0, (int)224);
            MailSyncUtils.doLog(String.valueOf(mailRes.getString("pilot database ")) + this.syncProps.remoteNames[0] + mailRes.getString(" is opened."));
        }
        catch (SyncException e) {
            if (e.errorCode == 16387) {
                MailSyncUtils.doDebug("cannot open database, create the mail database");
                try {
                    this.pilotDB = SyncManager.createDB((int)this.syncProps.creator, (int)0, (int)this.syncProps.cardNo, (String)this.syncProps.remoteNames[0], (int)this.syncProps.dbType);
                    MailSyncUtils.doLog(mailRes.getString("Database on handheld can not be opened, create new database."));
                }
                catch (SyncException se) {
                    throw new MailSyncException(4100, (Exception)((Object)se));
                }
            }
            throw new MailSyncException(4100, (Exception)((Object)e));
        }
        this.localDBMgr.setPilotDB(this.pilotDB);
    }

    public void opened(ConnectionEvent ce) {
    }

    private Message[] readDesktopMsgs() throws MailSyncException {
        Message[] mailMsgs = this.mailProps.mailProtocol == 2 ? this.desktopMgr.readRecords(this.mailProps.localText, this.mailPref) : this.desktopMgr.readRecords("INBOX", this.mailPref);
        MailSyncUtils.doDebug("MailSyncManager.readDesktopMsgs() is done.");
        return mailMsgs;
    }

    public void readPilotPrefs() throws MailSyncException {
        this.mailPref = new MailPref();
        try {
            this.mailPref.readData();
        }
        catch (Exception e) {
            throw new MailSyncException(4101, e);
        }
        MailSyncUtils.doDebug(this.mailPref.toFormattedString());
        int syncType = MailPref.getSyncType();
        if (syncType != 2) {
            this.localDBMgr.setCurHHSyncType(syncType);
        } else {
            this.localDBMgr.setCurHHSyncType(MailSyncUtils.mixSyncFilterType(syncType, MailPref.getFilterType()));
        }
    }

    public void resetMailboxInterruptFlag() {
        this.mailboxInterrupt = false;
        this.desktopMgr.resetMailboxInterruptFlag();
    }

    public void sendOutboxMsgs() throws MailSyncException {
        if (this.syncProps.syncType == 6) {
            return;
        }
        try {
            SyncManager.resetRecordIndex((int)this.pilotDB);
        }
        catch (SyncException e) {
            throw new MailSyncException(4102, (Exception)((Object)e));
        }
        try {
            while (true) {
                Record hhRecord = this.getNewRecord();
                hhRecord.setCategoryIndex(1);
                SyncManager.readNextRecInCategory((int)this.pilotDB, (Record)hhRecord);
                MailSyncUtils.doDebug(" ------------------ sendOutboxMsgs: hhRecord ----------------");
                MailSyncUtils.doDebug(((MailRecord)hhRecord).toFormattedString());
                try {
                    this.desktopMgr.sendMail((MailRecord)hhRecord);
                }
                catch (MessagingException me) {
                    throw new MailSyncException(4103, (Exception)((Object)me));
                }
                this.localDBMgr.deleteHHRec(hhRecord);
                SyncManager.deleteRecord((int)this.pilotDB, (Record)hhRecord);
                MailSyncUtils.doLog(String.valueOf(mailRes.getString("Message (to ")) + ((MailRecord)hhRecord).getTo() + mailRes.getString(" )") + mailRes.getString(" from OUTBOX folder has been sent."));
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void syncData() throws MailSyncException {
        String errMessage = mailRes.getString("Error in syncing data: ");
        if (MailPref.getSyncType() != 1) {
            MailSyncUtils.doDebug("In MailSyncManager.syncData...");
            try {
                this.localDBMgr.verifyPilotRecs();
            }
            catch (IOException e) {
                throw new MailSyncException(errMessage, 4104, e);
            }
            try {
                Message[] mailMsgs = this.readDesktopMsgs();
                if (mailMsgs == null || mailMsgs.length == 0) {
                    throw new MailSyncException(errMessage, 4119);
                }
                this.localDBMgr.mergeDesktopDB(mailMsgs, MailPref.getMaxLength());
                this.localDBMgr.handleModifiedRecs();
                this.localDBMgr.deleteRecsOnPilot();
                MailSyncUtils.doDebug("after deleteRecsOnPilot, localDB.size = " + this.localDBMgr.getSize());
                this.localDBMgr.updateReadFlagOnPilot();
                MailSyncUtils.doDebug("after updateReadFlagsOnPilot, localDB.size = " + this.localDBMgr.getSize());
                this.localDBMgr.addNewRecordsToPilot();
                MailSyncUtils.doDebug("after addNewRecordsToPilot, localDB.size = " + this.localDBMgr.getSize());
                this.desktopMgr.closeInbox();
            }
            catch (MailSyncException e) {
                throw new MailSyncException(errMessage, e);
            }
            try {
                SyncManager.resetSyncFlags((int)this.pilotDB);
            }
            catch (SyncException syncException) {
                MailSyncUtils.doDebug("Cannot reset HH SyncFlags.");
            }
            MailSyncUtils.doLog(mailRes.getString("Finishing syncing records."));
        }
    }
}

