/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.MailSync;

import com.sun.pdasync.Conduits.MailSync.MailRecord;
import com.sun.pdasync.Conduits.MailSync.MailSyncUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import palm.conduit.Record;

public class MailSyncLocalDBRec
implements Serializable {
    private final String ATTACHMENT_STRING = "\nATTACHMENT IGNORED.\n";
    private int pilotID;
    private int desktopID;
    private String desktopMsgID = null;
    private boolean hhReadFlag;
    private boolean dtReadFlag;
    private boolean isOnPilot;
    private boolean isOnDesktop;
    private boolean hhDeleteFlag;
    private boolean dtDeleteFlag;
    private MailRecord record;
    transient String msgBody;

    public void addMsgBodyToHH(Message mailMsg, MailRecord hhRecord, int msgLength) throws MessagingException, IOException {
        String tmpStr;
        Address[] addrs = mailMsg.getRecipients(Message.RecipientType.CC);
        if (addrs != null && (tmpStr = this.addrsToString(addrs)) != null) {
            hhRecord.setCc(tmpStr);
        }
        if ((addrs = mailMsg.getRecipients(Message.RecipientType.BCC)) != null && (tmpStr = this.addrsToString(addrs)) != null) {
            hhRecord.setBcc(tmpStr);
        }
        if ((addrs = mailMsg.getReplyTo()) != null && (tmpStr = this.addrsToString(addrs)) != null) {
            hhRecord.setReplyTo(tmpStr);
        }
        this.msgBody = null;
        this.getMsgBody((Part)mailMsg, msgLength);
        if (this.msgBody != null) {
            hhRecord.setBody(this.msgBody);
        }
    }

    private String addrsToString(Address[] addrs) {
        String tmpStr = null;
        if (addrs.length > 0) {
            int i = 0;
            while (i < addrs.length) {
                tmpStr = i == 0 ? addrs[i].toString() : String.valueOf(tmpStr) + addrs[i].toString();
                ++i;
            }
        }
        return tmpStr;
    }

    public MailRecord convertMsgHdrToHH(Message mailMsg) throws MessagingException, IOException {
        MailRecord hhRecord = new MailRecord();
        Date date = mailMsg.getSentDate();
        hhRecord.setDate(date);
        MailSyncUtils.doDebug("convertMsgHdrToHH: date -- " + date);
        String subject = mailMsg.getSubject();
        MailSyncUtils.doDebug("subject -- " + subject);
        hhRecord.setSubject(subject);
        Address[] addrs = mailMsg.getFrom();
        if (addrs != null) {
            String from = this.addrsToString(addrs);
            if (from != null) {
                MailSyncUtils.doDebug("addrs, tmpStr -- " + from);
                hhRecord.setFrom(from);
            }
        } else {
            Object from = null;
        }
        if ((addrs = mailMsg.getRecipients(Message.RecipientType.TO)) != null) {
            String to = this.addrsToString(addrs);
            if (to != null) {
                hhRecord.setTo(to);
            }
        } else {
            Object to = null;
        }
        return hhRecord;
    }

    public boolean getDTdeleteFlag() {
        return this.dtDeleteFlag;
    }

    public boolean getDTreadFlag() {
        return this.dtReadFlag;
    }

    public int getDesktopID() {
        return this.desktopID;
    }

    public String getDesktopMsgID() {
        return this.desktopMsgID;
    }

    public boolean getHHdeleteFlag() {
        return this.hhDeleteFlag;
    }

    public boolean getHHreadFlag() {
        return this.hhReadFlag;
    }

    public boolean getIsOnDesktop() {
        return this.isOnDesktop;
    }

    public boolean getIsOnPilot() {
        return this.isOnPilot;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void getMsgBody(Part msgPart, int maxLength) throws IOException, MessagingException {
        Object o = msgPart.getContent();
        if (o instanceof String) {
            String msg = (String)o;
            if (this.msgBody == null) {
                if (msg.length() < maxLength) {
                    this.msgBody = msg;
                    return;
                }
                this.msgBody = msg.substring(0, maxLength - 1);
                return;
            }
            if (this.msgBody.length() + msg.length() < maxLength) {
                this.msgBody = String.valueOf(this.msgBody) + msg;
                return;
            }
            int len = maxLength - this.msgBody.length();
            this.msgBody = String.valueOf(this.msgBody) + msg.substring(0, len - 1);
            return;
        }
        if (o instanceof Multipart) {
            Multipart mp = (Multipart)o;
            this.getMsgBody((Part)mp.getBodyPart(0), maxLength);
            this.msgBody = String.valueOf(this.msgBody) + "\nATTACHMENT IGNORED.\n";
            return;
        }
        if (!(o instanceof Message)) return;
        this.getMsgBody((Part)o, maxLength);
    }

    public int getPilotID() {
        return this.pilotID;
    }

    public MailRecord getRecord() {
        return this.record;
    }

    public void setDTdeleteFlag(boolean dtDeleteFlag) {
        this.dtDeleteFlag = dtDeleteFlag;
    }

    public void setDTreadFlag(boolean dtReadFlag) {
        this.dtReadFlag = dtReadFlag;
    }

    public void setDesktopID(int dtIndex) {
        this.desktopID = dtIndex;
    }

    public void setDesktopMsgID(String msgID) {
        this.desktopMsgID = msgID;
    }

    public void setHHdeleteFlag(boolean hhDeleteFlag) {
        this.hhDeleteFlag = hhDeleteFlag;
    }

    public void setHHreadFlag(boolean hhReadFlag) {
        this.hhReadFlag = hhReadFlag;
    }

    public void setIsOnDesktop(boolean isOnDesktop) {
        this.isOnDesktop = isOnDesktop;
    }

    public void setIsOnPilot(boolean isOnPilot) {
        this.isOnPilot = isOnPilot;
    }

    public void setPilotID(int hhID) {
        this.pilotID = hhID;
    }

    public void setRecBodyFromDT(Message message, int msgLength) throws IOException, MessagingException {
        Flags flags = message.getFlags();
        this.addMsgBodyToHH(message, this.record, msgLength);
        Flags flags1 = message.getFlags();
        message.setFlags(flags1, false);
        message.setFlags(flags, true);
    }

    public void setRecFromHH(MailRecord hhRecord) {
        this.record = hhRecord;
        this.isOnPilot = true;
        this.pilotID = hhRecord.getId();
        this.hhDeleteFlag = this.record.isDeleted();
        this.hhReadFlag = this.record.getIsRead();
    }

    public void setRecHdrFromDT(Message message) throws IOException, MessagingException {
        Flags flags = message.getFlags();
        this.record = this.convertMsgHdrToHH(message);
        Flags flags1 = message.getFlags();
        message.setFlags(flags1, false);
        message.setFlags(flags, true);
        this.dtReadFlag = flags.contains(Flags.Flag.SEEN);
        this.record.setIsRead(this.dtReadFlag);
        if (flags.contains(Flags.Flag.DELETED)) {
            this.dtDeleteFlag = true;
            this.record.setIsDeleted(true);
            this.record.setCategoryIndex(2);
        } else {
            this.dtDeleteFlag = false;
            this.record.setIsDeleted(false);
            this.record.setCategoryIndex(0);
        }
        this.isOnDesktop = true;
        this.desktopID = message.getMessageNumber();
        if (message instanceof MimeMessage) {
            MimeMessage mimeMsg = (MimeMessage)message;
            this.desktopMsgID = mimeMsg.getMessageID();
        }
    }

    public String toFormattedString() {
        return "MailSyncLocalDBRec: {\r\n  pilotID: " + this.pilotID + "\r\n" + "  desktopID: " + this.desktopID + "\r\n" + "  desktopMsgID: " + this.desktopMsgID + "\r\n" + "  hhReadFlag: " + this.hhReadFlag + "\r\n" + "  dtReadFlag: " + this.dtReadFlag + "\r\n" + "  isOnPilot: " + this.isOnPilot + "\r\n" + "  isOnDesktop: " + this.isOnDesktop + "\r\n" + "  hhDeleteFlag: " + this.hhDeleteFlag + "\r\n" + "  dtDeleteFlag: " + this.dtDeleteFlag + "\r\n" + " record: " + this.record.toFormattedString() + "\r\n" + "}\r\n";
    }

    public boolean verify(MailSyncLocalDBRec localRec) {
        return this.verify((Record)localRec.getRecord());
    }

    public boolean verify(Record hhRecord) {
        MailRecord inRec = (MailRecord)hhRecord;
        return this.verifyDate(inRec) && this.verifyString(this.record.getSubject(), inRec.getSubject()) && this.verifyString(this.record.getFrom(), inRec.getFrom()) && this.verifyString(this.record.getTo(), inRec.getTo());
    }

    private boolean verifyDate(MailRecord hhRecord) {
        Date locDate = this.record.getDate();
        Date hhDate = hhRecord.getDate();
        if (locDate == null && hhDate == null) {
            return true;
        }
        if (locDate == null || hhDate == null) {
            return false;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(locDate);
        cal.set(13, 0);
        cal.set(14, 0);
        Calendar inCal = Calendar.getInstance();
        inCal.setTime(hhDate);
        inCal.set(13, 0);
        inCal.set(14, 0);
        return cal.equals(inCal);
    }

    private boolean verifyString(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }
}

