/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.MailSync;

import com.sun.pdasync.Conduits.MailSync.MailRecord;
import com.sun.pdasync.Conduits.MailSync.MailSyncConstants;
import com.sun.pdasync.Conduits.MailSync.MailSyncDesktopMgr;
import com.sun.pdasync.Conduits.MailSync.MailSyncException;
import com.sun.pdasync.Conduits.MailSync.MailSyncLocalDBRec;
import com.sun.pdasync.Conduits.MailSync.MailSyncUtils;
import com.sun.pdasync.SyncUtils.SyncUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.mail.Flags;
import javax.mail.Message;
import palm.conduit.Record;
import palm.conduit.SyncException;
import palm.conduit.SyncManager;

public class MailSyncLocalDBMgr {
    public static ResourceBundle mailRes;
    private MailSyncDesktopMgr desktopMgr;
    private String localFile;
    private Vector localRecords;
    private int pilotDB;
    private int prevHHSyncType;
    private int curHHSyncType;
    private static int PREF_FILTER_MSG_IGNORE;
    private static int PREF_FILTER_MSG_RETRIEVE;

    static {
        PREF_FILTER_MSG_IGNORE = MailSyncUtils.mixSyncFilterType(2, 0);
        PREF_FILTER_MSG_RETRIEVE = MailSyncUtils.mixSyncFilterType(2, 1);
    }

    public MailSyncLocalDBMgr(MailSyncDesktopMgr desktopMgr) {
        this.desktopMgr = desktopMgr;
        SyncUtils.mkdirIfNotExist((String)MailSyncConstants.MAIL_DIR_PATH);
        this.localFile = String.valueOf(MailSyncConstants.MAIL_DIR_PATH) + "mail.dat";
        this.localRecords = new Vector();
        this.pilotDB = -1;
        this.prevHHSyncType = -1;
        this.curHHSyncType = -1;
    }

    void addNewRecordsToPilot() {
        int i = 0;
        while (i < this.localRecords.size()) {
            block4: {
                MailSyncLocalDBRec localRec = (MailSyncLocalDBRec)this.localRecords.elementAt(i);
                if (localRec.getIsOnDesktop() && !localRec.getIsOnPilot() && !localRec.getDTdeleteFlag()) {
                    try {
                        SyncManager.writeRec((int)this.pilotDB, (Record)localRec.getRecord());
                    }
                    catch (IOException iOException) {
                        MailSyncUtils.doDebug("add new HH record failed, rec = " + localRec.toFormattedString());
                        break block4;
                    }
                    localRec.setIsOnPilot(true);
                    localRec.setHHreadFlag(localRec.getDTreadFlag());
                    localRec.setPilotID(localRec.getRecord().getId());
                    localRec.setHHdeleteFlag(false);
                }
            }
            ++i;
        }
    }

    void close() {
        try {
            FileOutputStream fo = new FileOutputStream(this.localFile);
            ObjectOutputStream os = new ObjectOutputStream(fo);
            MailSyncUtils.doDebug("MailSyncLocalDBMgr.close: localRecords.size = " + this.localRecords.size());
            if (this.curHHSyncType == 1) {
                this.curHHSyncType = -1;
            } else {
                this.prevHHSyncType = this.curHHSyncType;
            }
            os.writeInt(this.curHHSyncType);
            os.writeObject(this.localRecords);
            os.close();
        }
        catch (IOException iOException) {
            MailSyncUtils.doLog(mailRes.getString("Error in closing local database."));
        }
    }

    void deleteHHRec(Record hhRecord) {
        int index = this.matchPilotID(hhRecord.getIndex());
        if (index != -1) {
            this.localRecords.removeElementAt(index);
        } else {
            index = this.matchRecContent((MailRecord)hhRecord);
            if (index != -1) {
                this.localRecords.removeElementAt(index);
            }
        }
    }

    void deleteRecsOnPilot() {
        int size = this.localRecords.size();
        MailSyncLocalDBRec[] deleteRecs = new MailSyncLocalDBRec[size];
        int n = 0;
        int i = 0;
        while (i < size) {
            block5: {
                MailSyncLocalDBRec localRec = (MailSyncLocalDBRec)this.localRecords.elementAt(i);
                if (localRec.getDTdeleteFlag() && localRec.getIsOnPilot()) {
                    MailSyncUtils.doDebug("deleteRecsOnPilot: deleting localRec " + i + " " + localRec.toFormattedString());
                    try {
                        SyncManager.deleteRecord((int)this.pilotDB, (Record)localRec.getRecord());
                    }
                    catch (SyncException syncException) {
                        MailSyncUtils.doDebug("Cannot delete HH record = " + localRec.toFormattedString());
                        break block5;
                    }
                    deleteRecs[n] = localRec;
                    ++n;
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < n) {
            this.localRecords.removeElement(deleteRecs[i2]);
            ++i2;
        }
    }

    private int[] getPilotRecIDArray() throws SyncException, IOException {
        int[] recIDs = null;
        int recCount = SyncManager.getDBRecordCount((int)this.pilotDB);
        if (recCount > 0) {
            byte[] bytes = SyncManager.readPositionXMap((byte)((byte)this.pilotDB), (short)0, (short)((short)recCount));
            recCount = bytes.length / 4;
            recIDs = new int[recCount];
            DataInputStream di = new DataInputStream(new ByteArrayInputStream(bytes));
            int i = 0;
            while (i < recCount) {
                recIDs[i] = di.readInt();
                ++i;
            }
        }
        return recIDs;
    }

    public int getSize() {
        return this.localRecords.size();
    }

    void handleModifiedRecs() throws MailSyncException {
        int i;
        boolean[] hhOnDTFlags;
        int[] hhIDs;
        try {
            hhIDs = this.getPilotRecIDArray();
            if (hhIDs == null) {
                return;
            }
            hhOnDTFlags = new boolean[hhIDs.length];
            i = 0;
            while (i < hhIDs.length) {
                hhOnDTFlags[i] = false;
                ++i;
            }
            SyncManager.resetRecordIndex((int)this.pilotDB);
        }
        catch (IOException se) {
            throw new MailSyncException(4112, se);
        }
        try {
            block10: while (true) {
                MailRecord hhRecord = new MailRecord();
                SyncManager.readNextModifiedRec((int)this.pilotDB, (Record)hhRecord);
                MailSyncUtils.doDebug("handleModifiedRecs: modified rec = " + hhRecord.toFormattedString());
                MailSyncLocalDBRec newLocalRec = new MailSyncLocalDBRec();
                newLocalRec.setRecFromHH(hhRecord);
                this.setHHFlags(newLocalRec, hhRecord);
                int recID = newLocalRec.getPilotID();
                int index = this.isInLocalDBFromPilot(newLocalRec);
                if (index == -1) continue;
                MailSyncUtils.doDebug("FOUND a match in local DB, index = " + index);
                MailSyncUtils.doDebug("localRecords.size() = " + this.localRecords.size());
                MailSyncLocalDBRec localRec = (MailSyncLocalDBRec)this.localRecords.elementAt(index);
                localRec.setRecFromHH(hhRecord);
                MailSyncUtils.doDebug("localRec.getDTdeleteFlag() = " + localRec.getDTdeleteFlag());
                if (!localRec.getDTdeleteFlag()) {
                    if (newLocalRec.getHHdeleteFlag()) {
                        this.desktopMgr.deleteMessage(localRec);
                        this.localRecords.removeElementAt(index);
                        MailSyncUtils.doDebug("Record " + recID + " Delete on Pilot, set delete from Desktop");
                    } else if (!localRec.getDTreadFlag() && newLocalRec.getHHreadFlag()) {
                        localRec.setDTreadFlag(true);
                        this.desktopMgr.setMessageRead(localRec);
                        MailSyncUtils.doDebug("Record " + recID + " Read on Pilot, set read flag on Desktop");
                    }
                }
                i = 0;
                while (true) {
                    if (i >= hhIDs.length) continue block10;
                    if (hhIDs[i] == recID) {
                        hhOnDTFlags[i] = true;
                        continue block10;
                    }
                    ++i;
                }
                break;
            }
        }
        catch (IOException iOException) {
            try {
                i = 0;
                while (i < hhOnDTFlags.length) {
                    int index;
                    if (!hhOnDTFlags[i] && (index = this.matchPilotID(hhIDs[i])) == -1) {
                        MailSyncLocalDBRec localRec;
                        MailRecord hhRecord = new MailRecord();
                        hhRecord.setId(hhIDs[i]);
                        SyncManager.readRecordById((int)this.pilotDB, (Record)hhRecord);
                        index = this.matchRecContent(hhRecord);
                        if (index != -1) {
                            localRec = (MailSyncLocalDBRec)this.localRecords.elementAt(index);
                            localRec.setRecFromHH(hhRecord);
                        } else {
                            switch (hhRecord.getCategoryIndex()) {
                                case 1: 
                                case 3: 
                                case 4: {
                                    MailSyncUtils.doDebug("Record " + hhIDs[i] + " is in OUTBOX/DRAFT/FILED folder.");
                                    localRec = new MailSyncLocalDBRec();
                                    localRec.setRecFromHH(hhRecord);
                                    this.setHHFlags(localRec, hhRecord);
                                    localRec.setIsOnDesktop(false);
                                    break;
                                }
                            }
                            SyncManager.deleteRecord((int)this.pilotDB, (Record)hhRecord);
                        }
                    }
                    ++i;
                }
                SyncManager.purgeDeletedRecs((int)this.pilotDB);
                SyncManager.purgeAllRecsInCategory((int)this.pilotDB, (int)2);
            }
            catch (IOException e) {
                throw new MailSyncException(4112, e);
            }
        }
        MailSyncUtils.doDebug("at the end of handleModified, size = " + this.localRecords.size());
    }

    private boolean isDatasetReduced() {
        MailSyncUtils.doDebug("MailSYncLocalDBMgr.isDatasetReduced: prevHHSyncType = " + this.prevHHSyncType);
        MailSyncUtils.doDebug("curHHSyncType = " + this.curHHSyncType);
        if (this.prevHHSyncType == -1 || this.curHHSyncType == 1) {
            return false;
        }
        if (this.curHHSyncType == this.prevHHSyncType) {
            return false;
        }
        if (this.prevHHSyncType == 0 || this.curHHSyncType == PREF_FILTER_MSG_IGNORE || this.curHHSyncType == PREF_FILTER_MSG_RETRIEVE) {
            return true;
        }
        return this.curHHSyncType != 0;
    }

    int isInLocalDBFromDesktop(MailSyncLocalDBRec localRec) {
        int localIndex = -1;
        String desktopMsgID = localRec.getDesktopMsgID();
        if (desktopMsgID != null) {
            localIndex = this.matchDesktopMsgID(desktopMsgID);
        } else {
            MailSyncLocalDBRec record;
            localIndex = this.matchDesktopID(localRec.getDesktopID());
            if (localIndex != -1 && !localRec.verify(record = (MailSyncLocalDBRec)this.localRecords.elementAt(localIndex))) {
                localIndex = -1;
            }
            if (localIndex == -1) {
                localIndex = this.matchRecContent(localRec.getRecord());
            }
        }
        return localIndex;
    }

    int isInLocalDBFromPilot(MailSyncLocalDBRec localRec) {
        MailSyncLocalDBRec record;
        int localIndex = -1;
        localIndex = this.matchPilotID(localRec.getPilotID());
        if (localIndex != -1 && !localRec.verify(record = (MailSyncLocalDBRec)this.localRecords.elementAt(localIndex))) {
            localIndex = -1;
        }
        if (localIndex == -1) {
            localIndex = this.matchRecContent(localRec.getRecord());
        }
        return localIndex;
    }

    void loadDesktopDB(Message[] mailMsgs, int msgLength) throws MailSyncException {
        this.purgeAll();
        int i = 0;
        while (i < mailMsgs.length) {
            MailSyncLocalDBRec localRec = new MailSyncLocalDBRec();
            try {
                localRec.setRecHdrFromDT(mailMsgs[i]);
                localRec.setRecBodyFromDT(mailMsgs[i], msgLength);
                localRec.setIsOnPilot(false);
                int index = this.localRecords.size();
                MailRecord rec = localRec.getRecord();
                rec.setIndex(index);
                rec.setIsNew(true);
                this.localRecords.addElement(localRec);
            }
            catch (Exception exception) {
                if (this.desktopMgr.isMailboxInterrupted()) {
                    throw new MailSyncException(4116);
                }
                MailSyncUtils.doLog(String.valueOf(mailRes.getString("Skipping message from desktop mailbox due to error, msgNum = ")) + mailMsgs[i].getMessageNumber());
                localRec = null;
            }
            ++i;
        }
    }

    private int matchDesktopID(int desktopID) {
        int i = 0;
        while (i < this.localRecords.size()) {
            MailSyncLocalDBRec localRec = (MailSyncLocalDBRec)this.localRecords.elementAt(i);
            if (localRec.getDesktopID() == desktopID) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int matchDesktopMsgID(String desktopMsgID) {
        int i = 0;
        while (i < this.localRecords.size()) {
            MailSyncLocalDBRec localRec = (MailSyncLocalDBRec)this.localRecords.elementAt(i);
            if (localRec.getDesktopMsgID().equals(desktopMsgID)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int matchPilotID(int pilotID) {
        int i = 0;
        while (i < this.localRecords.size()) {
            MailSyncLocalDBRec localRec = (MailSyncLocalDBRec)this.localRecords.elementAt(i);
            if (localRec.getPilotID() == pilotID) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int matchRecContent(MailRecord hhRecord) {
        int i = 0;
        while (i < this.localRecords.size()) {
            MailSyncLocalDBRec localRec = (MailSyncLocalDBRec)this.localRecords.elementAt(i);
            if (localRec.verify((Record)hhRecord)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void mergeDesktopDB(Message[] mailMsgs, int msgLength) throws MailSyncException {
        MailSyncLocalDBRec localRec;
        Flags flags = null;
        MailSyncUtils.doDebug("Start MailSyncLocalDBMgr.mergeDesktopDB at " + new Date());
        int i = 0;
        while (i < this.localRecords.size()) {
            localRec = (MailSyncLocalDBRec)this.localRecords.elementAt(i);
            localRec.setIsOnDesktop(false);
            MailRecord rec = localRec.getRecord();
            int catIndex = rec.getCategoryIndex();
            if (catIndex == 0 || catIndex == 2) {
                localRec.setDTdeleteFlag(true);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < mailMsgs.length) {
            try {
                flags = mailMsgs[i2].getFlags();
                localRec = new MailSyncLocalDBRec();
                localRec.setRecHdrFromDT(mailMsgs[i2]);
                int index = this.isInLocalDBFromDesktop(localRec);
                if (index != -1) {
                    MailSyncUtils.doDebug("mergeDesktopDB: rec " + i2 + " FOUND, localDB index = " + index);
                    localRec = (MailSyncLocalDBRec)this.localRecords.elementAt(index);
                    localRec.setIsOnDesktop(true);
                    localRec.setDTdeleteFlag(flags.contains(Flags.Flag.DELETED));
                    localRec.setDesktopID(mailMsgs[i2].getMessageNumber());
                    localRec.setDTreadFlag(flags.contains(Flags.Flag.SEEN));
                } else {
                    localRec.setRecBodyFromDT(mailMsgs[i2], msgLength);
                    MailSyncUtils.doDebug("mergeDesktopDB: rec " + i2 + " -- add NEW record");
                    this.localRecords.addElement(localRec);
                }
            }
            catch (Exception exception) {
                if (this.desktopMgr.isMailboxInterrupted()) {
                    throw new MailSyncException(4116);
                }
                flags = null;
                localRec = null;
                MailSyncUtils.doLog(String.valueOf(mailRes.getString("Skipping message from desktop mailbox due to error, msgnum = ")) + i2);
            }
            ++i2;
        }
        MailSyncUtils.doDebug("after mergeDesktopDB, localRecords.size() = " + this.localRecords.size());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void open() {
        File file = new File(this.localFile);
        ObjectInputStream oi = null;
        if (!file.exists()) return;
        try {
            block7: {
                try {
                    FileInputStream fi = new FileInputStream(this.localFile);
                    oi = new ObjectInputStream(fi);
                    this.prevHHSyncType = oi.readInt();
                    MailSyncUtils.doDebug("prevHHSyncType = " + this.prevHHSyncType);
                    this.localRecords = (Vector)oi.readObject();
                    MailSyncUtils.doDebug("localRecords.size = " + this.localRecords.size());
                    MailSyncUtils.doLog("Finish MailLocalDBMgr.open() at " + new Date());
                }
                catch (Exception exception) {
                    if (!file.exists()) break block7;
                    MailSyncUtils.doLog(mailRes.getString("Corrupted local database is removed."));
                    file.delete();
                }
            }
            Object var4_4 = null;
            if (oi == null) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (oi == null) throw throwable;
            try {
                oi.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            oi.close();
            return;
        }
        catch (IOException iOException) {}
    }

    void purgeAll() {
        this.localRecords.removeAllElements();
    }

    public void setCurHHSyncType(int syncType) {
        this.curHHSyncType = syncType;
    }

    private void setHHFlags(MailSyncLocalDBRec localRec, MailRecord hhRecord) {
        localRec.setIsOnPilot(true);
        localRec.setPilotID(hhRecord.getId());
        localRec.setHHreadFlag(hhRecord.getIsRead());
        if (hhRecord.isDeleted() || hhRecord.getCategoryIndex() == 2) {
            localRec.setHHdeleteFlag(true);
        } else {
            localRec.setHHdeleteFlag(false);
        }
    }

    void setPilotDB(int pilotDB) {
        this.pilotDB = pilotDB;
    }

    void updateReadFlagOnPilot() {
        int i = 0;
        while (i < this.localRecords.size()) {
            block4: {
                MailSyncLocalDBRec localRec = (MailSyncLocalDBRec)this.localRecords.elementAt(i);
                if (localRec.getIsOnPilot() && !localRec.getDTdeleteFlag() && !localRec.getHHdeleteFlag() && localRec.getDTreadFlag() && !localRec.getHHreadFlag()) {
                    MailRecord rec = localRec.getRecord();
                    rec.setIsRead(true);
                    try {
                        SyncManager.writeRec((int)this.pilotDB, (Record)rec);
                    }
                    catch (IOException iOException) {
                        MailSyncUtils.doDebug("Update HH read flag failed, rec = " + rec.toFormattedString());
                        break block4;
                    }
                    localRec.setHHreadFlag(true);
                }
            }
            ++i;
        }
    }

    void verifyPilotRecs() throws IOException {
        MailSyncLocalDBRec localRec;
        int i = 0;
        while (i < this.localRecords.size()) {
            localRec = (MailSyncLocalDBRec)this.localRecords.elementAt(i);
            localRec.setIsOnPilot(false);
            ++i;
        }
        int[] recIDs = this.getPilotRecIDArray();
        if (recIDs != null) {
            MailSyncUtils.doDebug("MailSyncLocalDBMgr.verifyPilotRecs: recIDs.length = " + recIDs.length);
            int i2 = 0;
            while (i2 < recIDs.length) {
                int index = this.matchPilotID(recIDs[i2]);
                if (index != -1) {
                    MailSyncUtils.doDebug("verifyPilotRecs: rec " + i2 + " FOUND on Pilot, local DB index = " + i2);
                    localRec = (MailSyncLocalDBRec)this.localRecords.elementAt(index);
                    localRec.setIsOnPilot(true);
                }
                ++i2;
            }
        } else {
            MailSyncUtils.doDebug("the getPilotRecIDArray is null");
        }
        MailSyncUtils.doDebug("finish verifyPilotRecs.");
    }
}

