/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.MailSync;

public class MailSyncException
extends Exception {
    public Exception error;
    public int errorCode;
    public static final int NONE = 0;
    public static final int FIRST = 4096;
    public static final int ERR_OPEN_FOLDER = 4097;
    public static final int ERR_IMAP_AUTH = 4098;
    public static final int ERR_OPEN_LOCAL_DB = 4099;
    public static final int ERR_OPEN_PILOT_DB = 4100;
    public static final int ERR_READ_PILOT_PREF = 4101;
    public static final int ERR_SEND_OUTBOX = 4102;
    public static final int ERR_DT_SENDMAIL = 4103;
    public static final int ERR_VERIFY_PILOT_RECS = 4104;
    public static final int ERR_NO_IMAP_PROVIDER = 4105;
    public static final int ERR_CONNECT_IMAP = 4106;
    public static final int ERR_NO_MBOX_PROVIDER = 4107;
    public static final int ERR_CONNECT_MBOX = 4108;
    public static final int ERR_CONNECT_STORE = 4109;
    public static final int ERR_GET_FOLDER = 4110;
    public static final int ERR_FOLDER_NOTFOUND = 4111;
    public static final int ERR_MODIFIED_REC = 4112;
    public static final int ERR_CLOSE_FOLDER = 4113;
    public static final int ERR_CLOSE_STORE = 4114;
    public static final int ERR_READ_DT_RECS = 4115;
    public static final int MAILBOX_DISCONNECT = 4116;
    public static final int CREATE_DESKTOP_MGR = 4117;
    public static final int OPEN_DT_MAIL_SESSION = 4118;
    public static final int EMPTY_DT_MAILBOX = 4119;
    static final int LAST = 4119;
    static final int NUM = 23;
    static final String[] details = new String[]{"None", "Cannot open desktop mail folder, check existence/read&write permission", "Desktop IMAP authentication failure, check server/login/password", "Error opening local database", "Error opening pilot mail database", "Error reading pilot preference database", "Error getting HH outbox folder", "Error in sending email from desktop", "verify HH pilot records fail", "Cannot find desktop IMAP provider", "Error connecting to desktop IMAP server", "Cannot find desktop local mailbox provider", "Error connecting desktop local mailbox", "Error connecting desktop  mail store", "Error getting desktop mail folder", "Cannot find desktop mail folder", "Error in handling modified records from HH", "Error closing desktop mail folder", "Error closing desktop mail store", "Error reading messages in desktop mailbox", "Unexpected desktop mailbox disconnection", "Error in creating desktop mail manager", "Error in getting desktop mail session", "Empty desktop mailbox, mail sync not performed"};
    private String msg;

    public MailSyncException() {
        this.msg = null;
        this.error = null;
        this.errorCode = 0;
    }

    public MailSyncException(int errorCode) {
        this.msg = null;
        this.error = null;
        this.errorCode = errorCode;
    }

    public MailSyncException(int errorCode, Exception error) {
        this.msg = null;
        this.errorCode = errorCode;
        this.error = error;
    }

    public MailSyncException(String msg, int errorCode) {
        this.msg = msg;
        this.error = null;
        this.errorCode = errorCode;
    }

    public MailSyncException(String msg, int errorCode, Exception error) {
        this.msg = msg;
        this.errorCode = errorCode;
        this.error = error;
    }

    public MailSyncException(String msg, MailSyncException me) {
        this.msg = msg;
        this.error = me.error;
        this.errorCode = me.errorCode;
    }

    public String getMessage() {
        String exceptionMsg = "Unknown";
        if (this.errorCode >= 4096 && this.errorCode <= 4119) {
            String errStr;
            exceptionMsg = this.msg != null ? String.valueOf(this.msg) + details[this.errorCode - 4096] : details[this.errorCode - 4096];
            if (this.error != null && (errStr = this.error.getMessage()) != null) {
                exceptionMsg = String.valueOf(exceptionMsg) + "\n -->" + errStr;
            }
        }
        return exceptionMsg;
    }
}

