/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.MailSync;

import com.sun.pdasync.Conduits.MailSync.MailPref;
import com.sun.pdasync.Conduits.MailSync.MailRecord;
import com.sun.pdasync.Conduits.MailSync.MailSyncException;
import com.sun.pdasync.Conduits.MailSync.MailSyncLocalDBRec;
import com.sun.pdasync.Conduits.MailSync.MailSyncProperties;
import com.sun.pdasync.Conduits.MailSync.MailSyncUI;
import com.sun.pdasync.Conduits.MailSync.MailSyncUtils;
import com.sun.pdasync.SyncUtils.SyncConstants;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.event.ConnectionEvent;
import javax.mail.event.ConnectionListener;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.search.AndTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.FromStringTerm;
import javax.mail.search.MessageIDTerm;
import javax.mail.search.NotTerm;
import javax.mail.search.RecipientStringTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SentDateTerm;
import javax.mail.search.SubjectTerm;

public class MailSyncDesktopMgr
implements ConnectionListener {
    Session mailSession = null;
    Store mailStore = null;
    Folder mailFolder;
    Vector dtRecords;
    private MailSyncUI mailUI;
    private MailSyncProperties mailProps;
    Vector connectionListeners = null;
    boolean mailboxInterrupt = false;
    boolean closeInboxFlag = false;

    public MailSyncDesktopMgr(MailSyncUI mailUI, MailSyncProperties props) throws MailSyncException {
        this.mailUI = mailUI;
        this.mailProps = props;
        this.dtRecords = new Vector();
        if (this.mailSession == null) {
            try {
                MailAuthenticator mailAuthenticator = new MailAuthenticator();
                this.mailSession = Session.getDefaultInstance((Properties)System.getProperties(), (Authenticator)mailAuthenticator);
            }
            catch (Exception e) {
                throw new MailSyncException(4118, e);
            }
            catch (Throwable throwable) {
                throw new MailSyncException(4118);
            }
        }
        this.connectionListeners = new Vector();
    }

    public synchronized void addMailboxConnectionListener(ConnectionListener l) {
        if (this.connectionListeners == null) {
            this.connectionListeners = new Vector();
        }
        this.connectionListeners.addElement(l);
    }

    public void closeInbox() throws MailSyncException {
        this.closeInboxFlag = true;
        if (this.mailFolder != null) {
            block6: {
                try {
                    this.mailFolder.close(false);
                }
                catch (MessagingException me) {
                    if (me instanceof FolderNotFoundException) break block6;
                    throw new MailSyncException(4113, (Exception)((Object)me));
                }
            }
            this.mailFolder = null;
            MailSyncUtils.doDebug("closeInbox: close folder.");
        }
        if (this.mailStore != null) {
            try {
                this.mailStore.close();
            }
            catch (MessagingException me) {
                throw new MailSyncException(4114, (Exception)((Object)me));
            }
            this.mailStore = null;
            MailSyncUtils.doDebug("closeInbox: close store");
        }
    }

    public void closed(ConnectionEvent ce) {
        this.handleConnectionEvent(ce);
    }

    public Message convertHHToMsg(MailRecord hhRecord) throws MessagingException {
        String reply;
        String bcc;
        MimeMessage msg = new MimeMessage(this.mailSession);
        msg.setSentDate(hhRecord.getDate());
        msg.setFlag(Flags.Flag.SEEN, hhRecord.getIsRead());
        msg.setSubject(hhRecord.getSubject());
        msg.setFrom((Address)new InternetAddress(hhRecord.getFrom()));
        msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)hhRecord.getTo()));
        String cc = hhRecord.getCc();
        if (cc != null) {
            msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)cc));
        }
        if ((bcc = hhRecord.getBcc()) != null) {
            msg.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)bcc));
        }
        if ((reply = hhRecord.getReplyTo()) != null) {
            msg.setReplyTo((Address[])InternetAddress.parse((String)reply));
        }
        String text = hhRecord.getBody();
        if (hhRecord.getIsSignature()) {
            text = String.valueOf(text) + "\n\n";
            text = String.valueOf(text) + MailPref.getSignature();
        }
        msg.setText(text);
        return msg;
    }

    public void deleteMessage(MailSyncLocalDBRec dtRecord) throws MailSyncException {
        int msgnum = dtRecord.getDesktopID();
        MailSyncUtils.doDebug("deleteMessage: msgnum = " + msgnum);
        Message message = null;
        try {
            message = this.mailFolder.getMessage(msgnum);
            message.setFlag(Flags.Flag.DELETED, true);
        }
        catch (MessagingException e) {
            if (this.mailboxInterrupt) {
                throw new MailSyncException(4116);
            }
            MailSyncUtils.doDebug("deleteMessage: error " + e.toString());
            return;
        }
    }

    public void disconnected(ConnectionEvent ce) {
        this.handleConnectionEvent(ce);
    }

    private int getCategoryID(String folderName) {
        int id = folderName.equalsIgnoreCase("INBOX") ? 0 : (folderName.equalsIgnoreCase("OUTBOX") ? 1 : (folderName.equalsIgnoreCase("DELETE") ? 2 : (folderName.equalsIgnoreCase("FILED") ? 3 : (folderName.equalsIgnoreCase("DRAFT") ? 4 : -1))));
        return id;
    }

    private void handleConnectionEvent(ConnectionEvent ce) {
        if (!this.closeInboxFlag) {
            this.mailboxInterrupt = true;
            this.notifyMailboxConnectionListeners(ce);
        }
    }

    public boolean isMailboxInterrupted() {
        return this.mailboxInterrupt;
    }

    public Message matchMessage(MailSyncLocalDBRec dtRecord) throws MailSyncException {
        String msgID = dtRecord.getDesktopMsgID();
        MailSyncUtils.doDebug("matchMessage: msgID = " + msgID);
        Message message = null;
        try {
            Object searchTerm = null;
            if (msgID != null) {
                searchTerm = new MessageIDTerm(msgID);
            } else {
                String to;
                String from;
                String subject;
                MailRecord hhRecord = dtRecord.getRecord();
                Date date = hhRecord.getDate();
                if (date != null) {
                    searchTerm = new SentDateTerm(3, date);
                }
                if ((subject = hhRecord.getSubject()) != null) {
                    searchTerm = searchTerm == null ? new SubjectTerm(subject) : new AndTerm((SearchTerm)searchTerm, (SearchTerm)new SubjectTerm(subject));
                }
                if ((from = hhRecord.getFrom()) != null) {
                    searchTerm = searchTerm != null ? new AndTerm((SearchTerm)searchTerm, (SearchTerm)new FromStringTerm(from)) : new FromStringTerm(from);
                }
                if ((to = hhRecord.getTo()) != null) {
                    searchTerm = searchTerm != null ? new AndTerm((SearchTerm)searchTerm, (SearchTerm)new RecipientStringTerm(Message.RecipientType.TO, to)) : new RecipientStringTerm(Message.RecipientType.TO, to);
                }
            }
            Message[] messages = this.mailFolder.search((SearchTerm)searchTerm);
            if (messages.length > 0) {
                message = messages[0];
            }
        }
        catch (MessagingException e) {
            if (this.mailboxInterrupt) {
                throw new MailSyncException(4116);
            }
            MailSyncUtils.doDebug("matchMessage: error " + e.toString());
            message = null;
        }
        return message;
    }

    protected void notifyMailboxConnectionListeners(ConnectionEvent ce) {
        int i = 0;
        while (i < this.connectionListeners.size()) {
            ConnectionListener connectionListener = (ConnectionListener)this.connectionListeners.elementAt(i);
            ce.dispatch((Object)connectionListener);
            ++i;
        }
    }

    public void opened(ConnectionEvent ce) {
    }

    public Message[] readRecords(String folderName, MailPref mailPref) throws MailSyncException {
        Message[] mailMsgs = null;
        if (this.mailProps.mailProtocol == 1) {
            try {
                this.mailStore = this.mailSession.getStore("imap");
            }
            catch (NoSuchProviderException e) {
                throw new MailSyncException(4105, (Exception)((Object)e));
            }
            String serverName = this.mailProps.serverText;
            try {
                this.mailStore.connect(this.mailProps.serverText, null, null);
            }
            catch (MessagingException me) {
                if (!serverName.equals(this.mailProps.serverText)) {
                    try {
                        this.mailStore.connect(this.mailProps.serverText, null, null);
                    }
                    catch (MessagingException e) {
                        if (e instanceof AuthenticationFailedException) {
                            throw new MailSyncException(4098, (Exception)((Object)e));
                        }
                        throw new MailSyncException(4106, (Exception)((Object)e));
                    }
                }
                if (me instanceof AuthenticationFailedException) {
                    throw new MailSyncException(4098, (Exception)((Object)me));
                }
                throw new MailSyncException(4106, (Exception)((Object)me));
            }
        } else {
            try {
                this.mailStore = this.mailSession.getStore("mbox");
            }
            catch (NoSuchProviderException e) {
                throw new MailSyncException(4107, (Exception)((Object)e));
            }
            try {
                this.mailStore.connect();
            }
            catch (MessagingException me) {
                throw new MailSyncException(4108, (Exception)((Object)me));
            }
        }
        try {
            this.mailFolder = this.mailStore.getDefaultFolder();
        }
        catch (MessagingException me) {
            throw new MailSyncException(4109, (Exception)((Object)me));
        }
        if (this.mailFolder != null) {
            try {
                this.mailFolder = this.mailFolder.getFolder(folderName);
            }
            catch (MessagingException me) {
                throw new MailSyncException(4110, (Exception)((Object)me));
            }
            if (this.mailFolder != null) {
                try {
                    this.mailFolder.open(2);
                }
                catch (MessagingException me) {
                    if (me instanceof FolderNotFoundException) {
                        throw new MailSyncException(4111, (Exception)((Object)me));
                    }
                    throw new MailSyncException(4097, (Exception)((Object)me));
                }
                this.mailFolder.addConnectionListener((ConnectionListener)this);
                try {
                    int msgCount = this.mailFolder.getMessageCount();
                    if (msgCount != 0) {
                        FlagTerm folderSearchTerm;
                        Flags deleteFlag = new Flags(Flags.Flag.DELETED);
                        FlagTerm deleteTerm = new FlagTerm(deleteFlag, false);
                        int mailSyncType = MailPref.getSyncType();
                        if (mailSyncType == 3) {
                            Flags readFlag = new Flags(Flags.Flag.SEEN);
                            FlagTerm readTerm = new FlagTerm(readFlag, false);
                            folderSearchTerm = new AndTerm((SearchTerm)deleteTerm, (SearchTerm)readTerm);
                        } else if (mailSyncType == 2) {
                            int filterType = MailPref.getFilterType();
                            int nterm = 0;
                            String filterTo = MailPref.getFilterTo();
                            if (filterTo != null && filterTo.length() > 0) {
                                ++nterm;
                            } else {
                                filterTo = null;
                            }
                            String filterFrom = MailPref.getFilterFrom();
                            if (filterFrom != null && filterFrom.length() > 0) {
                                ++nterm;
                            } else {
                                filterFrom = null;
                            }
                            String filterSubject = MailPref.getFilterSubject();
                            if (filterSubject != null && filterSubject.length() > 0) {
                                ++nterm;
                            } else {
                                filterSubject = null;
                            }
                            if (nterm > 0) {
                                SearchTerm[] searchTerms = new SearchTerm[nterm];
                                int i = 0;
                                if (filterTo != null) {
                                    searchTerms[i] = new RecipientStringTerm(Message.RecipientType.TO, filterTo);
                                    ++i;
                                }
                                if (filterFrom != null) {
                                    searchTerms[i] = new FromStringTerm(filterFrom);
                                    ++i;
                                }
                                if (filterSubject != null) {
                                    searchTerms[i] = new SubjectTerm(filterSubject);
                                    ++i;
                                }
                                AndTerm filterTerm = new AndTerm(searchTerms);
                                folderSearchTerm = filterType == 0 ? new AndTerm((SearchTerm)deleteTerm, (SearchTerm)new NotTerm((SearchTerm)filterTerm)) : new AndTerm((SearchTerm)deleteTerm, (SearchTerm)filterTerm);
                            } else {
                                folderSearchTerm = deleteTerm;
                            }
                        } else {
                            folderSearchTerm = deleteTerm;
                        }
                        mailMsgs = this.mailFolder.search((SearchTerm)folderSearchTerm);
                    }
                }
                catch (MessagingException me) {
                    throw new MailSyncException(4115, (Exception)((Object)me));
                }
            }
        }
        int length = mailMsgs == null ? 0 : mailMsgs.length;
        MailSyncUtils.doDebug("MailSyncDesktopMgr.readRecords: read " + length + " messages.");
        return mailMsgs;
    }

    public synchronized void removeMailboxConnectionListener(ConnectionListener l) {
        if (this.connectionListeners != null) {
            this.connectionListeners.removeElement(l);
        }
    }

    public void resetMailboxInterruptFlag() {
        this.mailboxInterrupt = false;
    }

    public void sendMail(MailRecord hhRecord) throws MessagingException {
        hhRecord.setDate(new Date());
        hhRecord.setFrom(SyncConstants.USER_NAME);
        Message msg = this.convertHHToMsg(hhRecord);
        Transport.send((Message)msg);
    }

    public void setMessageRead(MailSyncLocalDBRec dtRecord) throws MailSyncException {
        int msgnum = dtRecord.getDesktopID();
        MailSyncUtils.doDebug("setMessageRead: msgnum = " + msgnum);
        Message message = null;
        try {
            message = this.mailFolder.getMessage(msgnum);
            message.setFlag(Flags.Flag.SEEN, true);
        }
        catch (MessagingException e) {
            if (this.mailboxInterrupt) {
                throw new MailSyncException(4116);
            }
            MailSyncUtils.doDebug("setMessageRead: error " + e.toString());
            return;
        }
    }

    private final class MailAuthenticator
    extends Authenticator {
        protected PasswordAuthentication getPasswordAuthentication() {
            PasswordAuthentication auth = MailSyncDesktopMgr.this.mailUI.getPasswordAuthentication();
            if (auth == null) {
                MailSyncDesktopMgr.this.mailUI.showLogin();
                auth = MailSyncDesktopMgr.this.mailUI.getPasswordAuthentication();
            }
            return auth;
        }
    }
}

