/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.MailSync;

import com.sun.pdasync.Conduits.MailSync.MailSyncException;
import com.sun.pdasync.Conduits.MailSync.MailSyncLocalDBMgr;
import com.sun.pdasync.Conduits.MailSync.MailSyncManager;
import com.sun.pdasync.Conduits.MailSync.MailSyncProperties;
import com.sun.pdasync.Conduits.MailSync.MailSyncUI;
import com.sun.pdasync.Conduits.MailSync.MailSyncUtils;
import com.sun.pdasync.SyncUtils.SyncUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import palm.conduit.Conduit;
import palm.conduit.ConfigureConduitInfo;
import palm.conduit.Log;
import palm.conduit.SyncException;
import palm.conduit.SyncProperties;

public class MailSyncConduit
implements Conduit,
Serializable {
    private static Locale theLocale;
    private static ResourceBundle mailRes;
    private MailSyncProperties mailProps = new MailSyncProperties();
    private MailSyncUI mailSyncUI = new MailSyncUI(SyncUtils.getParentOfAllConduits(), this.mailProps);

    static {
        try {
            theLocale = Locale.getDefault();
            MailSyncManager.mailRes = mailRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.MailSyncConduitMessages", theLocale);
            MailSyncLocalDBMgr.mailRes = mailRes;
        }
        catch (MissingResourceException e) {
            System.err.println("PDASync: can't find properties");
            System.err.println("PDASync:" + e.getMessage());
            System.exit(1);
        }
    }

    public int configure(ConfigureConduitInfo info) {
        this.mailSyncUI.showPropsUI();
        info.syncPermanent = this.mailProps.dtOverwritesPDA ? 3 : 0;
        info.syncTemporary = info.syncPermanent;
        return 0;
    }

    public String name() {
        return mailRes.getString("Mail");
    }

    public void open(SyncProperties syncProps) {
        MailSyncManager mailSyncMgr = null;
        try {
            mailSyncMgr = new MailSyncManager(this.mailSyncUI, syncProps, this.mailProps);
        }
        catch (MailSyncException me) {
            MailSyncUtils.doLog(me.getMessage());
            return;
        }
        catch (Throwable t) {
            MailSyncUtils.doLog(mailRes.getString("Error in creating Desktop Manager "));
            MailSyncUtils.doDebug(t.getMessage());
            return;
        }
        MailSyncUtils.doDebug("MailSyncConduit.open, syncProps = " + syncProps.dumpFormatted(2));
        if (syncProps.syncType == 6 || syncProps.syncType == 5 || syncProps.syncType == 2 || syncProps.syncType < 0 || syncProps.syncType > 7) {
            MailSyncUtils.doLog(mailRes.getString("Mail conduit does NOTHING based on the syncType."));
            MailSyncUtils.doDebug("syncProps.syncType = " + syncProps.syncType);
            return;
        }
        int syncType = syncProps.syncType == 4 || syncProps.syncType == 7 ? 3 : syncProps.syncType;
        MailSyncUtils.doDebug("syncType = " + syncType);
        try {
            Log.startSync();
            MailSyncUtils.doLog("Start Mail Conduit at " + new Date());
            mailSyncMgr.openLocalDB();
            try {
                mailSyncMgr.openPilotDB();
            }
            catch (Exception e) {
                MailSyncUtils.doLog(mailRes.getString("Cannot open HH mail database (abnormal error condition)."));
                e.printStackTrace();
                Log.abortSync();
                return;
            }
            mailSyncMgr.readPilotPrefs();
            mailSyncMgr.sendOutboxMsgs();
            mailSyncMgr.resetMailboxInterruptFlag();
            switch (syncType) {
                case 0: 
                case 1: {
                    MailSyncUtils.doLog(mailRes.getString("Perform Syncing data"));
                    mailSyncMgr.syncData();
                    break;
                }
                case 3: {
                    MailSyncUtils.doLog(mailRes.getString("Copy desktop messages to palm pilot"));
                    mailSyncMgr.copyDesktopToPilot();
                    break;
                }
            }
            mailSyncMgr.closePilotDB();
            mailSyncMgr.closeLocalDB();
            Log.endSync();
            MailSyncUtils.doLog("End Mail Conduit at " + new Date());
            return;
        }
        catch (Throwable t) {
            if (mailSyncMgr.isMailboxInterrupted()) {
                MailSyncUtils.doLog(mailRes.getString("Mail sync fail due to unexpected desktop mailbox disconnection."));
            } else if (t instanceof MailSyncException) {
                MailSyncUtils.doLog(t.getMessage());
            } else {
                MailSyncUtils.doLog(mailRes.getString("Mail sync fail, unknown error."));
                MailSyncUtils.doDebug("Mail sync fail. " + t.getMessage());
            }
            try {
                mailSyncMgr.closePilotDB();
            }
            catch (SyncException syncException) {}
            Log.abortSync();
            return;
        }
    }
}

