/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.MailSync;

import com.sun.pdasync.Conduits.MailSync.MailDBRecordFlags;
import com.sun.pdasync.Logger.Logger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import palm.conduit.AbstractRecord;

public class MailRecord
extends AbstractRecord
implements Serializable {
    private Date date = null;
    private boolean isRead = false;
    private boolean isSignature = false;
    private boolean isConfirmRead = false;
    private boolean isConfirmDelivery = false;
    private byte priority = 0;
    private byte addressing = 0;
    private String subject = null;
    private String from = null;
    private String To = null;
    private String Cc = null;
    private String Bcc = null;
    private String replyTo = null;
    private String sentTo = null;
    private String body = null;

    public MailRecord() {
    }

    public MailRecord(Date date) {
        this.date = date;
    }

    public byte getAddressing() {
        return this.addressing;
    }

    public String getBcc() {
        return this.Bcc;
    }

    public String getBody() {
        return this.body;
    }

    public String getCc() {
        return this.Cc;
    }

    public Date getDate() {
        return this.date;
    }

    public String getFrom() {
        return this.from;
    }

    public boolean getIsConfirmDelivery() {
        return this.isConfirmDelivery;
    }

    public boolean getIsConfirmRead() {
        return this.isConfirmRead;
    }

    public boolean getIsRead() {
        return this.isRead;
    }

    public boolean getIsSignature() {
        return this.isSignature;
    }

    public byte getPriority() {
        return this.priority;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public String getSentTo() {
        return this.sentTo;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getTo() {
        return this.To;
    }

    public void readData(DataInputStream in) throws IOException {
        MailDBRecordFlags flags = new MailDBRecordFlags();
        Calendar cal = Calendar.getInstance();
        this.date = AbstractRecord.sunwReadDate((DataInputStream)in);
        cal.setTime(this.date);
        short time = in.readShort();
        int hrmin = time == -1 ? 0 : AbstractRecord.toMinutes((int)time);
        cal.set(11, hrmin / 60);
        cal.set(12, hrmin % 60);
        this.date = cal.getTime();
        flags.readData(in);
        this.isRead = flags.read;
        this.isSignature = flags.signature;
        this.isConfirmRead = flags.confirmread;
        this.isConfirmDelivery = flags.confirmdelivery;
        this.priority = flags.priority;
        this.addressing = flags.addressing;
        in.read();
        this.subject = AbstractRecord.readCString((DataInputStream)in);
        this.from = AbstractRecord.readCString((DataInputStream)in);
        this.To = AbstractRecord.readCString((DataInputStream)in);
        this.Cc = AbstractRecord.readCString((DataInputStream)in);
        this.Bcc = AbstractRecord.readCString((DataInputStream)in);
        this.replyTo = AbstractRecord.readCString((DataInputStream)in);
        this.sentTo = AbstractRecord.readCString((DataInputStream)in);
        this.body = AbstractRecord.readCString((DataInputStream)in);
    }

    public void setAddressing(byte addressing) {
        this.addressing = addressing;
    }

    public void setBcc(String Bcc) {
        this.Bcc = Bcc;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setCc(String Cc) {
        this.Cc = Cc;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setIsConfirmDelivery(boolean isConfirmDelivery) {
        this.isConfirmDelivery = isConfirmDelivery;
    }

    public void setIsConfirmRead(boolean isConfirmRead) {
        this.isConfirmRead = isConfirmRead;
    }

    public void setIsRead(boolean isRead) {
        this.isRead = isRead;
    }

    public void setIsSignature(boolean isSignature) {
        this.isSignature = isSignature;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public void setSentTo(String sentTo) {
        this.sentTo = sentTo;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setTo(String To) {
        this.To = To;
    }

    public String toFormattedString() {
        return "Mail record: {\r\n  date: " + this.getDate() + "\r\n" + "  isRead: " + this.getIsRead() + "\r\n" + "  subject: " + this.getSubject() + "\r\n" + "  from: " + this.getFrom() + "\r\n" + "  to: " + this.getTo() + "\r\n" + "}\r\n" + super.toFormattedString();
    }

    public String toString() {
        return "Mail record: " + super.toString();
    }

    public void writeData(DataOutputStream out) throws IOException {
        String debugMsg = "MailRecord.writeData: " + this.toFormattedString();
        Logger.doDebugLogging((String)debugMsg, (int)5, (boolean)true);
        AbstractRecord.writeDate((DataOutputStream)out, (Date)this.date);
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.date);
        int time = cal.get(11) * 60 + cal.get(12);
        out.writeShort(AbstractRecord.fromMinutes((int)time));
        MailDBRecordFlags flags = new MailDBRecordFlags();
        flags.read = this.isRead;
        flags.signature = this.isSignature;
        flags.confirmread = this.isConfirmRead;
        flags.confirmdelivery = this.isConfirmDelivery;
        flags.priority = this.priority;
        flags.addressing = this.addressing;
        flags.writeData(out);
        out.write(0);
        if (this.subject != null) {
            AbstractRecord.writeCString((DataOutputStream)out, (String)AbstractRecord.sunwStringWithoutCarriageReturns((String)this.subject));
        } else {
            out.write(0);
        }
        if (this.from != null) {
            AbstractRecord.writeCString((DataOutputStream)out, (String)AbstractRecord.sunwStringWithoutCarriageReturns((String)this.from));
        } else {
            out.write(0);
        }
        if (this.To != null) {
            AbstractRecord.writeCString((DataOutputStream)out, (String)AbstractRecord.sunwStringWithoutCarriageReturns((String)this.To));
        } else {
            out.write(0);
        }
        if (this.Cc != null) {
            AbstractRecord.writeCString((DataOutputStream)out, (String)AbstractRecord.sunwStringWithoutCarriageReturns((String)this.Cc));
        } else {
            out.write(0);
        }
        if (this.Bcc != null) {
            AbstractRecord.writeCString((DataOutputStream)out, (String)AbstractRecord.sunwStringWithoutCarriageReturns((String)this.Bcc));
        } else {
            out.write(0);
        }
        if (this.replyTo != null) {
            AbstractRecord.writeCString((DataOutputStream)out, (String)AbstractRecord.sunwStringWithoutCarriageReturns((String)this.replyTo));
        } else {
            out.write(0);
        }
        if (this.sentTo != null) {
            AbstractRecord.writeCString((DataOutputStream)out, (String)AbstractRecord.sunwStringWithoutCarriageReturns((String)this.sentTo));
        } else {
            out.write(0);
        }
        if (this.body != null) {
            AbstractRecord.writeCString((DataOutputStream)out, (String)AbstractRecord.sunwStringWithoutCarriageReturns((String)this.body));
        } else {
            out.write(0);
        }
    }
}

