/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.MailSync;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import palm.conduit.AbstractRecord;
import palm.conduit.AppPreferenceInfo;
import palm.conduit.SyncException;
import palm.conduit.SyncManager;

public class MailPref {
    public static final int PREF_ALL = 0;
    public static final int PREF_SEND_ONLY = 1;
    public static final int PREF_FILTER = 2;
    public static final int PREF_UNREAD = 3;
    public static final int PREF_MSG_IGNORE = 0;
    public static final int PREF_MSG_RETRIEVE = 1;
    private static final short PREF_LOCALSYNC = 1;
    private static final short PREF_REMOTESYNC = 2;
    private static final short PREF_SIGNATURE = 3;
    private static int MAIL_RAW_REC_MEM = Short.MAX_VALUE;
    private static int syncType = 0;
    private static boolean retrieveHighPriority = false;
    private static int filterType = 0;
    private static int maxLength = 250;
    private static String filterTo = null;
    private static String filterFrom = null;
    private static String filterSubject = null;
    private static String signature = null;

    public static String getFilterFrom() {
        return filterFrom;
    }

    public static String getFilterSubject() {
        return filterSubject;
    }

    public static String getFilterTo() {
        return filterTo;
    }

    public static int getFilterType() {
        return filterType;
    }

    public static int getMaxLength() {
        return maxLength;
    }

    public static boolean getRetrieveHighPriority() {
        return retrieveHighPriority;
    }

    public static String getSignature() {
        return signature;
    }

    public static int getSyncType() {
        return syncType;
    }

    private void parseFilter(DataInputStream in) throws IOException {
        syncType = in.readByte();
        retrieveHighPriority = in.readBoolean();
        filterType = in.readByte();
        in.skipBytes(1);
        maxLength = in.readShort();
        String tmpStr = AbstractRecord.readCString((DataInputStream)in);
        filterTo = tmpStr.trim();
        tmpStr = AbstractRecord.readCString((DataInputStream)in);
        filterFrom = tmpStr.trim();
        tmpStr = AbstractRecord.readCString((DataInputStream)in);
        filterSubject = tmpStr.trim();
    }

    public void readData() throws SyncException, IOException {
        AppPreferenceInfo appInfo = null;
        short prefID = 1;
        short reqBytes = -1;
        boolean backedUP = true;
        byte[] bytes = new byte[MAIL_RAW_REC_MEM];
        int creatorID = 1835100524;
        short retBytes = 0;
        boolean prefExist = true;
        try {
            appInfo = SyncManager.readAppPreference((int)creatorID, (short)prefID, (short)reqBytes, (short)retBytes, (boolean)backedUP, (byte[])bytes);
        }
        catch (SyncException syncException) {
            prefExist = false;
        }
        if (prefExist) {
            ByteArrayInputStream byteIn = new ByteArrayInputStream(appInfo.getBytes());
            this.parseFilter(new DataInputStream(byteIn));
        }
        prefID = 3;
        retBytes = 0;
        try {
            appInfo = SyncManager.readAppPreference((int)creatorID, (short)prefID, (short)reqBytes, (short)retBytes, (boolean)backedUP, (byte[])bytes);
            signature = new String(appInfo.getBytes());
        }
        catch (SyncException syncException) {}
    }

    public String toFormattedString() {
        return "Mail Preference: {\r\n  syncType: " + MailPref.getSyncType() + "\r\n" + "  retriveHigh: " + MailPref.getRetrieveHighPriority() + "\r\n" + "  filterType: " + MailPref.getFilterType() + "\r\n" + "  maxLength: " + MailPref.getMaxLength() + "\r\n" + "  filterTo: " + MailPref.getFilterTo() + "\r\n" + "  filterFrom: " + MailPref.getFilterFrom() + "\r\n" + "  filterSubject: " + MailPref.getFilterSubject() + "\r\n" + "  signature: " + MailPref.getSignature() + "\r\n" + "}\r\n";
    }

    public String toString() {
        return "Mail preference: ";
    }
}

