/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.MailSync;

import com.sun.pdasync.Conduits.MailSync.MailPasswdKey;
import com.sun.pdasync.Conduits.MailSync.UnrecoverablePasswdException;
import com.sun.pdasync.SyncUtils.SyncUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

final class MailPasswdProtector {
    private static final int SALT_LEN = 20;
    private static final String DIGEST_ALG = "SHA";
    private static final int DIGEST_LEN = 20;
    private byte[] keyBytes;
    private MessageDigest md;

    public MailPasswdProtector(MailPasswdKey passwdKey) throws NoSuchAlgorithmException {
        if (passwdKey == null) {
            throw new IllegalArgumentException("key can't be null");
        }
        this.md = MessageDigest.getInstance(DIGEST_ALG);
        char[] key = passwdKey.getKey();
        this.keyBytes = new byte[key.length * 2];
        int i = 0;
        int j = 0;
        while (i < key.length) {
            this.keyBytes[j++] = (byte)(key[i] >> 8);
            this.keyBytes[j++] = (byte)key[i];
            ++i;
        }
        SyncUtils.fillArray((char[])key, (byte)0);
    }

    protected void finalize() {
        if (this.keyBytes != null) {
            SyncUtils.fillArray((byte[])this.keyBytes, (byte)0);
            this.keyBytes = null;
        }
    }

    public byte[] protect(char[] password) {
        int encrPasswdOffset = 0;
        if (password == null) {
            throw new IllegalArgumentException("plaintext password can't be null");
        }
        byte[] plainPassword = new byte[password.length];
        int i = 0;
        while (i < password.length) {
            plainPassword[i] = (byte)password[i];
            ++i;
        }
        int numRounds = plainPassword.length / 20;
        if (plainPassword.length % 20 != 0) {
            ++numRounds;
        }
        byte[] salt = new byte[20];
        SecureRandom random = new SecureRandom();
        random.nextBytes(salt);
        byte[] xorPassword = new byte[plainPassword.length];
        i = 0;
        int xorOffset = 0;
        byte[] digest = salt;
        while (i < numRounds) {
            this.md.update(this.keyBytes);
            this.md.update(digest);
            digest = this.md.digest();
            this.md.reset();
            if (i < numRounds - 1) {
                System.arraycopy(digest, 0, xorPassword, xorOffset, digest.length);
            } else {
                System.arraycopy(digest, 0, xorPassword, xorOffset, xorPassword.length - xorOffset);
            }
            ++i;
            xorOffset += 20;
        }
        byte[] tmpPassword = new byte[plainPassword.length];
        i = 0;
        while (i < tmpPassword.length) {
            tmpPassword[i] = (byte)(plainPassword[i] ^ xorPassword[i]);
            ++i;
        }
        byte[] encrPassword = new byte[salt.length + tmpPassword.length + 20];
        System.arraycopy(salt, 0, encrPassword, encrPasswdOffset, salt.length);
        System.arraycopy(tmpPassword, 0, encrPassword, encrPasswdOffset += salt.length, tmpPassword.length);
        encrPasswdOffset += tmpPassword.length;
        this.md.update(this.keyBytes);
        SyncUtils.fillArray((byte[])this.keyBytes, (byte)0);
        this.keyBytes = null;
        this.md.update(plainPassword);
        digest = this.md.digest();
        this.md.reset();
        System.arraycopy(digest, 0, encrPassword, encrPasswdOffset, digest.length);
        return encrPassword;
    }

    public byte[] recover(byte[] encrData) throws UnrecoverablePasswdException {
        byte[] salt = new byte[20];
        System.arraycopy(encrData, 0, salt, 0, 20);
        int encrPasswdLen = encrData.length - 20 - 20;
        int numRounds = encrPasswdLen / 20;
        if (encrPasswdLen % 20 != 0) {
            ++numRounds;
        }
        byte[] encrPassword = new byte[encrPasswdLen];
        System.arraycopy(encrData, 20, encrPassword, 0, encrPasswdLen);
        byte[] xorPassword = new byte[encrPassword.length];
        int i = 0;
        int xorOffset = 0;
        byte[] digest = salt;
        while (i < numRounds) {
            this.md.update(this.keyBytes);
            this.md.update(digest);
            digest = this.md.digest();
            this.md.reset();
            if (i < numRounds - 1) {
                System.arraycopy(digest, 0, xorPassword, xorOffset, digest.length);
            } else {
                System.arraycopy(digest, 0, xorPassword, xorOffset, xorPassword.length - xorOffset);
            }
            ++i;
            xorOffset += 20;
        }
        byte[] plainPassword = new byte[encrPassword.length];
        i = 0;
        while (i < plainPassword.length) {
            plainPassword[i] = (byte)(encrPassword[i] ^ xorPassword[i]);
            ++i;
        }
        this.md.update(this.keyBytes);
        SyncUtils.fillArray((byte[])this.keyBytes, (byte)0);
        this.keyBytes = null;
        this.md.update(plainPassword);
        digest = this.md.digest();
        this.md.reset();
        i = 0;
        while (i < digest.length) {
            if (digest[i] != encrData[20 + encrPasswdLen + i]) {
                throw new UnrecoverablePasswdException("Cannot recover password");
            }
            ++i;
        }
        return plainPassword;
    }
}

