/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.mbox;

import com.sun.mail.mbox.InboxFile;
import com.sun.mail.mbox.UNIXFile;
import com.sun.mail.mbox.UNIXFolder;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class UNIXInbox
extends UNIXFolder
implements InboxFile {
    String user;
    private RandomAccessFile lockfile;
    private String lockfileName;

    public UNIXInbox(String user, String name) {
        super(name);
        this.user = user;
    }

    public void closeLock() {
        if (this.lockfile == null) {
            return;
        }
        try {
            try {
                this.lockfile.close();
            }
            catch (IOException iOException) {
            }
            Object var2_1 = null;
            this.lockfile = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lockfile = null;
            throw throwable;
        }
    }

    public boolean lock(String mode) {
        if (!UNIXFile.loaded) {
            return false;
        }
        if (!this.maillock(this.user, 5)) {
            return false;
        }
        if (!super.lock(mode)) {
            this.mailunlock();
            return false;
        }
        return true;
    }

    private native boolean maillock(String var1, int var2);

    private native void mailunlock();

    public boolean openLock(String mode) {
        if (mode.equals("r")) {
            return true;
        }
        if (this.lockfileName == null) {
            String home = System.getProperty("user.home");
            this.lockfileName = String.valueOf(home) + File.separator + ".Maillock";
        }
        try {
            this.lockfile = new RandomAccessFile(this.lockfileName, mode);
            boolean ret = UNIXFile.lock(this.lockfile.getFD(), mode);
            if (!ret) {
                this.closeLock();
            }
            return ret;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void touchlock() {
        if (UNIXFile.loaded) {
            this.touchlock0();
        }
    }

    private native void touchlock0();

    public void unlock() {
        super.unlock();
        if (UNIXFile.loaded) {
            this.mailunlock();
        }
    }
}

