/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.mbox;

import com.sun.mail.mbox.ContentLengthCounter;
import com.sun.mail.mbox.LineCounter;
import com.sun.mail.mbox.MboxFolder;
import com.sun.mail.mbox.NewlineOutputStream;
import com.sun.mail.mbox.SunV3BodyPart;
import com.sun.mail.mbox.SunV3Multipart;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;

public class MboxMessage
extends MimeMessage {
    boolean modified = false;
    boolean writable = false;
    Flags origFlags;
    String unix_from;
    InternetAddress unix_from_user;
    Date rcvDate;
    int lineCount = -1;
    private static OutputStream nullOutputStream = new OutputStream(){

        public void write(int b) {
        }

        public void write(byte[] b, int off, int len) {
        }
    };

    public MboxMessage(MboxFolder folder, InternetHeaders hdrs, byte[] content, int msgno, String unix_from, boolean writable) throws MessagingException {
        super((Folder)folder, hdrs, content, msgno);
        this.setFlagsFromHeaders();
        this.origFlags = this.getFlags();
        this.unix_from = unix_from;
        this.writable = writable;
    }

    protected InputStream getContentStream() throws MessagingException {
        if (!this.isSet(Flags.Flag.SEEN)) {
            this.setFlag(Flags.Flag.SEEN, true);
        }
        return super.getContentStream();
    }

    public String getContentType() throws MessagingException {
        String ct = super.getContentType();
        if (ct.indexOf(47) < 0) {
            ct = SunV3BodyPart.MimeV3Map.toMime(ct);
        }
        return ct;
    }

    public synchronized DataHandler getDataHandler() throws MessagingException {
        if (this.dh == null) {
            String ct = this.getContentType();
            if (ct.equalsIgnoreCase("multipart/x-sun-attachment")) {
                this.dh = new DataHandler((Object)new SunV3Multipart((DataSource)new MimePartDataSource((MimePart)this)), ct);
            } else {
                return super.getDataHandler();
            }
        }
        return this.dh;
    }

    public Address[] getFrom() throws MessagingException {
        Address[] ret = super.getFrom();
        if (ret == null && this.unix_from != null) {
            int i;
            if (this.unix_from_user == null && (i = this.unix_from.indexOf(32, 5)) > 5) {
                try {
                    this.unix_from_user = new InternetAddress(this.unix_from.substring(5, i));
                }
                catch (AddressException addressException) {}
            }
            if (this.unix_from_user != null) {
                ret = new InternetAddress[]{this.unix_from_user};
            }
        }
        return ret;
    }

    public int getLineCount() throws MessagingException {
        if (this.lineCount < 0 && this.isMimeType("text/plain")) {
            LineCounter lc = new LineCounter(nullOutputStream);
            boolean seen = this.isSet(Flags.Flag.SEEN);
            try {
                this.getDataHandler().writeTo((OutputStream)lc);
                this.lineCount = lc.getLineCount();
                lc.close();
            }
            catch (IOException iOException) {}
            if (!seen) {
                this.setFlag(Flags.Flag.SEEN, false);
            }
        }
        return this.lineCount;
    }

    public Date getReceivedDate() throws MessagingException {
        block2: {
            int i;
            if (this.rcvDate != null || this.unix_from == null || (i = this.unix_from.indexOf(32, 5)) <= 5) break block2;
            try {
                this.rcvDate = new Date(this.unix_from.substring(i));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return this.rcvDate;
    }

    public void saveChanges() throws MessagingException {
        if (!this.writable) {
            throw new MessagingException("Message is read-only");
        }
        this.modified = true;
        super.saveChanges();
        try {
            ContentLengthCounter cos = new ContentLengthCounter();
            NewlineOutputStream os = new NewlineOutputStream(cos);
            super.writeTo((OutputStream)os);
            ((OutputStream)os).flush();
            this.setHeader("Content-Length", String.valueOf(cos.getSize()));
        }
        catch (MessagingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessagingException("unexpected exception " + e);
        }
    }

    public void setFlags(Flags newFlags, boolean set) throws MessagingException {
        Flags oldFlags = (Flags)this.flags.clone();
        super.setFlags(newFlags, set);
        if (!this.flags.equals((Object)oldFlags)) {
            this.setHeadersFromFlags();
            ((MboxFolder)((Message)this).folder).notifyMessageChangedListeners(1, (Message)this);
        }
    }

    private synchronized void setFlagsFromHeaders() {
        this.flags = new Flags(Flags.Flag.RECENT);
        try {
            String s = this.getHeader("Status", null);
            if (s != null) {
                if (s.indexOf(82) >= 0) {
                    this.flags.add(Flags.Flag.SEEN);
                }
                if (s.indexOf(79) >= 0) {
                    this.flags.remove(Flags.Flag.RECENT);
                }
            }
            if ((s = this.getHeader("X-Dt-Delete-Time", null)) != null) {
                this.flags.add(Flags.Flag.DELETED);
            }
            if ((s = this.getHeader("X-Status", null)) != null) {
                if (s.indexOf(68) >= 0) {
                    this.flags.add(Flags.Flag.DELETED);
                }
                if (s.indexOf(70) >= 0) {
                    this.flags.add(Flags.Flag.FLAGGED);
                }
                if (s.indexOf(65) >= 0) {
                    this.flags.add(Flags.Flag.ANSWERED);
                }
                if (s.indexOf(84) >= 0) {
                    this.flags.add(Flags.Flag.DRAFT);
                }
            }
            if ((s = this.getHeader("X-Keywords", null)) != null) {
                StringTokenizer st = new StringTokenizer(s);
                while (st.hasMoreTokens()) {
                    this.flags.add(st.nextToken());
                }
            }
        }
        catch (MessagingException messagingException) {}
    }

    private synchronized void setHeadersFromFlags() {
        try {
            StringBuffer status = new StringBuffer();
            if (this.flags.contains(Flags.Flag.SEEN)) {
                status.append('R');
            }
            if (!this.flags.contains(Flags.Flag.RECENT)) {
                status.append('O');
            }
            this.setHeader("Status", status.toString());
            boolean sims = false;
            String s = this.getHeader("X-Status", null);
            sims = s != null && s.length() == 4 && s.indexOf(36) >= 0;
            status.setLength(0);
            if (this.flags.contains(Flags.Flag.DELETED)) {
                status.append('D');
            } else if (sims) {
                status.append('$');
            }
            if (this.flags.contains(Flags.Flag.FLAGGED)) {
                status.append('F');
            } else if (sims) {
                status.append('$');
            }
            if (this.flags.contains(Flags.Flag.ANSWERED)) {
                status.append('A');
            } else if (sims) {
                status.append('$');
            }
            if (this.flags.contains(Flags.Flag.DRAFT)) {
                status.append('T');
            } else if (sims) {
                status.append('$');
            }
            this.setHeader("X-Status", status.toString());
            String[] userFlags = this.flags.getUserFlags();
            if (userFlags.length > 0) {
                status.setLength(0);
                int i = 0;
                while (i < userFlags.length) {
                    status.append(userFlags[i]).append(' ');
                    ++i;
                }
                status.setLength(status.length() - 1);
                this.setHeader("X-Keywords", status.toString());
            }
            if (this.flags.contains(Flags.Flag.DELETED) && (s = this.getHeader("X-Dt-Delete-Time", null)) == null) {
                this.setHeader("X-Dt-Delete-Time", "1");
            }
        }
        catch (MessagingException messagingException) {}
    }

    protected void setMessageNumber(int msgno) {
        super.setMessageNumber(msgno);
    }

    protected void updateHeaders() throws MessagingException {
        super.updateHeaders();
        this.setHeadersFromFlags();
    }

    public void writeToFile(OutputStream os) throws Exception {
        try {
            os = new NewlineOutputStream(os);
            PrintStream pos = new PrintStream(os);
            pos.println(this.unix_from);
            super.writeTo((OutputStream)pos);
            pos.println();
        }
        catch (MessagingException messagingException) {}
    }
}

