/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.mbox;

import com.sun.mail.mbox.ContentLengthCounter;
import com.sun.mail.mbox.ContentLengthUpdater;
import com.sun.mail.mbox.InboxFile;
import com.sun.mail.mbox.MailFile;
import com.sun.mail.mbox.MboxMessage;
import com.sun.mail.mbox.MboxStore;
import com.sun.mail.mbox.NewlineOutputStream;
import com.sun.mail.mbox.match;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;

public class MboxFolder
extends Folder {
    private String name;
    private boolean is_inbox = false;
    private int total;
    private boolean opened = false;
    private Vector message_cache;
    private MboxStore mstore;
    private MailFile folder;
    private long file_size;
    private long saved_file_size;
    private MboxMessage special_imap_message;

    protected MboxFolder(MboxStore store, String name) {
        super((Store)store);
        this.mstore = store;
        this.name = name;
        if (name != null && name.equalsIgnoreCase("INBOX")) {
            this.is_inbox = true;
        }
        this.folder = this.mstore.getMailFile(name == null ? "~" : name);
        this.saved_file_size = this.folder.exists() ? this.folder.length() : -1L;
    }

    public synchronized void appendMessages(Message[] msgs) throws MessagingException {
        boolean err;
        block16: {
            if (!this.folder.lock("rw")) {
                throw new MessagingException("Failed to lock folder");
            }
            OutputStream os = null;
            err = false;
            try {
                try {
                    os = new BufferedOutputStream(new FileOutputStream(((File)((Object)this.folder)).getPath(), true));
                    int i = 0;
                    while (i < msgs.length) {
                        if (!(msgs[i] instanceof MimeMessage)) {
                            err = true;
                        } else {
                            MboxFolder.writeMboxMessage((MimeMessage)msgs[i], os);
                            this.folder.touchlock();
                        }
                        ++i;
                    }
                }
                catch (IOException e) {
                    throw new MessagingException("I/O Exception", (Exception)e);
                }
                catch (MessagingException e) {
                    throw e;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new MessagingException("unexpected exception " + e);
                }
                Object var5_8 = null;
                if (os == null) break block16;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
                this.folder.unlock();
                throw throwable;
            }
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
        this.folder.unlock();
        if (this.opened) {
            this.getMessageCount();
        }
        if (err) {
            throw new MessagingException("Can't append non-Mime message");
        }
    }

    private static String canonicalize(String ref, String pat) {
        if (ref == null) {
            return pat;
        }
        try {
            if (pat.length() == 0) {
                return ref;
            }
            if (pat.charAt(0) == File.separatorChar) {
                return String.valueOf(ref.substring(0, ref.indexOf(File.separatorChar))) + pat;
            }
            return String.valueOf(ref) + pat;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return pat;
        }
    }

    void checkClosed() throws MessagingException {
        if (this.opened) {
            throw new MessagingException("Folder is Open");
        }
    }

    void checkOpen() throws MessagingException {
        if (!this.opened) {
            throw new MessagingException("Folder is not Open");
        }
    }

    void checkReadable() throws MessagingException {
        if (!this.opened || this.mode != 1 && this.mode != 2) {
            throw new MessagingException("Folder is not Readable");
        }
    }

    void checkWritable() throws MessagingException {
        if (!this.opened || this.mode != 2) {
            throw new MessagingException("Folder is not Writable");
        }
    }

    public synchronized void close(boolean expunge) throws MessagingException {
        this.checkOpen();
        try {
            if (this.mode == 2) {
                try {
                    this.writeFolder(true, expunge);
                }
                catch (IOException e) {
                    throw new MessagingException("I/O Exception", (Exception)e);
                }
            }
            this.message_cache = null;
        }
        finally {
            Object var3_5 = null;
            this.opened = false;
            if (this.is_inbox && this.folder instanceof InboxFile) {
                InboxFile inf = (InboxFile)this.folder;
                inf.closeLock();
            }
            this.notifyConnectionListeners(3);
        }
    }

    private int contentLength(InternetHeaders hdrs) {
        int len = -1;
        String[] cl = hdrs.getHeader("Content-Length");
        try {
            if (cl != null && cl[0] != null) {
                len = Integer.parseInt(cl[0]);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return len;
    }

    public synchronized boolean create(int type) throws MessagingException {
        switch (type) {
            case 2: {
                if (new File(this.folder.getPath(), this.name).mkdirs()) break;
                return false;
            }
            case 1: {
                if (this.folder.exists()) {
                    return false;
                }
                try {
                    new FileOutputStream((File)((Object)this.folder)).close();
                    break;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    File parent = new File(this.folder.getParent());
                    if (!parent.mkdirs()) {
                        throw new MessagingException("can't create folder: " + this.name);
                    }
                    try {
                        new FileOutputStream((File)((Object)this.folder)).close();
                        break;
                    }
                    catch (IOException ex3) {
                        throw new MessagingException("can't create folder: " + this.name, (Exception)ex3);
                    }
                }
                catch (IOException e) {
                    throw new MessagingException("can't create folder: " + this.name, (Exception)e);
                }
            }
            default: {
                throw new MessagingException("type not supported");
            }
        }
        this.notifyFolderListeners(1);
        return true;
    }

    protected Folder createFolder(MboxStore store, String name) {
        return new MboxFolder(store, name);
    }

    public synchronized boolean delete(boolean recurse) throws MessagingException {
        this.checkClosed();
        if (this.name == null) {
            throw new MessagingException("can't delete default folder");
        }
        if (this.folder.delete()) {
            this.notifyFolderListeners(2);
            return true;
        }
        return false;
    }

    public boolean exists() {
        return this.folder.exists();
    }

    public synchronized Message[] expunge() throws MessagingException {
        this.checkWritable();
        int wr = this.total;
        try {
            wr = this.writeFolder(false, true);
        }
        catch (IOException e) {
            throw new MessagingException("expunge failed", (Exception)e);
        }
        if (wr == 0) {
            return new Message[0];
        }
        int del = 0;
        Message[] msglist = new Message[this.total - wr];
        int msgno = 1;
        while (msgno <= this.total) {
            MboxMessage msg = (MboxMessage)((Object)this.message_cache.elementAt(msgno - 1));
            if (msg.isSet(Flags.Flag.DELETED)) {
                msglist[del] = msg;
                ++del;
                this.message_cache.removeElementAt(msgno - 1);
                --this.total;
                continue;
            }
            msg.setMessageNumber(msgno);
            ++msgno;
        }
        if (del != msglist.length) {
            throw new MessagingException("expunge delete count wrong");
        }
        this.notifyMessageRemovedListeners(true, msglist);
        return msglist;
    }

    public synchronized Folder getFolder(String name) throws MessagingException {
        if (this.folder.exists() && !this.folder.isDirectory()) {
            throw new MessagingException("not a directory");
        }
        Folder f = this.name != null ? this.createFolder(this.mstore, String.valueOf(this.name) + File.separator + name) : this.createFolder(this.mstore, name);
        return f;
    }

    public String getFullName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public synchronized Message getMessage(int msgno) throws MessagingException {
        this.checkReadable();
        MboxMessage m = null;
        if (msgno <= this.total) {
            m = (MboxMessage)((Object)this.message_cache.elementAt(msgno - 1));
        }
        return m;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized int getMessageCount() throws MessagingException {
        this.checkReadable();
        boolean locked = false;
        Message[] msglist = null;
        try {
            try {
                if (this.folder.length() != this.file_size) {
                    if (!this.folder.lock("r")) {
                        throw new MessagingException("Failed to lock folder");
                    }
                    locked = true;
                    msglist = this.load(this.file_size, true);
                }
            }
            catch (IOException e) {
                throw new MessagingException("I/O Exception", (Exception)e);
            }
            Object var4_4 = null;
            if (!locked) return this.total;
            this.folder.unlock();
            if (msglist == null) return this.total;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!locked) throw throwable;
            this.folder.unlock();
            if (msglist == null) throw throwable;
            this.notifyMessageAddedListeners(msglist);
            throw throwable;
        }
        this.notifyMessageAddedListeners(msglist);
        return this.total;
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        if (this.is_inbox) {
            return "INBOX";
        }
        return this.folder.getName();
    }

    public Folder getParent() {
        if (this.name == null) {
            return null;
        }
        if (this.is_inbox) {
            return this.createFolder(this.mstore, null);
        }
        return this.createFolder(this.mstore, this.folder.getParent());
    }

    public Flags getPermanentFlags() {
        return MboxStore.permFlags;
    }

    public char getSeparator() {
        return File.separatorChar;
    }

    public int getType() {
        if (this.folder.isDirectory()) {
            return 2;
        }
        return 1;
    }

    public URLName getURLName() {
        URLName storeURL = this.getStore().getURLName();
        if (this.name == null) {
            return storeURL;
        }
        char separator = this.getSeparator();
        String fullname = this.getFullName();
        StringBuffer encodedName = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(fullname, new Character(separator).toString(), true);
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if (s.charAt(0) == separator) {
                encodedName.append("/");
                continue;
            }
            encodedName.append(s);
        }
        return new URLName(storeURL.getProtocol(), storeURL.getHost(), storeURL.getPort(), encodedName.toString(), storeURL.getUsername(), null);
    }

    protected static String getUnixFrom(MimeMessage msg) {
        Date ddate;
        String from;
        try {
            Address[] afrom = msg.getFrom();
            if (afrom == null || !(afrom[0] instanceof InternetAddress) || (from = ((InternetAddress)afrom[0]).getAddress()) == null) {
                from = "UNKNOWN";
            }
            if ((ddate = msg.getReceivedDate()) == null || (ddate = msg.getSentDate()) == null) {
                ddate = new Date();
            }
        }
        catch (MessagingException messagingException) {
            from = "UNKNOWN";
            ddate = new Date();
        }
        String date = ddate.toString();
        return "From " + from + " " + date.substring(0, 20) + date.substring(24);
    }

    public synchronized boolean hasNewMessages() {
        long current_size = this.folder.exists() ? this.folder.length() : -1L;
        if (this.saved_file_size < 0L) {
            this.saved_file_size = current_size;
        }
        return current_size > this.saved_file_size;
    }

    private static int indexOfAny(String s, String any) {
        try {
            int len = s.length();
            int i = 0;
            while (i < len) {
                if (any.indexOf(s.charAt(i)) >= 0) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return -1;
        }
    }

    public boolean isOpen() {
        return this.opened;
    }

    public Folder[] list(String pattern) throws MessagingException {
        if (!this.folder.isDirectory()) {
            throw new MessagingException("not a directory");
        }
        if (this.name == null) {
            return this.list(null, pattern, true);
        }
        return this.list(String.valueOf(this.name) + File.separator, pattern, false);
    }

    protected Folder[] list(String ref, String pattern, boolean fromStore) throws MessagingException {
        if (ref != null && ref.length() == 0) {
            ref = null;
        }
        String refdir = null;
        String realdir = null;
        int i = MboxFolder.indexOfAny(pattern = MboxFolder.canonicalize(ref, pattern), "%*");
        refdir = i >= 0 ? pattern.substring(0, i) : pattern;
        i = refdir.lastIndexOf(File.separatorChar);
        if (i >= 0) {
            refdir = refdir.substring(0, i + 1);
            realdir = this.mstore.mb.filename(this.mstore.user, refdir);
        } else if (refdir.length() == 0 || refdir.charAt(0) != '~') {
            refdir = null;
            realdir = this.mstore.home;
        } else {
            realdir = this.mstore.mb.filename(this.mstore.user, refdir);
        }
        Vector<String> flist = new Vector<String>();
        this.listWork(realdir, refdir, pattern, fromStore ? 0 : 1, flist);
        if (match.path("INBOX", pattern, '\u0000')) {
            flist.addElement("INBOX");
        }
        Folder[] fl = new Folder[flist.size()];
        i = 0;
        while (i < fl.length) {
            fl[i] = this.createFolder(this.mstore, (String)flist.elementAt(i));
            ++i;
        }
        return fl;
    }

    private void listWork(String realdir, String dir, String pat, int level, Vector flist) {
        String[] sl;
        File fdir = new File(realdir);
        try {
            sl = fdir.list();
        }
        catch (SecurityException securityException) {
            return;
        }
        if (level == 0 && dir != null && match.path(dir, pat, File.separatorChar)) {
            flist.addElement(dir);
        }
        if (sl == null) {
            return;
        }
        if (realdir.charAt(realdir.length() - 1) != File.separatorChar) {
            realdir = String.valueOf(realdir) + File.separator;
        }
        int i = 0;
        while (i < sl.length) {
            String md;
            File mf;
            if (sl[i].charAt(0) != '.' && (mf = new File(md = String.valueOf(realdir) + sl[i])).exists()) {
                String name = dir != null ? String.valueOf(dir) + sl[i] : sl[i];
                if (mf.isDirectory()) {
                    if (match.path(name, pat, File.separatorChar)) {
                        flist.addElement(name);
                        name = String.valueOf(name) + File.separator;
                    } else if (match.path(name = String.valueOf(name) + File.separator, pat, File.separatorChar)) {
                        flist.addElement(name);
                    }
                    if (match.dir(name, pat, File.separatorChar)) {
                        this.listWork(md, name, pat, level + 1, flist);
                    }
                } else if (match.path(name, pat, File.separatorChar)) {
                    flist.addElement(name);
                }
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private Message[] load(long offset, boolean notify) throws MessagingException, IOException {
        block6: {
            oldtotal = this.total;
            try {
                first = offset == 0L;
                in = new BufferedInputStream(new FileInputStream(this.folder.getFD()));
                in.skip(offset);
                while (true) {
                    msg = this.loadMessage(in, this.total, this.mode == 2);
                    if (first) {
                        first = false;
                        if (msg.getHeader("X-IMAP") != null) {
                            this.special_imap_message = msg;
                            continue;
                        }
                    }
                    ++this.total;
                    msg.setMessageNumber(this.total);
                    this.message_cache.addElement(msg);
                }
            }
            catch (EOFException v0) {
                this.file_size = this.folder.length();
                if (!notify) break block6;
                msglist = new Message[this.total - oldtotal];
                i = oldtotal;
                j = 0;
                ** while (i < this.total)
            }
lbl-1000:
            // 1 sources

            {
                msglist[j] = (Message)this.message_cache.elementAt(i);
                ++i;
                ++j;
                continue;
            }
lbl29:
            // 1 sources

            return msglist;
        }
        return null;
    }

    private MboxMessage loadMessage(BufferedInputStream is, int msgno, boolean writable) throws MessagingException, IOException {
        String line;
        DataInputStream in = new DataInputStream(is);
        String unix_from = null;
        while ((line = in.readLine()) != null) {
            if (line.trim().length() == 0) continue;
            if (line.startsWith("From ")) {
                unix_from = line;
                int i = unix_from.indexOf(32, 5);
                if (i >= 0) break;
                continue;
            }
            throw new MessagingException("Garbage in mailbox: " + line);
        }
        if (unix_from == null) {
            throw new EOFException("end of mailbox");
        }
        InternetHeaders hdrs = new InternetHeaders((InputStream)is);
        byte[] content = null;
        try {
            int len = this.contentLength(hdrs);
            if (len >= 0) {
                content = new byte[len];
                in.readFully(content);
            } else {
                int b;
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                while ((b = is.read()) >= 0) {
                    if (b == 13 || b == 10) {
                        is.mark(6);
                        if (b == 13 && is.read() != 10) {
                            is.reset();
                            is.mark(5);
                        }
                        if (is.read() == 70 && is.read() == 114 && is.read() == 111 && is.read() == 109 && is.read() == 32) {
                            is.reset();
                            break;
                        }
                        is.reset();
                    }
                    buf.write(b);
                }
                content = buf.toByteArray();
            }
        }
        catch (EOFException eOFException) {}
        return new MboxMessage(this, hdrs, content, msgno, unix_from, writable);
    }

    protected void notifyMessageChangedListeners(int type, Message m) {
        super.notifyMessageChangedListeners(type, m);
    }

    public synchronized void open(int mode) throws MessagingException {
        InboxFile inf;
        if (this.opened) {
            throw new MessagingException("Folder is already Open");
        }
        this.mode = mode;
        switch (mode) {
            default: {
                if (this.folder.canWrite()) break;
                throw new MessagingException("Open Failure, can't write");
            }
            case 1: 
        }
        if (!this.folder.canRead()) {
            throw new MessagingException("Open Failure, can't read");
        }
        if (this.is_inbox && this.folder instanceof InboxFile && !(inf = (InboxFile)this.folder).openLock(mode == 2 ? "rw" : "r")) {
            throw new MessagingException("Failed to lock INBOX");
        }
        if (!this.folder.lock("r")) {
            throw new MessagingException("Failed to lock folder");
        }
        this.message_cache = new Vector();
        this.total = 0;
        Message[] msglist = null;
        try {
            try {
                this.saved_file_size = this.folder.length();
                msglist = this.load(0L, false);
            }
            catch (IOException e) {
                throw new MessagingException("IOException", (Exception)e);
            }
            Object var4_4 = null;
            this.folder.unlock();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.folder.unlock();
            throw throwable;
        }
        this.notifyConnectionListeners(1);
        if (msglist != null) {
            this.notifyMessageAddedListeners(msglist);
        }
        this.opened = true;
    }

    public synchronized boolean renameTo(Folder f) throws MessagingException {
        this.checkClosed();
        if (this.name == null) {
            throw new MessagingException("can't rename default folder");
        }
        if (!(f instanceof MboxFolder)) {
            throw new MessagingException("can't rename to: " + f.getName());
        }
        String oldname = this.folder.getPath();
        String newname = ((MboxFolder)f).folder.getPath();
        if (this.folder.renameTo(new File(this.folder.getPath(), newname))) {
            this.notifyFolderRenamedListeners(f);
            return true;
        }
        return false;
    }

    protected int writeFolder(boolean closing, boolean expunge) throws IOException, MessagingException {
        int modified = 0;
        int deleted = 0;
        int recent = 0;
        int msgno = 1;
        while (msgno <= this.total) {
            MboxMessage msg = (MboxMessage)((Object)this.message_cache.elementAt(msgno - 1));
            Flags flags = msg.getFlags();
            if (msg.modified || !msg.origFlags.equals((Object)flags)) {
                ++modified;
            }
            if (flags.contains(Flags.Flag.DELETED)) {
                ++deleted;
            }
            if (flags.contains(Flags.Flag.RECENT)) {
                ++recent;
            }
            ++msgno;
        }
        if (!(closing && recent != 0 || expunge && deleted != 0 || modified != 0)) {
            return 0;
        }
        if (!this.folder.lock("rw")) {
            throw new MessagingException("Failed to lock folder");
        }
        int oldtotal = this.total;
        Message[] msglist = null;
        if (this.folder.length() != this.file_size) {
            msglist = this.load(this.file_size, closing ^ true);
        }
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream((File)((Object)this.folder)));
        int wr = 0;
        boolean keep = true;
        try {
            try {
                String skeep;
                if (this.special_imap_message != null) {
                    MboxFolder.writeMboxMessage(this.special_imap_message, os);
                }
                int msgno2 = 1;
                while (msgno2 <= this.total) {
                    MboxMessage msg = (MboxMessage)((Object)this.message_cache.elementAt(msgno2 - 1));
                    if (!expunge || !msg.isSet(Flags.Flag.DELETED)) {
                        if (closing && msgno2 <= oldtotal && msg.isSet(Flags.Flag.RECENT)) {
                            msg.setFlag(Flags.Flag.RECENT, false);
                        }
                        MboxFolder.writeMboxMessage(msg, os);
                        this.folder.touchlock();
                        ++wr;
                    }
                    ++msgno2;
                }
                this.file_size = this.saved_file_size = this.folder.length();
                if (wr == 0 && closing && (skeep = ((MboxStore)this.store).getSession().getProperty("mail.mbox.deleteEmpty")) != null && skeep.equalsIgnoreCase("true")) {
                    keep = false;
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (MessagingException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new MessagingException("unexpected exception " + e);
            }
            Object var13_20 = null;
        }
        catch (Throwable throwable) {
            Object var13_21 = null;
            try {
                ((OutputStream)os).close();
                if (!keep) {
                    this.folder.delete();
                    this.file_size = 0L;
                }
            }
            catch (IOException iOException) {}
            if (keep) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                FileInputStream is = null;
                try {
                    is = new FileInputStream((File)((Object)this.folder));
                    ((InputStream)is).read();
                }
                catch (IOException iOException) {}
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                    is = null;
                }
                catch (IOException iOException) {}
            }
            this.folder.unlock();
            if (msglist != null) {
                this.notifyMessageAddedListeners(msglist);
            }
            throw throwable;
        }
        try {
            ((OutputStream)os).close();
            if (!keep) {
                this.folder.delete();
                this.file_size = 0L;
            }
        }
        catch (IOException iOException) {}
        if (keep) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            FileInputStream is = null;
            try {
                is = new FileInputStream((File)((Object)this.folder));
                ((InputStream)is).read();
            }
            catch (IOException iOException) {}
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
                is = null;
            }
            catch (IOException iOException) {}
        }
        this.folder.unlock();
        if (msglist != null) {
            this.notifyMessageAddedListeners(msglist);
        }
        return wr;
    }

    public static void writeMboxMessage(MimeMessage msg, OutputStream os) throws IOException, MessagingException {
        try {
            if (msg instanceof MboxMessage) {
                ((MboxMessage)msg).writeToFile(os);
            } else {
                ContentLengthCounter cos = new ContentLengthCounter();
                NewlineOutputStream nos = new NewlineOutputStream(cos);
                msg.writeTo((OutputStream)nos);
                nos.flush();
                os = new NewlineOutputStream(os);
                os = new ContentLengthUpdater(os, cos.getSize());
                PrintStream pos = new PrintStream(os);
                pos.println(MboxFolder.getUnixFrom(msg));
                msg.writeTo((OutputStream)pos);
                pos.println();
                pos.flush();
            }
        }
        catch (MessagingException me) {
            throw me;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception exception) {}
    }
}

