/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Registry;

import com.sun.pdasync.Logger.Logger;
import com.sun.pdasync.Registry.ConduitRegInfo;
import com.sun.pdasync.Registry.Registry;
import com.sun.pdasync.SyncUtils.SyncUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ConduitInstall {
    private static Locale theLocale;
    private static ResourceBundle regRes;
    public static final int SYSTEM = 1;
    public static final int PERSONAL = 2;
    private static final String SYSTEM_STR = "system";
    private static final String PERSONAL_STR = "personal";
    private static final String OPEN_METHOD = "open";
    private static final String NAME_METHOD = "name";
    private static final String CONFIGURE_METHOD = "configure";
    private static final String OPEN_PARM = "palm.conduit.SyncProperties";
    private static final String CONFIGURE_PARM = "palm.conduit.ConfigureConduitInfo";
    private static final String REGISTYPE = "-registry";
    private static final String CREATOR = "-creator";
    private static final String REMOTE = "-remote";
    private static final String CLASSNAME = "-classname";
    private static final String CLASSPATH = "-classpath";
    private static final String DIRECTORY = "-directory";
    private static final String DATAFILE = "-file0";
    private static final String CONDNAME = "-name";
    private static final String PRIORITY = "-priority";

    static {
        try {
            theLocale = Locale.getDefault();
            regRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.RegistryMsgs", theLocale);
        }
        catch (MissingResourceException e) {
            Logger.doLogging((String)"ConduitInstall: can't find properties");
            Logger.doLogging((String)("ConduitInstall:" + e.getMessage()));
        }
    }

    public static String getClassName(String fileName) {
        int index = fileName.indexOf(".class");
        if (index == -1) {
            return null;
        }
        StringBuffer sbuf = new StringBuffer(fileName);
        sbuf.setLength(index);
        int i = 0;
        while (i < sbuf.length()) {
            if (sbuf.charAt(i) == '/') {
                sbuf.setCharAt(i, '.');
            }
            ++i;
        }
        return sbuf.toString();
    }

    public static boolean isNewConduit(String className) {
        File stateFile = new File(Registry.CONDUIT_STATE);
        if (stateFile.exists()) {
            if (!stateFile.isFile()) {
                return true;
            }
            Vector<String> conduits = new Vector<String>();
            try {
                String line;
                FileReader reader = new FileReader(stateFile);
                BufferedReader rBuffer = new BufferedReader(reader);
                while ((line = rBuffer.readLine()) != null) {
                    StringTokenizer strTok = new StringTokenizer(line, "|");
                    if (strTok.hasMoreTokens()) {
                        conduits.addElement(strTok.nextToken());
                        continue;
                    }
                    return true;
                }
                rBuffer.close();
            }
            catch (IOException iOException) {
                return true;
            }
            int i = 0;
            while (i < conduits.size()) {
                String cname = (String)conduits.elementAt(i);
                if (cname.equals(className)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        boolean ret;
        int registryType = -1;
        int creatorID = -1;
        String remoteDBName = null;
        String className = null;
        String classPath = null;
        String dataDir = null;
        String dataFile = null;
        String conduitName = null;
        int priority = -1;
        String jarFile = null;
        if (args.length < 7) {
            ConduitInstall.printUsage();
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].indexOf(45) != -1) {
                if (args[i].equals(REGISTYPE)) {
                    if (args[i + 1].equals(SYSTEM_STR)) {
                        registryType = 1;
                    } else if (args[i + 1].equals(PERSONAL_STR)) {
                        registryType = 2;
                    } else {
                        ConduitInstall.printUsage();
                    }
                } else if (args[i].equals(CREATOR)) {
                    try {
                        creatorID = Integer.parseInt(args[i + 1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        ConduitInstall.printUsage();
                    }
                } else if (args[i].equals(REMOTE)) {
                    remoteDBName = args[i + 1];
                } else if (args[i].equals(CLASSNAME)) {
                    className = args[i + 1];
                } else if (args[i].equals(CLASSPATH)) {
                    classPath = args[i + 1];
                } else if (args[i].equals(DIRECTORY)) {
                    dataDir = args[i + 1];
                } else if (args[i].equals(DATAFILE)) {
                    dataFile = args[i + 1];
                } else if (args[i].equals(CONDNAME)) {
                    conduitName = args[i + 1];
                } else if (args[i].equals(PRIORITY)) {
                    try {
                        priority = Integer.parseInt(args[i + 1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        ConduitInstall.printUsage();
                    }
                } else {
                    ConduitInstall.printUsage();
                }
                i += 2;
                continue;
            }
            if (i == args.length - 1) {
                jarFile = args[i];
                ++i;
                continue;
            }
            ConduitInstall.printUsage();
        }
        if (creatorID == -1 || remoteDBName == null || className == null || jarFile == null) {
            ConduitInstall.printUsage();
        }
        if (!(ret = ConduitInstall.registerConduit(registryType, creatorID, remoteDBName, className, classPath, conduitName, dataDir, dataFile, priority, jarFile))) {
            System.out.println(regRes.getString("Cannot install this conduit, check permission/duplicates."));
        } else {
            System.out.println(regRes.getString("Conduit has been successfully installed."));
        }
    }

    static final void printUsage() {
        System.out.println("Usage: java ConduitInstall [-registry [system|personal]] -creator creator_id -remote remote_db_name -classname class_name [-classpath class_path] [-directory data_directory] [-file0 conduit_data_file] [-name conduit_name] [-priority priority_number] conduit.jar");
        System.exit(0);
    }

    public static boolean registerConduit(int registryType, int creatorID, String remoteDBName, String className, String classPath, String conduitName, String jarFile) {
        return ConduitInstall.registerConduit(registryType, creatorID, remoteDBName, className, classPath, conduitName, null, null, -1, jarFile);
    }

    public static boolean registerConduit(int registryType, int creatorID, String remoteDBName, String className, String classPath, String conduitName, String dataDir, String dataFile, int priority, String jarFile) {
        boolean ret;
        Registry regis;
        if (creatorID == -1 || remoteDBName == null || className == null || jarFile == null) {
            return false;
        }
        if (registryType == -1) {
            registryType = 2;
        }
        if (classPath == null) {
            File cf = new File(jarFile);
            classPath = cf.getAbsolutePath();
        }
        if (dataDir == null) {
            dataDir = className;
        }
        if (conduitName == null) {
            String[] tmpStrs = new String[2];
            if (ConduitInstall.verifyConduit(jarFile, tmpStrs)) {
                conduitName = tmpStrs[1];
            } else {
                return false;
            }
        }
        if (dataFile == null) {
            dataFile = String.valueOf(className) + ".dat";
        }
        ConduitRegInfo conduit = new ConduitRegInfo();
        conduit.setCreatorID(creatorID);
        conduit.setRemote0(remoteDBName);
        conduit.setClassName(className);
        conduit.setClassPath(classPath);
        conduit.setName(conduitName);
        conduit.setDirectory(dataDir);
        if (dataFile != null) {
            conduit.setFile0(dataFile);
        }
        conduit.setPriority(priority);
        conduit.setConduit(SyncUtils.getFileShortName((String)jarFile));
        conduit.setDefaultActiveFlag(false);
        if (registryType == 1) {
            regis = new Registry(Registry.SYSTEM_CONDUITS);
            ret = regis.addConduitToSystemRegistry(conduit);
        } else {
            regis = new Registry(Registry.PERSONAL_CONDUITS);
            ret = regis.addConduitToPersonalRegistry(conduit);
        }
        return ret;
    }

    public static boolean verifyConduit(String condFileName, String[] nameArray) {
        String className = null;
        String conduitName = null;
        ZipFile jarFile = null;
        try {
            File cf = new File(condFileName);
            jarFile = new ZipFile(cf.getAbsolutePath());
            Enumeration<? extends ZipEntry> entries = jarFile.entries();
            Method nameMethod = null;
            Class[] openParm = new Class[1];
            try {
                openParm[0] = Class.forName(OPEN_PARM);
            }
            catch (Exception exception) {
                System.out.println("no OPEN_PARM");
            }
            Class[] configureParm = new Class[]{Class.forName(CONFIGURE_PARM)};
            boolean found = false;
            while (entries.hasMoreElements()) {
                String name;
                ZipEntry zipEntry = entries.nextElement();
                if (zipEntry.isDirectory() || (name = ConduitInstall.getClassName(zipEntry.getName())) == null) continue;
                try {
                    Class<?> entryClass = Class.forName(name);
                    try {
                        entryClass.getMethod(OPEN_METHOD, openParm);
                        nameMethod = entryClass.getMethod(NAME_METHOD, null);
                        entryClass.getMethod(CONFIGURE_METHOD, configureParm);
                        found = true;
                    }
                    catch (Exception exception) {}
                    if (!found) continue;
                    className = name;
                    if (nameMethod != null) {
                        try {
                            conduitName = (String)nameMethod.invoke(entryClass.newInstance(), null);
                        }
                        catch (Exception exception) {}
                    }
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        catch (Exception exception) {
            return false;
        }
        if (className != null) {
            nameArray[0] = SyncUtils.getClassShortName(className);
            nameArray[1] = conduitName;
            return true;
        }
        return false;
    }
}

