/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.Installer;

import com.sun.pdasync.SharedUI.CommandPane;
import com.sun.pdasync.SharedUI.PDASyncHelp;
import com.sun.pdasync.SharedUI.SyncIcons;
import com.sun.pdasync.SyncUtils.SyncConstants;
import com.sun.pdasync.SyncUtils.SyncUtils;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.filechooser.FileFilter;

public class InstallerPropsUI
extends JDialog {
    private static Locale theLocale;
    private static ResourceBundle installerRes;
    private static ResourceBundle installerTips;
    private static ResourceBundle commonRes;
    private static ResourceBundle commonTips;
    public JOptionPane installOptions;
    protected JList installList;
    protected DefaultListModel listModel;
    protected JButton addButton;
    protected JButton removeButton;
    protected JButton closeBtn;
    protected JButton helpBtn;
    protected JFrame winParent;
    protected JFileChooser addAppFileChooser;
    protected File addAppPath;
    protected File installDir;

    static {
        try {
            theLocale = Locale.getDefault();
            installerRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.InstallerPropsUIMessages", theLocale);
            installerTips = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.InstallerPropsUITips", theLocale);
            commonRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.CommonUIMessages", theLocale);
            commonTips = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.CommonTips", theLocale);
        }
        catch (MissingResourceException e) {
            System.err.println("PDASync: can't find properties");
            System.err.println("PDASync:" + e.getMessage());
            System.exit(1);
        }
    }

    public InstallerPropsUI(JFrame parent) {
        super(parent, installerRes.getString("Configure Installer Conduit"), true);
        this.winParent = parent;
        this.installDir = new File(SyncConstants.INSTALL_DIR_PATH);
        if (!this.installDir.exists()) {
            this.installDir.mkdir();
        }
        this.addAppPath = new File(SyncConstants.HOME_DIR);
        this.addAppFileChooser = new JFileChooser(this.addAppPath);
        this.addAppFileChooser.setDialogTitle(installerRes.getString("Add PalmPilot Applications"));
        this.addAppFileChooser.setFileFilter(new PilotAppFilter());
        int btnCnt = 0;
        this.installOptions = new JOptionPane();
        JPanel insP = new JPanel(){

            public Insets getInsets() {
                return new Insets(10, 0, 0, 10);
            }
        };
        insP.setLayout(new GridBagLayout());
        JLabel installLabel = new JLabel(installerRes.getString("PalmPilot applications to install:"));
        ButtonsListener cbl = new ButtonsListener();
        this.addButton = new JButton(SyncIcons.PLUS);
        this.addButton.setToolTipText(installerTips.getString("Add to List"));
        this.addButton.setActionCommand("AddItem");
        this.addButton.addActionListener(cbl);
        this.addButton.setMargin(new Insets(-1, -1, -1, -1));
        this.removeButton = new JButton(SyncIcons.MINUS);
        this.removeButton.setToolTipText(installerTips.getString("Remove"));
        this.removeButton.setActionCommand("RemoveItem");
        this.removeButton.addActionListener(cbl);
        this.removeButton.setMargin(new Insets(-1, -1, -1, -1));
        this.listModel = new DefaultListModel();
        this.installList = new JList(this.listModel);
        this.installList.setSelectionMode(0);
        JScrollPane installScrollPane = new JScrollPane(this.installList);
        installScrollPane.setVerticalScrollBarPolicy(22);
        installScrollPane.setPreferredSize(new Dimension(310, 120));
        this.setList();
        int gbcGridy = 0;
        try {
            CommandPane.addComponent((Container)insP, (Component)installLabel, (int)0, (int)gbcGridy, (int)1, (int)1, (int)0, (int)17, (Insets)new Insets(0, 0, 5, 0));
        }
        catch (AWTException aWTException) {}
        try {
            CommandPane.addComponent((Container)insP, (Component)this.addButton, (int)1, (int)gbcGridy, (int)1, (int)1, (int)0, (int)13, (Insets)new Insets(0, 25, 5, 0));
        }
        catch (AWTException aWTException) {}
        try {
            CommandPane.addComponent((Container)insP, (Component)this.removeButton, (int)2, (int)gbcGridy, (int)1, (int)1, (int)0, (int)13, (Insets)new Insets(0, 5, 5, 0));
        }
        catch (AWTException aWTException) {}
        ++gbcGridy;
        try {
            CommandPane.addComponent((Container)insP, (Component)installScrollPane, (int)0, (int)gbcGridy, (int)0, (int)1, (int)1, (int)17, null);
        }
        catch (AWTException aWTException) {}
        ++gbcGridy;
        try {
            CommandPane.addComponent((Container)insP, (Component)new JSeparator(), (int)0, (int)gbcGridy, (int)0, (int)1, (int)1, (int)10, (Insets)new Insets(10, 0, 0, 0));
        }
        catch (AWTException aWTException) {}
        this.closeBtn = new JButton(commonRes.getString("Close"));
        this.closeBtn.setMargin(new Insets(4, 4, 4, 4));
        this.closeBtn.setToolTipText(commonTips.getString("Dismiss dialog."));
        ++btnCnt;
        this.helpBtn = new JButton(SyncIcons.HELP);
        this.helpBtn.setMargin(new Insets(-1, -1, -1, -1));
        this.helpBtn.setToolTipText(commonTips.getString("Display help."));
        ++btnCnt;
        this.closeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ((Component)InstallerPropsUI.this).setVisible(false);
            }
        });
        HelpBroker helpBroker = null;
        helpBroker = PDASyncHelp.enableContextHelp((Component)this.helpBtn, (String)"pda_installerConfig");
        if (helpBroker == null) {
            this.helpBtn.setEnabled(false);
        } else {
            this.helpBtn.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(helpBroker));
        }
        this.installOptions.setMessage(insP);
        this.installOptions.setMessageType(-1);
        Object[] buttons = new Object[btnCnt];
        buttons[0] = this.closeBtn;
        buttons[1] = this.helpBtn;
        this.installOptions.setOptions(buttons);
        this.installOptions.setOptionType(-1);
        this.installOptions.setInitialValue(this.closeBtn);
        this.installOptions.validate();
        this.setContentPane(this.installOptions);
        this.validate();
        this.pack();
    }

    private void addItemToList(String itemToAdd) {
        int size = this.listModel.getSize();
        if (size == 0) {
            this.listModel.addElement(itemToAdd);
            this.installList.setSelectedIndex(0);
            this.removeButton.setEnabled(true);
        } else {
            int index = 0;
            while (index < size) {
                String itemInList = this.listModel.getElementAt(index).toString();
                int retValue = itemInList.compareTo(itemToAdd);
                if (retValue > 0) break;
                ++index;
            }
            if (index == size) {
                this.listModel.addElement(itemToAdd);
            } else {
                this.listModel.insertElementAt(itemToAdd, index);
            }
            this.installList.setSelectedIndex(index);
        }
        size = this.listModel.getSize();
    }

    public void copy(File fromFile) throws IOException {
        FileOutputStream to;
        boolean updateList;
        block16: {
            updateList = true;
            File toFile = new File(this.installDir, fromFile.getName());
            String toFileName = toFile.getName();
            if (toFile.exists()) {
                updateList = false;
                toFile.delete();
            }
            FileInputStream from = null;
            to = null;
            try {
                try {
                    int bytesRead;
                    from = new FileInputStream(fromFile);
                    to = new FileOutputStream(toFile);
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = from.read(buffer)) != -1) {
                        to.write(buffer, 0, bytesRead);
                    }
                }
                catch (IOException e) {
                    updateList = false;
                    System.err.println("Add App, can't copy:" + e.getMessage());
                }
                Object var8_10 = null;
                if (from == null) break block16;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (from != null) {
                    try {
                        from.close();
                    }
                    catch (IOException iOException) {}
                }
                if (to != null) {
                    try {
                        to.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                from.close();
            }
            catch (IOException iOException) {}
        }
        if (to != null) {
            try {
                to.close();
            }
            catch (IOException iOException) {}
        }
        if (updateList) {
            this.addItemToList(fromFile.getName());
        }
    }

    public String[] getInstallList() {
        int size = this.listModel.getSize();
        String[] itemsInList = null;
        if (size != 0) {
            itemsInList = new String[size];
            int i = 0;
            while (i < size) {
                itemsInList[i] = this.listModel.getElementAt(i).toString();
                ++i;
            }
        }
        return itemsInList;
    }

    public static void main(String[] args) {
        JFrame fr = new JFrame("Installer Test");
        WindowAdapter winEvents = new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }
        };
        fr.addWindowListener(winEvents);
        JButton show = new JButton("Show Dialog");
        JPanel pane = new JPanel();
        pane.add(show);
        pane.validate();
        fr.setContentPane(pane);
        fr.pack();
        InstallerPropsUI cprops = new InstallerPropsUI(fr);
        ActionListener showProps = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                InstallerPropsUI.this.show();
                InstallerPropsUI.this.setResizable(false);
            }
        };
        show.addActionListener(showProps);
        ((Component)fr).setVisible(true);
    }

    private void setList() {
        if (!this.installDir.isDirectory()) {
            return;
        }
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                String ext = SyncUtils.getExtension((String)name);
                return ext.equals("prc") || ext.equals("pdb");
            }
        };
        String[] fileNames = this.installDir.list(filter);
        if (fileNames.length > 0) {
            int i = 0;
            while (i < fileNames.length) {
                this.addItemToList(fileNames[i]);
                ++i;
            }
            this.installList.setSelectedIndex(0);
            this.removeButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
        }
    }

    public class PilotAppFilter
    extends FileFilter {
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = SyncUtils.getExtension((File)f);
            return extension != null && (extension.equals("prc") || extension.equals("pdb"));
        }

        public String getDescription() {
            return installerRes.getString("*.prc, *.pdb");
        }
    }

    private class ButtonsListener
    implements ActionListener {
        ButtonsListener() {
        }

        public void actionPerformed(ActionEvent ev) {
            if (ev.getActionCommand().equals("AddItem")) {
                int retVal = InstallerPropsUI.this.addAppFileChooser.showDialog(InstallerPropsUI.this.winParent, installerRes.getString("Add"));
                if (retVal == 0) {
                    String ext;
                    File file = InstallerPropsUI.this.addAppFileChooser.getSelectedFile();
                    if (file.exists() && ((ext = SyncUtils.getExtension((File)file)).equals("prc") || ext.equals("pdb"))) {
                        try {
                            InstallerPropsUI.this.copy(file);
                        }
                        catch (IOException e) {
                            System.out.println(e.getMessage());
                        }
                    }
                    InstallerPropsUI.this.addAppPath = InstallerPropsUI.this.addAppFileChooser.getCurrentDirectory();
                } else {
                    InstallerPropsUI.this.addAppFileChooser.setCurrentDirectory(InstallerPropsUI.this.addAppPath);
                }
            } else if (ev.getActionCommand().equals("RemoveItem")) {
                int index = InstallerPropsUI.this.installList.getSelectedIndex();
                String fileName = InstallerPropsUI.this.listModel.getElementAt(index).toString();
                File file = new File(SyncConstants.INSTALL_DIR_PATH, fileName);
                if (!file.exists() || !file.canRead() || file.isDirectory()) {
                    return;
                }
                file.delete();
                InstallerPropsUI.this.listModel.removeElementAt(index);
                int size = InstallerPropsUI.this.listModel.getSize();
                if (size == 0) {
                    InstallerPropsUI.this.removeButton.setEnabled(false);
                } else {
                    if (index == size) {
                        --index;
                    }
                    InstallerPropsUI.this.installList.setSelectedIndex(index);
                }
            }
        }
    }
}

