/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.Installer;

import palm.conduit.SyncException;

public class InstallerException
extends Exception {
    public SyncException syncErr;
    public int errorCode;
    public static final int NONE = 0;
    public static final int FIRST = 4096;
    public static final int NOT_OVERWRITE = 4097;
    public static final int BAD_FILE_HEADER = 4098;
    public static final int BAD_PATCH_VERSION = 4099;
    public static final int BAD_PATCH_FILES = 4100;
    public static final int ERR_DELETE_OLD_DB = 4101;
    public static final int ERR_CREATE_DB = 4102;
    public static final int ERR_READ_REC_HDR = 4103;
    public static final int ERR_READ_APPINFO = 4104;
    public static final int ERR_WRITE_APPINFO = 4105;
    public static final int ERR_READ_SORTINFO = 4106;
    public static final int ERR_WRITE_SORTINFO = 4107;
    public static final int BAD_REC_SIZE = 4108;
    public static final int BAD_DATA_RECORD = 4109;
    public static final int ERR_WRITE_DATAREC = 4110;
    public static final int BAD_RSC_RECORD = 4111;
    public static final int ERR_WRITE_RSCREC = 4112;
    static final int LAST = 4112;
    static final int NUM = 16;
    static final String[] details = new String[]{"None", "Cannot overwrite", "Bad file header", "Bad patch minor version", "Bad patch files", "Cannot delete old database", "Cannot create database", "Bad record headers", "Bad appInfo block", "Error creating remote appInfo block", "Bad sortInfo block", "Error creating remote sortInfo block", "Bad record size", "Bad data record", "Error creating data record", "Bad resource record", "Error creating resource record"};
    private String msg;

    public InstallerException() {
        this.msg = null;
        this.syncErr = null;
        this.errorCode = 0;
    }

    public InstallerException(int errorCode) {
        this.msg = null;
        this.syncErr = null;
        this.errorCode = errorCode;
    }

    public InstallerException(int errorCode, SyncException syncErr) {
        this.msg = null;
        this.syncErr = syncErr;
        this.errorCode = errorCode;
    }

    public InstallerException(String msg, int errorCode) {
        this.msg = msg;
        this.syncErr = null;
        this.errorCode = errorCode;
    }

    public InstallerException(String msg, int errorCode, SyncException syncErr) {
        this.msg = msg;
        this.syncErr = syncErr;
        this.errorCode = errorCode;
    }

    public String getMessage() {
        if (this.errorCode >= 4096 && this.errorCode <= 4112) {
            if (this.syncErr != null) {
                if (this.msg != null) {
                    return String.valueOf(details[this.errorCode - 4096]) + ": " + this.msg + "\n" + this.syncErr.getMessage();
                }
                return String.valueOf(details[this.errorCode - 4096]) + "\n" + this.syncErr.getMessage();
            }
            if (this.msg != null) {
                return String.valueOf(details[this.errorCode - 4096]) + ": " + this.msg;
            }
            return details[this.errorCode - 4096];
        }
        return "Unknown";
    }
}

