/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdasync.Conduits.Installer;

import com.sun.pdasync.Conduits.Installer.FileNameFilter;
import com.sun.pdasync.Conduits.Installer.InstallerException;
import com.sun.pdasync.Conduits.Installer.InstallerPropsUI;
import com.sun.pdasync.Conduits.Utils.DatabaseHdrType;
import com.sun.pdasync.Conduits.Utils.RecordEntryType;
import com.sun.pdasync.Conduits.Utils.RsrcEntryType;
import com.sun.pdasync.Logger.Logger;
import com.sun.pdasync.SyncMgr.CRawRecordInfo;
import com.sun.pdasync.SyncMgr.CSyncProperties;
import com.sun.pdasync.SyncMgr.SyncDefs;
import com.sun.pdasync.SyncUtils.SyncConstants;
import com.sun.pdasync.SyncUtils.SyncUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import palm.conduit.Conduit;
import palm.conduit.ConfigureConduitInfo;
import palm.conduit.Log;
import palm.conduit.SyncException;
import palm.conduit.SyncManager;
import palm.conduit.SyncProperties;
import palm.conduit.SystemInfo;

public class InstallerConduit
implements Conduit,
Serializable {
    public static final String FILE_EXTENSION_LIST = ".prc|.pdb|.PRC|.PDB";
    private static final String DB_C_GRAFFITI = "graf";
    private static final String DB_T_SYSPATCH = "ptch";
    private static final String DB_T_EXTENSION = "extn";
    private static final String DB_T_GRAFFITIMACROS = "macr";
    private static final String DB_T_APPLICATION = "appl";
    private static final int CARD_NO = 0;
    private static final int MAX_RECORD_SIZE = 65520;
    private static final int ROM_VER_2 = 2;
    private static final int ROM_VER_3 = 3;
    private static Locale theLocale;
    private static ResourceBundle installerRes;
    CSyncProperties syncProps;
    SystemInfo sysInfo;
    long fileSize;
    BufferedInputStream fileBuffer;
    DatabaseHdrType dbHeader;
    String dbName;
    int dbType;
    int dbHandle;
    int numRecords;
    int targetCardNo;
    boolean resetFlag;
    private Vector recordP = new Vector();
    private String localFileName;
    private String fileExtensionList;
    private InstallerPropsUI installerPropsUI;

    static {
        try {
            theLocale = Locale.getDefault();
            installerRes = ResourceBundle.getBundle("com.sun.pdasync.ListResourceBundle.InstallerConduitMessages", theLocale);
        }
        catch (MissingResourceException e) {
            System.err.println("PDASync: can't find properties");
            System.err.println("PDASync:" + e.getMessage());
        }
    }

    private void cleanUp(int dbHandle, String dbName, BufferedInputStream fileIS) {
        block8: {
            if (dbHandle > 0) {
                try {
                    SyncManager.closeDB((int)dbHandle);
                }
                catch (IOException iOException) {}
            }
            if (dbName != null) {
                try {
                    SyncManager.deleteDB((String)dbName, (int)this.targetCardNo);
                }
                catch (IOException iOException) {}
            }
            if (fileIS == null) break block8;
            try {
                fileIS.close();
            }
            catch (IOException iOException) {}
        }
    }

    public int configure(ConfigureConduitInfo info) {
        if (this.installerPropsUI == null) {
            this.installerPropsUI = new InstallerPropsUI(SyncUtils.getParentOfAllConduits());
        }
        this.installerPropsUI.show();
        return 0;
    }

    void createRemoteAppInfoBlock(int appInfoSize) throws InstallerException {
        int len = 0;
        boolean corruptFlag = false;
        byte[] appInfoBytes = new byte[appInfoSize];
        try {
            len = this.fileBuffer.read(appInfoBytes);
            if (len != appInfoSize) {
                corruptFlag = true;
            }
        }
        catch (IOException iOException) {
            corruptFlag = true;
        }
        if (corruptFlag) {
            this.doDebugLog("Error in reading AppInfoBlock");
            this.doDebugLog("Corrupted file. appInfoBlock: size asked = " + appInfoSize + ", size read = " + len);
            InstallerException s = new InstallerException(this.localFileName, 4104);
            throw s;
        }
        try {
            SyncManager.writeDBAppInfoBlock((int)this.dbHandle, (String)this.dbName, (byte[])appInfoBytes);
        }
        catch (SyncException e) {
            InstallerException s = new InstallerException(this.dbName, 4105, e);
            throw s;
        }
    }

    void createRemoteDB(byte[] nameBytes, int creator, int type, short flags, short version) throws InstallerException {
        String name;
        block4: {
            name = new String(nameBytes);
            try {
                SyncManager.deleteDB((String)name, (int)this.targetCardNo);
            }
            catch (SyncException e) {
                if (e.errorCode == 16387) break block4;
                InstallerException s = new InstallerException(name, 4101, e);
                throw s;
            }
        }
        try {
            this.dbHandle = SyncManager.createDB((int)creator, (int)flags, (int)this.targetCardNo, (String)name, (int)type);
            this.dbName = name;
        }
        catch (SyncException e) {
            InstallerException s = new InstallerException(name, 4102, e);
            throw s;
        }
    }

    void createRemoteSortInfoBlock(int sortInfoSize) throws InstallerException {
        int len = 0;
        boolean corruptFlag = false;
        byte[] sortInfoBytes = new byte[sortInfoSize];
        try {
            len = this.fileBuffer.read(sortInfoBytes);
            if (len != sortInfoSize) {
                corruptFlag = true;
            }
        }
        catch (IOException iOException) {
            corruptFlag = true;
        }
        if (corruptFlag) {
            this.doDebugLog("Error in reading SortInfoBlock");
            this.doDebugLog("Corrupted file. sortInfoBlock: size asked = " + sortInfoSize + ", size read = " + len);
            InstallerException s = new InstallerException(this.localFileName, 4106);
            throw s;
        }
        try {
            SyncManager.writeDBSortInfoBlock((int)this.dbHandle, (String)this.dbName, (byte[])sortInfoBytes);
        }
        catch (SyncException e) {
            InstallerException s = new InstallerException(this.dbName, 4107, e);
            throw s;
        }
    }

    void doDebugLog(String message) {
        Logger.doDebugLogging((String)message, (int)5, (boolean)true);
    }

    void doLog(String message) {
        Log.sunwAddEntry((String)(String.valueOf(installerRes.getString("Installer Conduit: ")) + message));
    }

    String getFileExtension(String fileName) {
        String fileExt = null;
        int indexOfDot = fileName.lastIndexOf(46);
        if (indexOfDot >= 0 && indexOfDot < fileName.length() - 1) {
            fileExt = fileName.substring(indexOfDot + 1);
        }
        return fileExt;
    }

    void initializeFileTypes() {
        this.fileExtensionList = FILE_EXTENSION_LIST;
    }

    boolean isInstallConduitType(String fileName) {
        String fileExtension = this.getFileExtension(fileName);
        if (fileExtension == null) {
            return false;
        }
        String fname = "." + fileExtension;
        fname.toLowerCase();
        return this.fileExtensionList.indexOf(fname) != -1;
    }

    boolean isValidDB() {
        boolean validFlag = true;
        if (this.dbHeader.creationDate_u == 0 || this.dbHeader.creator_u == 0 || this.dbHeader.name.length == 0 || this.dbHeader.name.length > 32 || (long)this.dbHeader.appInfoID_u > this.fileSize || (long)this.dbHeader.sortInfoID_u > this.fileSize) {
            validFlag = false;
        }
        return validFlag;
    }

    public String name() {
        return installerRes.getString("Installer");
    }

    public void open(CSyncProperties props) {
        String installDir;
        this.syncProps = props;
        this.targetCardNo = 0;
        String path = new String(this.syncProps.m_PathName);
        boolean deleteFile = (path = path.trim()).equals(installDir = SyncConstants.INSTALL_DIR_PATH);
        try {
            this.sysInfo = SyncManager.readSystemInfo();
            this.initializeFileTypes();
            if (props.m_FirstDevice == 2) {
                this.processPatches();
            }
            boolean bl = this.syncProps.m_SyncType == 7 || this.syncProps.m_FirstDevice == 2;
            this.doDebugLog("deleteFile = " + deleteFile);
            this.processFiles(path, deleteFile, false);
            if (this.resetFlag) {
                SyncManager.rebootSystem();
            }
            return;
        }
        catch (SyncException s) {
            if (s.errorCode == 16403 || s.errorCode == 16404) {
                this.doLog(installerRes.getString("Remote Device Full"));
            } else {
                String errMsg = String.valueOf(installerRes.getString("Error: ")) + s.getMessage();
                this.doLog(errMsg);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void open(SyncProperties props) {
        CSyncProperties temp = new CSyncProperties();
        props.copyToCSyncProperties(temp);
        this.open(temp);
    }

    void processDBHeader() throws InstallerException {
        int appInfoSize = 0;
        int sortInfoSize = 0;
        this.dbHeader = null;
        this.dbHeader = new DatabaseHdrType();
        try {
            this.dbHeader.readData(this.fileBuffer);
        }
        catch (IOException iOException) {
            InstallerException s = new InstallerException(this.localFileName, 4098);
            throw s;
        }
        String macroName = new String(this.dbHeader.name);
        boolean exist = false;
        int i = 0;
        while (i < this.syncProps.m_RemoteCount) {
            String remoteName = new String(this.syncProps.m_RemoteDbList[i].m_Name);
            if (macroName.equals(remoteName)) {
                exist = true;
                break;
            }
            ++i;
        }
        if (exist && (this.dbHeader.creator_u == SyncUtils.creatorStringToInt((String)DB_C_GRAFFITI) && this.dbHeader.type_u == SyncUtils.creatorStringToInt((String)DB_T_GRAFFITIMACROS) || (this.dbHeader.attributes_u & 0x10) != 0) && this.dbHeader.name.length < 32) {
            byte[] bytes = " ".getBytes();
            this.dbHeader.name[macroName.length()] = bytes[0];
            this.resetFlag = true;
            exist = false;
        }
        this.doDebugLog("database " + new String(this.dbHeader.name) + " exist = " + exist);
        if (this.isValidDB()) {
            RecordEntryType firstRec;
            if ((this.dbHeader.attributes_u & 1) != 0) {
                int extra_bytes;
                this.doDebugLog("Database " + new String(this.dbHeader.name) + " is a resource database");
                this.createRemoteDB(this.dbHeader.name, this.dbHeader.creator_u, this.dbHeader.type_u, this.dbHeader.attributes_u, this.dbHeader.version_u);
                this.dbType = 1;
                this.numRecords = this.dbHeader.numRecords_u;
                this.doDebugLog("numRecords = " + this.numRecords);
                this.readRecordHeaders();
                firstRec = null;
                this.numRecords = this.dbHeader.numRecords_u;
                if (this.numRecords > 0) {
                    firstRec = (RsrcEntryType)this.recordP.elementAt(0);
                }
                if ((extra_bytes = firstRec.localChunkID_u - 78 - this.recordP.size() * 10) > 0) {
                    byte[] extra = new byte[extra_bytes];
                    try {
                        this.fileBuffer.read(extra);
                    }
                    catch (Exception exception) {
                        InstallerException s = new InstallerException(this.localFileName, 4098);
                        throw s;
                    }
                }
            } else {
                this.doDebugLog("Database " + new String(this.dbHeader.name) + " is a data record database");
                this.createRemoteDB(this.dbHeader.name, this.dbHeader.creator_u, this.dbHeader.type_u, this.dbHeader.attributes_u, this.dbHeader.version_u);
                this.dbType = 0;
                this.numRecords = this.dbHeader.numRecords_u;
                this.doDebugLog("numRecords = " + this.numRecords);
                this.readRecordHeaders();
                firstRec = null;
                if (this.numRecords > 0) {
                    firstRec = (RecordEntryType)this.recordP.elementAt(0);
                }
                int extra_bytes = 0;
                if (this.dbHeader.appInfoID_u > 0) {
                    extra_bytes = this.dbHeader.appInfoID_u - 78 - this.recordP.size() * 8;
                } else if (this.dbHeader.sortInfoID_u > 0) {
                    extra_bytes = this.dbHeader.sortInfoID_u - 78 - this.recordP.size() * 8;
                } else if (this.numRecords > 0) {
                    extra_bytes = firstRec.localChunkID_u - 78 - this.recordP.size() * 8;
                }
                if (extra_bytes > 0) {
                    byte[] extra = new byte[extra_bytes];
                    try {
                        this.fileBuffer.read(extra);
                    }
                    catch (Exception exception) {
                        InstallerException s = new InstallerException(this.localFileName, 4098);
                        throw s;
                    }
                }
                if (this.dbHeader.appInfoID_u > 0) {
                    if (this.dbHeader.sortInfoID_u > 0) {
                        appInfoSize = this.dbHeader.sortInfoID_u - this.dbHeader.appInfoID_u;
                    } else if (this.numRecords == 0) {
                        appInfoSize = (int)(this.fileSize - (long)this.dbHeader.appInfoID_u);
                    } else if (firstRec != null) {
                        appInfoSize = firstRec.localChunkID_u - this.dbHeader.appInfoID_u;
                    }
                    if (appInfoSize > 0) {
                        this.createRemoteAppInfoBlock(appInfoSize);
                    }
                }
                if (this.dbHeader.sortInfoID_u > 0) {
                    if (this.numRecords == 0) {
                        sortInfoSize = (int)(this.fileSize - (long)this.dbHeader.sortInfoID_u);
                    } else if (firstRec != null) {
                        sortInfoSize = firstRec.localChunkID_u - this.dbHeader.sortInfoID_u;
                    }
                    if (sortInfoSize > 0) {
                        this.createRemoteSortInfoBlock(sortInfoSize);
                    }
                }
            }
            if ((this.dbHeader.attributes_u & 0x20) != 0) {
                this.resetFlag = true;
            } else if (this.dbHeader.type_u == SyncUtils.creatorStringToInt((String)DB_T_SYSPATCH) || this.dbHeader.type_u == SyncUtils.creatorStringToInt((String)DB_T_EXTENSION)) {
                this.resetFlag = true;
            }
        } else {
            InstallerException e = new InstallerException(this.localFileName, 4098);
            throw e;
        }
    }

    void processDataDBRecords() throws InstallerException {
        int vRomMajor = (int)SyncDefs.SYNCROMVMAJOR((int)this.sysInfo.romSoftVersion);
        CRawRecordInfo crawRecInfo = new CRawRecordInfo();
        crawRecInfo.m_FileHandle_u = (byte)(this.dbHandle & 0xFF);
        int recSize = 0;
        boolean readErr = false;
        int i = 0;
        while (i < this.numRecords) {
            RecordEntryType curRec = (RecordEntryType)this.recordP.elementAt(i);
            if (i < this.numRecords - 1) {
                RecordEntryType nextRec = (RecordEntryType)this.recordP.elementAt(i + 1);
                recSize = nextRec.localChunkID_u - curRec.localChunkID_u;
            } else {
                recSize = (int)(this.fileSize - (long)curRec.localChunkID_u);
            }
            if (recSize > 65520 || recSize < 0) {
                InstallerException instException = new InstallerException(this.localFileName, 4108);
                throw instException;
            }
            crawRecInfo.m_RecId = vRomMajor < 2 ? 0L : (long)curRec.getUniqueID();
            crawRecInfo.m_Attribs_u = (byte)(curRec.attributes_u & 0xF0);
            crawRecInfo.m_CatId = (short)(curRec.attributes_u & 0xF);
            crawRecInfo.m_RecSize_u = recSize;
            crawRecInfo.m_pBytes_u = new byte[recSize];
            crawRecInfo.m_TotalBytes = recSize;
            int len = 0;
            try {
                int n = 0;
                int ret = 0;
                while (len < recSize && n <= recSize / 100) {
                    ret = this.fileBuffer.read(crawRecInfo.m_pBytes_u, len, recSize - len);
                    if (ret != -1) {
                        len += ret;
                        ++n;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                readErr = true;
            }
            if (readErr) {
                InstallerException instException = new InstallerException(this.localFileName, 4109);
                throw instException;
            }
            try {
                SyncManager.sunwWriteRawRec((CRawRecordInfo)crawRecInfo);
            }
            catch (IOException e) {
                this.doDebugLog("The raw datat record that causes write error.");
                this.doDebugLog(crawRecInfo.dumpFormatted());
                InstallerException instException = new InstallerException(this.dbName, 4110, (SyncException)((Object)e));
                throw instException;
            }
            ++i;
        }
    }

    void processFiles(String searchPath, boolean deleteFiles, boolean subDir) throws SyncException {
        FileNameFilter filter = new FileNameFilter();
        File dirInfo = new File(searchPath);
        if (dirInfo.isDirectory()) {
            String[] dirEntryList = dirInfo.list(filter);
            int i = 0;
            while (i < dirEntryList.length) {
                File file = new File(dirEntryList[i]);
                if (file.isDirectory()) {
                    this.processFiles(dirEntryList[i], deleteFiles, subDir);
                    File newFileInfo = new File(dirEntryList[i]);
                    String[] list = newFileInfo.list(filter);
                    if (list.length == 0) {
                        newFileInfo.delete();
                    }
                } else if (this.isInstallConduitType(dirEntryList[i])) {
                    this.localFileName = String.valueOf(searchPath) + SyncConstants.SEPARATOR + dirEntryList[i];
                    this.processLocalBinaryFile(this.localFileName, deleteFiles);
                }
                ++i;
            }
        }
    }

    void processLocalBinaryFile(String fileName, boolean deleteFlag) throws SyncException {
        BufferedInputStream fileIS = null;
        File localFile = null;
        this.dbHandle = 0;
        this.dbName = null;
        this.fileSize = 0L;
        fileIS = null;
        if (this.recordP.size() > 0) {
            this.recordP.removeAllElements();
        }
        if (this.fileBuffer != null) {
            this.fileBuffer = null;
        }
        this.doDebugLog("processLocalBinaryFile, fileName = " + fileName + ", length = " + fileName.length());
        try {
            localFile = new File(fileName);
            if (!localFile.exists()) {
                String errMsg = String.valueOf(installerRes.getString("Local File Not Found: ")) + fileName;
                this.doLog(errMsg);
                return;
            }
            this.fileSize = localFile.length();
            if (this.fileSize <= 0L) {
                String errMsg = String.valueOf(installerRes.getString("Local File Empty: ")) + fileName;
                this.doLog(errMsg);
                return;
            }
            fileIS = new BufferedInputStream(new FileInputStream(fileName));
            if (this.fileSize < Integer.MAX_VALUE) {
                byte[] buffer = new byte[(int)this.fileSize];
                int len = fileIS.read(buffer, 0, buffer.length);
                this.fileBuffer = new BufferedInputStream(new ByteArrayInputStream(buffer), len);
            } else {
                this.fileBuffer = fileIS;
            }
            this.processDBHeader();
            if (this.numRecords > 0) {
                if (this.dbType == 0) {
                    this.processDataDBRecords();
                } else if (this.dbType == 1) {
                    this.processResourceDBRecords();
                }
            }
            SyncManager.closeDB((int)this.dbHandle);
            fileIS.close();
            this.doLog(String.valueOf(fileName) + installerRes.getString(" has been installed."));
        }
        catch (InstallerException s) {
            if (s.errorCode == 4097) {
                this.doLog(String.valueOf(installerRes.getString("do not overwrite existing database ")) + fileName);
            } else {
                String errMsg = String.valueOf(installerRes.getString("Error: ")) + s.getMessage();
                this.doLog(errMsg);
                this.doDebugLog(s.getMessage());
            }
            this.cleanUp(this.dbHandle, this.dbName, fileIS);
            if (s.syncErr != null && (s.syncErr.errorCode == 16403 || s.syncErr.errorCode == 16404)) {
                throw s.syncErr;
            }
            return;
        }
        catch (IOException e) {
            this.cleanUp(this.dbHandle, this.dbName, fileIS);
            if (e instanceof SyncException && (((SyncException)((Object)e)).errorCode == 16403 || ((SyncException)((Object)e)).errorCode == 16404)) {
                throw (SyncException)((Object)e);
            }
            return;
        }
        if (deleteFlag) {
            localFile.delete();
        }
    }

    void processPatches() throws InstallerException {
        String patchPath = SyncConstants.INSTALL_DIR_PATH;
        patchPath = patchPath.substring(patchPath.lastIndexOf(SyncConstants.SEPARATOR));
        patchPath = patchPath.substring(patchPath.lastIndexOf(SyncConstants.SEPARATOR));
        long m = SyncDefs.SYNCROMVMINOR((int)this.sysInfo.romSoftVersion);
        Integer minor = new Integer((int)m);
        if (minor.toString().length() == 1) {
            patchPath = String.valueOf(patchPath) + SyncConstants.SEPARATOR + "UPDATE" + SyncConstants.SEPARATOR + "V" + SyncDefs.SYNCROMVMAJOR((int)this.sysInfo.romSoftVersion) + ".0" + minor;
        } else if (minor.toString().length() == 2) {
            patchPath = String.valueOf(patchPath) + SyncConstants.SEPARATOR + "UPDATE" + SyncConstants.SEPARATOR + "V" + SyncDefs.SYNCROMVMAJOR((int)this.sysInfo.romSoftVersion) + "." + minor;
        } else {
            InstallerException s = new InstallerException(4099);
            throw s;
        }
        this.doDebugLog("patchPath = " + patchPath);
        try {
            this.processFiles(patchPath, false, false);
        }
        catch (SyncException e) {
            InstallerException s = new InstallerException(4100, e);
            throw s;
        }
    }

    void processResourceDBRecords() throws InstallerException {
        CRawRecordInfo crawRecInfo = new CRawRecordInfo();
        crawRecInfo.m_FileHandle_u = (byte)(this.dbHandle & 0xFF);
        int recSize = 0;
        boolean readErr = false;
        int i = 0;
        while (i < this.numRecords) {
            RsrcEntryType curRec = (RsrcEntryType)this.recordP.elementAt(i);
            if (i < this.numRecords - 1) {
                RsrcEntryType nextRec = (RsrcEntryType)this.recordP.elementAt(i + 1);
                recSize = nextRec.localChunkID_u - curRec.localChunkID_u;
            } else {
                recSize = (int)(this.fileSize - (long)curRec.localChunkID_u);
            }
            if (recSize > 65520 || recSize < 0) {
                InstallerException instException = new InstallerException(this.localFileName, 4108);
                throw instException;
            }
            crawRecInfo.m_RecId = curRec.type_u;
            crawRecInfo.m_RecIndex_u = curRec.id_u;
            crawRecInfo.m_RecSize_u = recSize;
            crawRecInfo.m_pBytes_u = new byte[recSize];
            readErr = false;
            int len = 0;
            try {
                int n = 0;
                while (len < recSize && n <= recSize / 100) {
                    int ret = this.fileBuffer.read(crawRecInfo.m_pBytes_u, len, recSize - len);
                    if (ret != -1) {
                        len += ret;
                        ++n;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                readErr = true;
            }
            if (readErr) {
                this.doDebugLog("In processResourceDBRecord, data record is CORRUPTED");
                this.doDebugLog("bytes asked = " + recSize + ", bytes returned = " + len);
                InstallerException instException = new InstallerException(this.localFileName, 4111);
                throw instException;
            }
            try {
                SyncManager.sunwWriteRawResourceRec((CRawRecordInfo)crawRecInfo);
            }
            catch (IOException e) {
                this.doDebugLog("The raw resource record that causes write error.");
                this.doDebugLog(crawRecInfo.dumpFormatted());
                InstallerException instException = new InstallerException(this.dbName, 4112, (SyncException)((Object)e));
                throw instException;
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    void readRecordHeaders() throws InstallerException {
        if (this.recordP.size() > 0) {
            this.recordP.removeAllElements();
        }
        try {
            int i = 0;
            while (i < this.numRecords) {
                if (this.dbType == 1) {
                    RsrcEntryType rsrcEntry = new RsrcEntryType();
                    rsrcEntry.readData(this.fileBuffer);
                    this.recordP.addElement(rsrcEntry);
                } else if (this.dbType == 0) {
                    RecordEntryType recEntry = new RecordEntryType();
                    recEntry.readData(this.fileBuffer);
                    this.recordP.addElement(recEntry);
                }
                ++i;
            }
        }
        catch (IOException iOException) {
            void i;
            InstallerException s = new InstallerException(this.localFileName, 4103);
            throw i;
        }
    }
}

