/*
 * Decompiled with CFR 0.152.
 */
package sun.servlet.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import sun.servlet.ServletLoader;
import sun.servlet.http.HackURLConnection;
import sun.servlet.http.HttpServerHandler;
import sun.servlet.http.HttpServletConfig;
import sun.servlet.http.SessionContextImpl;
import sun.servlet.util.Queue;
import sun.servlet.util.QueueEmptyException;
import sun.servlet.util.QueueFullException;

public class HttpServer
implements Runnable,
ServletContext {
    protected Queue connections;
    protected ThreadGroup handlers;
    protected int maxHandlers = 100;
    protected int timeout = 5000;
    protected int port = 8080;
    protected int backlog = 50;
    protected int avail;
    protected int total;
    protected String name = "servletrunner/2.0";
    protected String host;
    protected String servletDir = "." + System.getProperty("file.separator") + "examples";
    protected Properties servletProps = new Properties();
    protected String servletPropFile = String.valueOf(this.servletDir) + System.getProperty("file.separator") + "servlets.properties";
    protected String documentDir = "." + System.getProperty("file.separator") + "examples";
    protected ServletLoader loader;
    protected boolean verbose = true;
    protected SessionContextImpl sessionContext = new SessionContextImpl();

    public SessionContextImpl getSessionContext() {
        return this.sessionContext;
    }

    public HttpServer() {
    }

    public HttpServer(Properties properties) {
        this.loadProperties(properties);
    }

    private void loadServletProps() {
        File file = new File(this.servletPropFile);
        if (file.exists() && file.canRead()) {
            try {
                this.servletProps.load(new FileInputStream(file));
                return;
            }
            catch (IOException iOException) {
                System.err.println("Could not load servlet properites file");
                iOException.printStackTrace(System.err);
                return;
            }
        }
    }

    public void loadProperties(Properties properties) {
        this.host = HttpServer.getHostName();
        this.port = HttpServer.getIntProperty(properties, "server.port", this.port);
        this.backlog = HttpServer.getIntProperty(properties, "server.backlog", this.backlog);
        this.maxHandlers = HttpServer.getIntProperty(properties, "server.max.handlers", this.maxHandlers);
        this.timeout = HttpServer.getIntProperty(properties, "server.timeout", this.timeout);
        this.name = properties.getProperty("server.name", this.name);
        this.servletDir = properties.getProperty("servlet.dir", this.servletDir);
        this.documentDir = properties.getProperty("document.dir", this.documentDir);
        this.servletPropFile = properties.getProperty("servlet.propfile", String.valueOf(this.servletDir) + File.separatorChar + "servlet.properties");
        this.loadServletProps();
    }

    protected static int getIntProperty(Properties properties, String string, int n) {
        String string2 = properties.getProperty(string);
        try {
            if (string2 != null) {
                return Integer.parseInt(string2);
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    protected static String getHostName() {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        String string = inetAddress.getHostName();
        if (string == null || string.indexOf(46) == -1) {
            string = inetAddress.getHostAddress();
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        ServerSocket serverSocket;
        if (this.verbose) {
            this.printSettings();
        }
        this.connections = new Queue(this.maxHandlers);
        this.handlers = new ThreadGroup("servletrunner-");
        this.loader = new ServletLoader(this.servletDir);
        try {
            serverSocket = new ServerSocket(this.port, this.backlog);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        while (true) {
            Object object = this;
            synchronized (object) {
                while (true) {
                    if (this.avail > 0) {
                        --this.avail;
                        break;
                    }
                    if (this.total < this.maxHandlers) {
                        HttpServerHandler httpServerHandler = new HttpServerHandler(this);
                        new Thread(this.handlers, httpServerHandler).start();
                        ++this.total;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            object = null;
            try {
                object = serverSocket.accept();
                this.putConnection(object);
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                if (object == null) continue;
                try {
                    ((Socket)object).close();
                }
                catch (IOException iOException2) {
                }
                continue;
            }
            break;
        }
    }

    protected void putConnection(Object object) {
        try {
            Queue queue = this.connections;
            synchronized (queue) {
                this.connections.add(object);
                this.connections.notify();
                return;
            }
        }
        catch (QueueFullException queueFullException) {
            throw new InternalError("connection queue overflow");
        }
    }

    public Object getConnection() {
        long l;
        HttpServer httpServer = this;
        synchronized (httpServer) {
            l = this.timeout;
            ++this.avail;
            this.notify();
        }
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        Queue queue = this.connections;
        synchronized (queue) {
            while (this.connections.empty() && l3 < l) {
                try {
                    this.connections.wait(l - l3);
                }
                catch (InterruptedException interruptedException) {}
                l3 = System.currentTimeMillis() - l2;
            }
            try {
                Object object = this.connections.remove();
                Object var9_7 = null;
                return object;
            }
            catch (QueueEmptyException queueEmptyException) {
            }
        }
        --this.total;
        --this.avail;
        return null;
    }

    public Servlet getServlet(String string) {
        String string2 = this.servletProps.getProperty("servlet." + string + ".code");
        String string3 = this.servletProps.getProperty("servlet." + string + ".initArgs");
        try {
            if (string2 == null) {
                return this.loader.loadServlet(string, new HttpServletConfig((ServletContext)this, string3));
            }
            return this.loader.loadServlet(string2, new HttpServletConfig((ServletContext)this, string3));
        }
        catch (ServletException servletException) {
            servletException.printStackTrace();
            return null;
        }
    }

    public Enumeration getServlets() {
        return this.loader.getServlets();
    }

    public Enumeration getServletNames() {
        return this.loader.getServletNames();
    }

    public void log(String string) {
        System.err.println(string);
    }

    public void log(Exception exception, String string) {
        this.log(string);
        exception.printStackTrace(System.err);
    }

    public String getMimeType(String string) {
        if (string == null) {
            return null;
        }
        return HackURLConnection.guessContentTypeFromName(string);
    }

    public String getRealPath(String string) {
        if (string == null) {
            return null;
        }
        string = String.valueOf(this.documentDir) + string;
        return string.replace('/', File.separatorChar);
    }

    public String getServerInfo() {
        return this.name;
    }

    public Object getAttribute(String string) {
        return null;
    }

    public static void main(String[] stringArray) {
        HttpServer httpServer = new HttpServer();
        Properties properties = new Properties();
        try {
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                if ("-p".equals(string)) {
                    ((Hashtable)properties).put("server.port", stringArray[++n]);
                } else if ("-b".equals(string)) {
                    ((Hashtable)properties).put("server.backlog", stringArray[++n]);
                } else if ("-m".equals(string)) {
                    ((Hashtable)properties).put("server.max.handlers", stringArray[++n]);
                } else if ("-t".equals(string)) {
                    ((Hashtable)properties).put("server.timeout", stringArray[++n]);
                } else if ("-d".equals(string)) {
                    ((Hashtable)properties).put("servlet.dir", stringArray[++n]);
                } else if ("-r".equals(string)) {
                    ((Hashtable)properties).put("document.dir", stringArray[++n]);
                } else if ("-s".equals(string)) {
                    ((Hashtable)properties).put("servlet.propfile", stringArray[++n]);
                } else if ("-v".equals(string)) {
                    httpServer.verbose = true;
                } else {
                    HttpServer.help();
                }
                ++n;
            }
            httpServer.loadProperties(properties);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            HttpServer.help();
        }
        httpServer.run();
    }

    protected void printSettings() {
        PrintStream printStream = System.err;
        printStream.println("servletrunner starting with settings:");
        printStream.println("  port = " + this.port);
        printStream.println("  backlog = " + this.backlog);
        printStream.println("  max handlers = " + this.maxHandlers);
        printStream.println("  timeout = " + this.timeout);
        printStream.println("  servlet dir = " + this.servletDir);
        printStream.println("  document dir = " + this.documentDir);
        printStream.println("  servlet propfile = " + this.servletPropFile);
    }

    protected static void help() {
        PrintStream printStream = System.err;
        printStream.println("Usage: servletrunner [options]");
        printStream.println("Options:");
        printStream.println("  -p port     the port number to listen on");
        printStream.println("  -b backlog  the listen backlog");
        printStream.println("  -m max      maximum number of connection handlers");
        printStream.println("  -t timeout  connection timeout in milliseconds");
        printStream.println("  -d dir      servlet directory");
        printStream.println("  -s filename servlet property file name");
        System.exit(1);
    }
}

