/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.util.misc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Properties;

public class JDTLogger {
    private String _clientHostName = null;
    private String _applName = null;
    private String _host = null;
    private String _cgiScript = null;
    private Integer _port = null;
    private Properties _props;

    public JDTLogger(Properties props) {
        this._props = props;
        try {
            String portStr = null;
            this._clientHostName = InetAddress.getLocalHost().getHostName();
            if (props != null) {
                this._host = props.getProperty("jdt.log.server.host");
                portStr = props.getProperty("jdt.log.server.port");
                this._port = new Integer(portStr);
                this._cgiScript = props.getProperty("jdt.log.cgi.proxy");
            }
        }
        catch (UnknownHostException unknownHostException) {
            this._clientHostName = null;
        }
        catch (NumberFormatException numberFormatException) {
            this._port = new Integer(80);
        }
    }

    public JDTLogger(Properties props, String applName) {
        this(props);
        this._applName = applName;
    }

    public JDTLogger(Properties props, URL codeBase) {
        this(props);
        if (codeBase != null) {
            if (this._host == null || this._host.equals("")) {
                this._host = codeBase.getHost();
            }
            if (this._port == null || this._port <= 0) {
                int n = codeBase.getPort();
                if (n < 0) {
                    n = 80;
                }
                this._port = new Integer(n);
            }
        }
    }

    private void _sendMsg(String svrMsg) {
        PrintWriter outStream = null;
        if (this._props == null || this._host == null) {
            return;
        }
        if (this._cgiScript == null) {
            this._cgiScript = new String("/cgi-bin/jdt/jdtlogsvc");
        }
        try {
            try {
                String line;
                Socket sock = new Socket(this._host, (int)this._port);
                outStream = new PrintWriter(sock.getOutputStream(), true);
                BufferedReader inStream = new BufferedReader(new InputStreamReader(sock.getInputStream()));
                outStream.println("POST " + this._cgiScript + " HTTP/1.0\r\n" + "Content-type: application/octet-stream\r\n" + "Content-length: " + svrMsg.length() + "\r\n\r\n");
                outStream.println(svrMsg);
                while ((line = inStream.readLine()) != null) {
                }
            }
            catch (MalformedURLException e) {
                System.out.println(e.getMessage());
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            Object var5_8 = null;
            if (outStream != null) {
                outStream.close();
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            if (outStream != null) {
                outStream.close();
            }
            throw throwable;
        }
    }

    public String getApplName() {
        return this._applName;
    }

    public void logMessage(String msg) {
        String svrMsg = null;
        svrMsg = this._clientHostName != null && this._applName != null ? String.valueOf(this._clientHostName) + ":" + this._applName + ":" + msg : (this._clientHostName != null && this._applName == null ? String.valueOf(this._clientHostName) + "::" + msg : (this._clientHostName == null && this._applName != null ? ":" + this._applName + ":" + msg : "::" + msg));
        this._sendMsg(svrMsg);
    }

    public void logMessage(String applName, String msg) {
        String svrMsg = null;
        svrMsg = this._clientHostName != null && applName != null ? String.valueOf(this._clientHostName) + ":" + applName + ":" + msg : (this._clientHostName != null && applName == null ? String.valueOf(this._clientHostName) + "::" + msg : (this._clientHostName == null && applName != null ? ":" + applName + ":" + msg : "::" + msg));
        this._sendMsg(svrMsg);
    }

    public void setApplName(String applName) {
        this._applName = applName;
    }
}

