/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchResult;

public class GetId {
    static final int NOBODY = 60001;
    static final String domainFile = "/etc/defaultdomain";
    static String defaultDomain = null;
    static Properties jndiEnv = new Properties();

    static {
        try {
            String serverRoot = System.getProperty("webaccess.root");
            Properties props = new Properties();
            String propsPath = String.valueOf(serverRoot) + "/properties/calendar.properties";
            props.load(new BufferedInputStream(new FileInputStream(propsPath)));
            defaultDomain = props.getProperty("calendar.defaultDomain");
            System.err.println("*****defaultDomain = " + defaultDomain);
            if (defaultDomain == null || defaultDomain.trim().equals("")) {
                BufferedReader in = new BufferedReader(new FileReader(domainFile));
                defaultDomain = in.readLine().trim();
                in.close();
            }
            String nis = props.getProperty("calendar.nisType");
            System.err.println("*****nis = " + nis);
            if (nis != null && nis.trim().equalsIgnoreCase("nis+")) {
                ((Hashtable)jndiEnv).put("java.naming.factory.initial", "com.sun.jndi.nisplus.NisPlusCtxFactory");
            } else {
                ((Hashtable)jndiEnv).put("java.naming.factory.initial", "com.sun.jndi.nis.NISCtxFactory");
                ((Hashtable)jndiEnv).put("java.naming.provider.url", "nis:" + defaultDomain);
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
    }

    public static int getGID(String username) {
        return GetId.getXID(username, "gidNumber");
    }

    public static int getUID(String username) {
        return GetId.getXID(username, "uidNumber");
    }

    public static int getXID(String username, String whichId) {
        int id = 60001;
        NamingEnumeration<SearchResult> results = null;
        try {
            InitialDirContext ctx = new InitialDirContext(jndiEnv);
            BasicAttributes match = new BasicAttributes();
            match.put("uid", username);
            results = ctx.search("user", (Attributes)match);
            if (results != null && results.hasMoreElements()) {
                SearchResult sr = results.next();
                Attributes attrs = sr.getAttributes();
                Attribute attr = attrs.get(whichId);
                id = Integer.parseInt((String)attr.get());
            }
        }
        catch (NamingException ne) {
            System.err.println(ne.toString());
        }
        return id;
    }
}

