/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Debug {
    public static boolean on = false;
    public static final boolean dumpStack = false;

    public static void assert(boolean b) {
        if (on && !b) {
            System.err.println("#### ASSERTION FAILED #####");
            Thread.currentThread();
            Thread.dumpStack();
            System.err.println("###########################");
        }
    }

    public static void assertPrint(boolean b, String message) {
        if (on && !b) {
            System.err.println("#### ASSERTION FAILED: " + message);
        }
    }

    public static void dumpException(Exception e) {
        if (!on) {
            return;
        }
        Debug.dumpException(e, "Unspecified Exception");
    }

    public static void dumpException(Exception e, String message) {
        if (!on) {
            return;
        }
        System.err.println("####### Exception Caught #######");
        System.err.println(message);
        e.printStackTrace();
        System.err.println("###########################");
    }

    public static void dumpThread(Thread next) {
        System.out.println(String.valueOf(next.getName()) + "  P" + next.getPriority() + "  G(" + next.getThreadGroup().getName() + ")" + "  [" + next.countStackFrames() + "]" + "  " + (next.isDaemon() ? "Daemon" : "User") + "  " + (next.isInterrupted() ? "Interrupted" : "Executing") + "  " + (next.isAlive() ? "Alive" : "NotAlive"));
    }

    public static void dumpThreads(boolean currentGroup) {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        if (!currentGroup) {
            while (group.getParent() != null) {
                group = group.getParent();
            }
        }
        Thread[] threads = new Thread[group.activeCount()];
        int count = group.enumerate(threads, true);
        int i = 0;
        while (i < count) {
            Thread next = threads[i];
            Debug.dumpThread(next);
            ++i;
        }
    }

    public static Thread findGC() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        while (group.getParent() != null) {
            group = group.getParent();
        }
        Thread[] threads = new Thread[group.activeCount()];
        int count = group.enumerate(threads, true);
        int i = 0;
        while (i < count) {
            Thread next = threads[i];
            if (next.getName().equals("Async Garbage Collector")) {
                return next;
            }
            ++i;
        }
        return null;
    }

    public static long gc() {
        Runtime rt = Runtime.getRuntime();
        long amount = rt.freeMemory();
        long delta = 10000L;
        while (delta > 100L || delta < -100L) {
            rt.gc();
            long newAmount = rt.freeMemory();
            delta = amount - newAmount;
            amount = newAmount;
        }
        return amount;
    }

    public static void print(String message) {
        if (on) {
            System.err.println(message);
        }
    }
}

