/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.rpc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import sunw.jdt.cal.rpc.xdr_basic;
import sunw.jdt.cal.rpc.xdr_prim;

public class xdr_vc
extends xdr_basic {
    static boolean vc_trace = false;
    static final long LAST_FRAG = Integer.MIN_VALUE;
    static final long SIZE_MASK = Integer.MAX_VALUE;
    static final int VC_BUFSIZ = 1024;
    private Socket peer;
    private boolean my_peer;
    private boolean in_lastfrag;
    private byte[] hbuf;

    public xdr_vc(String server, int port) throws IOException {
        if (xdr_basic.trace) {
            System.out.println(String.valueOf(this.getClass().getName()) + ": server \"" + server + "\" port " + port);
        }
        if (server == null || server.length() == 0) {
            throw new IOException("null/empty server name");
        }
        try {
            if (vc_trace) {
                System.out.println("xdr_vc: creating Socket(" + server + ", " + port + ")");
            }
            Socket s = new Socket(server, port);
            if (vc_trace) {
                System.out.println("xdr_vc: socket created, local: " + s.getLocalPort());
            }
            this.init(s, true);
        }
        catch (Throwable e) {
            System.out.println("xdr_vc: got exception");
            e.printStackTrace();
            throw new IOException("xdr_vc");
        }
    }

    public xdr_vc(Socket so) {
        this.init(so, false);
    }

    public void assert_full_frame() throws IOException {
        if (!this.in_lastfrag) {
            System.out.println("assert_full_frame: xdrin last frag not read");
            if (this.hard_assert_full_frame) {
                throw new IOException("last frag not processed");
            }
        }
        if (this.inindex != this.inbuffer.length) {
            System.out.println("assert_full_frame: xdrin " + this.inindex + " of " + this.inbuffer.length + " bytes");
            if (this.hard_assert_full_frame) {
                throw new IOException("partial frame processed");
            }
        }
    }

    public void close() throws IOException {
        if (xdr_basic.trace) {
            System.out.println(String.valueOf(this.getClass().getName()) + ".close: call");
        }
        this.close_called = true;
        if (this.my_peer) {
            if (vc_trace) {
                System.out.println("xdr_vc: closing socket, local: " + this.peer.getLocalPort());
            }
            this.peer.close();
        }
        this.peer = null;
    }

    protected void fillbuf() throws IOException {
        if (xdr_basic.trace) {
            System.out.println(String.valueOf(this.getClass().getName()) + ".fillbuf: reading header bytes");
        }
        if (this.in_lastfrag) {
            throw new IOException("fillbuf after LASTFRAG");
        }
        xdr_vc.mread(this.peer.getInputStream(), this.hbuf);
        long header = xdr_prim.nu4tol(this.hbuf);
        int payload = (int)(header & Integer.MAX_VALUE);
        boolean bl = this.in_lastfrag = (header & Integer.MIN_VALUE) != 0L;
        if (xdr_basic.trace) {
            System.out.print(String.valueOf(this.getClass().getName()) + ".fillbuf: payload ");
            System.out.println(payload);
            System.out.print(String.valueOf(this.getClass().getName()) + ".fillbuf: lastfrag ");
            System.out.println(this.in_lastfrag);
        }
        this.inbuffer = new byte[payload];
        this.inindex = 0;
        xdr_vc.mread(this.peer.getInputStream(), this.inbuffer);
        if (xdr_basic.trace) {
            System.out.print(String.valueOf(this.getClass().getName()) + ".fillbuf: read ");
            System.out.println(String.valueOf(payload) + " data bytes:");
            int i = 0;
            while (i < payload) {
                int val = this.inbuffer[i];
                if (val < 0) {
                    val += 256;
                }
                System.out.print(String.valueOf(val) + " ");
                ++i;
            }
            System.out.println();
        }
    }

    protected void flushbuf(boolean eor) throws IOException {
        int payload = this.outindex - 4;
        long header = payload;
        if (eor) {
            header |= Integer.MIN_VALUE;
        }
        this.outindex = 0;
        this.xdrout_u_long(header);
        this.outindex = payload + 4;
        this.peer.getOutputStream().write(this.outbuffer, 0, payload + 4);
        if (xdr_basic.trace) {
            System.out.print(String.valueOf(this.getClass().getName()) + ".flushbuf: wrote ");
            System.out.println(String.valueOf(payload) + " + 4 bytes:");
            System.out.print("[ ");
            int i = 0;
            while (i < payload) {
                int val = this.outbuffer[4 + i];
                if (val < 0) {
                    val += 256;
                }
                System.out.print(String.valueOf(Integer.toString(val, 16)) + " ");
                ++i;
            }
            System.out.println(" ]");
        }
    }

    protected void init(Socket so, boolean my_so) {
        this.outbuffer = new byte[1024];
        this.outindex = 0;
        this.reset_inrecord();
        this.reset_outrecord();
        this.peer = so;
        this.my_peer = my_so;
        this.hbuf = new byte[4];
    }

    private static void mread(InputStream is, byte[] buf) throws IOException {
        int offset = 0;
        while (offset < buf.length) {
            if (xdr_basic.trace) {
                System.out.println("xdr_vc.mread: offset=" + offset + ", count=" + (buf.length - offset));
            }
            int cc = is.read(buf, offset, buf.length - offset);
            if (xdr_basic.trace) {
                System.out.println("xdr_vc.mread: got " + cc + " of " + buf.length + " bytes");
            }
            if (cc <= 0) {
                throw new EOFException("xdr_vc.mread: EOF (cc is " + cc + ")");
            }
            offset += cc;
        }
    }

    protected void reset_inrecord() {
        this.in_lastfrag = false;
        this.inbuffer = null;
        this.inindex = 0;
    }

    public void reset_outrecord() {
        this.outindex = 4;
    }

    public void send_record() throws IOException {
        this.flushbuf(true);
        this.reset_outrecord();
    }
}

