/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.rpc;

import java.io.IOException;

public abstract class xdr_prim {
    static final int BYTES_PER_XDR_UNIT = 4;
    static final int XDR_UNIT_MASK = 3;
    static final long MAX_U32 = 0xFFFFFFFFL;

    public static final byte[] iton4(int val) {
        byte[] buf = new byte[]{(byte)(val >> 24), (byte)(val >> 16), (byte)(val >> 8), (byte)val};
        return buf;
    }

    public static final byte[] lton8(long val) {
        byte[] buf = new byte[8];
        int hi32 = (int)(val >> 32);
        int lo32 = (int)val;
        buf[0] = (byte)(hi32 >> 24);
        buf[1] = (byte)(hi32 >> 16);
        buf[2] = (byte)(hi32 >> 8);
        buf[3] = (byte)hi32;
        buf[4] = (byte)(lo32 >> 24);
        buf[5] = (byte)(lo32 >> 16);
        buf[6] = (byte)(lo32 >> 8);
        buf[7] = (byte)lo32;
        return buf;
    }

    public static final byte[] ltonu4(long xval) {
        byte[] buf = new byte[4];
        int val = (int)xval;
        buf[0] = (byte)(val >> 24);
        buf[1] = (byte)(val >> 16);
        buf[2] = (byte)(val >> 8);
        buf[3] = (byte)val;
        return buf;
    }

    public static final int n4toi(byte[] buf) {
        int val = (buf[0] & 0xFF) << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | buf[3] & 0xFF;
        return val;
    }

    public static final short n4tos(byte[] buf) {
        short val = (short)((buf[2] & 0xFF) << 8 | buf[3] & 0xFF);
        return val;
    }

    public static final long n8tol(byte[] buf) {
        int hi32 = (buf[0] & 0xFF) << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | buf[3] & 0xFF;
        int lo32 = (buf[4] & 0xFF) << 24 | (buf[5] & 0xFF) << 16 | (buf[6] & 0xFF) << 8 | buf[7] & 0xFF;
        long i64 = (long)hi32 << 32 | (long)lo32 & 0xFFFFFFFFL;
        return i64;
    }

    public static final long nu4tol(byte[] buf) {
        int val = (buf[0] & 0xFF) << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | buf[3] & 0xFF;
        return (long)val & 0xFFFFFFFFL;
    }

    public static final byte[] ston4(short val) {
        byte[] buf = new byte[4];
        buf[2] = (byte)(val >> 8);
        buf[3] = (byte)val;
        return buf;
    }

    public final boolean xdrin_bool() throws IOException {
        return this.xdrin_long() != 0;
    }

    public final int xdrin_enum() throws IOException {
        return this.xdrin_long();
    }

    public final float xdrin_float() throws IOException {
        return Float.intBitsToFloat(this.xdrin_long());
    }

    public final long xdrin_hyper() throws IOException {
        return xdr_prim.n8tol(this.xdrin_opaque(8));
    }

    public final int xdrin_int() throws IOException {
        return this.xdrin_long();
    }

    public final int xdrin_long() throws IOException {
        return xdr_prim.n4toi(this.xdrin_opaque(4));
    }

    public abstract byte[] xdrin_opaque(int var1) throws IOException;

    public final short xdrin_short() throws IOException {
        return xdr_prim.n4tos(this.xdrin_opaque(4));
    }

    public final long xdrin_u_hyper() throws IOException {
        long val = xdr_prim.n8tol(this.xdrin_opaque(8));
        if (val < 0L) {
            throw new IOException("got u_hyper < 0");
        }
        return val;
    }

    public final long xdrin_u_int() throws IOException {
        return this.xdrin_u_long();
    }

    public final long xdrin_u_long() throws IOException {
        return xdr_prim.nu4tol(this.xdrin_opaque(4));
    }

    public final void xdrout_bool(boolean val) throws IOException {
        this.xdrout_long(val ? 1 : 0);
    }

    public final void xdrout_enum(int val) throws IOException {
        this.xdrout_long(val);
    }

    public final void xdrout_float(float val) throws IOException {
        this.xdrout_long(Float.floatToIntBits(val));
    }

    public final void xdrout_hyper(long val) throws IOException {
        this.xdrout_opaque(xdr_prim.lton8(val));
    }

    public final void xdrout_int(int val) throws IOException {
        this.xdrout_long(val);
    }

    public final void xdrout_long(int val) throws IOException {
        this.xdrout_opaque(xdr_prim.iton4(val));
    }

    public abstract void xdrout_opaque(byte[] var1) throws IOException;

    public final void xdrout_short(short val) throws IOException {
        this.xdrout_opaque(xdr_prim.ston4(val));
    }

    public final void xdrout_u_hyper(long val) throws IOException {
        this.xdrout_opaque(xdr_prim.lton8(val));
    }

    public final void xdrout_u_int(long val) throws IOException {
        this.xdrout_u_long(val);
    }

    public final void xdrout_u_long(long val) throws IOException {
        this.xdrout_opaque(xdr_prim.ltonu4(val));
    }
}

