/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.rpc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import sunw.jdt.cal.rpc.ReadThread;
import sunw.jdt.cal.rpc.xdr_basic;
import sunw.jdt.cal.util.Debug;

public class xdr_dg
extends xdr_basic {
    static final int DG_BUFSIZ = 1024;
    private DatagramSocket peer;
    private ReadThread reader;
    private Object reader_lock;
    private InetAddress mraddr;
    private int mrport;

    public xdr_dg(String server, int port) throws IOException {
        if (server == null || server.length() == 0) {
            throw new IOException("null/empty server name");
        }
        this.mraddr = InetAddress.getByName(server);
        this.mrport = port;
        this.init(null);
    }

    public xdr_dg(DatagramPacket s) throws IOException {
        this.mraddr = s.getAddress();
        this.mrport = s.getPort();
        this.init(s);
    }

    public void assert_full_frame() throws IOException {
        if (this.inindex != this.inbuffer.length) {
            Debug.print("assert_full_frame: xdrin " + this.inindex + " of " + this.inbuffer.length + " bytes");
            if (this.hard_assert_full_frame) {
                throw new IOException("partial frame processed");
            }
        }
    }

    public void close() throws IOException {
        if (xdr_basic.trace) {
            System.out.println(String.valueOf(this.getClass().getName()) + ".close: call");
        }
        this.close_called = true;
        this.reader.interrupt();
        this.reader.stop();
        this.reader.closeit();
        this.reader = null;
        this.peer.close();
        this.peer = null;
    }

    protected void fillbuf() throws IOException {
        this.recv(1000L);
    }

    protected void flushbuf(boolean eor) throws IOException {
        throw new IOException(String.valueOf(this.getClass().getName()) + "output buffer overflow");
    }

    public String getHost() {
        return this.mraddr.getHostName();
    }

    protected void init(DatagramPacket pkt) throws IOException {
        this.outbuffer = new byte[1024];
        this.outindex = 0;
        this.reader_lock = new Object();
        this.peer = new DatagramSocket();
        this.reader = pkt == null ? new ReadThread(this.reader_lock, this.peer) : new ReadThread(this.reader_lock, new ByteArrayInputStream(pkt.getData(), 0, pkt.getLength()));
        this.reader.start();
    }

    public boolean recv(long msecs) throws IOException {
        byte[] buf = this.reader.get_or_wait(msecs);
        if (xdr_basic.trace) {
            if (buf == null) {
                System.out.println("recv: returning null data");
            } else {
                System.out.println("recv: returning " + buf.length + " bytes");
            }
        }
        if (buf == null) {
            Debug.print(String.valueOf(this.getClass().getName()) + ".recv: timed out ");
            return false;
        }
        this.inbuffer = buf;
        this.inindex = 0;
        return true;
    }

    protected void reset_inrecord() throws IOException {
        this.inbuffer = null;
        this.inindex = 0;
    }

    public void reset_outrecord() {
        this.outindex = 0;
    }

    public void send_record() throws IOException {
        int payload = this.outindex;
        DatagramPacket pkt = new DatagramPacket(this.outbuffer, payload, this.mraddr, this.mrport);
        this.peer.send(pkt);
        if (xdr_basic.trace) {
            System.out.print(String.valueOf(this.getClass().getName()) + ".flushbuf: wrote ");
            System.out.println(String.valueOf(payload) + " bytes:");
            System.out.print("[ ");
            int i = 0;
            while (i < payload) {
                int val = this.outbuffer[i];
                if (val < 0) {
                    val += 256;
                }
                System.out.print(String.valueOf(Integer.toString(val, 16)) + " ");
                ++i;
            }
            System.out.println(" ]");
        }
    }
}

