/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.rpc;

import java.io.IOException;
import sunw.jdt.cal.rpc.xdr_membuf_priv;
import sunw.jdt.cal.rpc.xdr_prim;
import sunw.jdt.cal.rpc.xdrin_upcall_priv;
import sunw.jdt.cal.rpc.xdrout_upcall_priv;

public abstract class xdr_basic
extends xdr_prim {
    protected byte[] localbuf = new byte[5001];
    protected static boolean trace = false;
    protected boolean hard_assert_full_frame = true;
    protected boolean close_called = false;
    protected byte[] outbuffer = null;
    protected int outindex = 0;
    protected byte[] inbuffer = null;
    protected int inindex = 0;

    protected xdr_basic() {
    }

    public abstract void assert_full_frame() throws IOException;

    public void cleanup() {
        try {
            this.close();
        }
        catch (IOException iOException) {}
    }

    public abstract void close() throws IOException;

    protected abstract void fillbuf() throws IOException;

    protected void finalize() {
        if (!this.close_called) {
            this.cleanup();
        }
    }

    protected abstract void flushbuf(boolean var1) throws IOException;

    public boolean get_assert_full_frame() {
        return this.hard_assert_full_frame;
    }

    protected abstract void reset_inrecord() throws IOException;

    public abstract void reset_outrecord();

    public abstract void send_record() throws IOException;

    public void set_assert_full_frame(boolean tf) {
        this.hard_assert_full_frame = tf;
    }

    public int xdrin_array_count() throws IOException {
        return (int)this.xdrin_u_int();
    }

    public void xdrin_array_elements(xdrin_upcall_priv[] arr) throws IOException {
        xdr_basic xdrs = this;
        if (trace) {
            System.out.print("xdrin_array_elements count " + arr.length + "\n");
        }
        String aname = arr.getClass().getName();
        String cname = aname.substring(2, aname.length() - 1);
        try {
            Class<?> elemclass = Class.forName(cname);
            int i = 0;
            while (i < arr.length) {
                arr[i] = (xdrin_upcall_priv)elemclass.newInstance();
                arr[i].xdrin(xdrs);
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
    }

    public byte[] xdrin_bytes() throws IOException {
        long len = this.xdrin_u_long();
        return this.xdrin_opaque((int)len);
    }

    public byte[] xdrin_bytes(long max) throws IOException {
        long len = this.xdrin_u_long();
        if (len > max) {
            throw new IOException("len > max");
        }
        return this.xdrin_opaque((int)len);
    }

    public byte[] xdrin_opaque(int len) throws IOException {
        byte[] buf = new byte[len];
        return this.xdrin_opaque(len, buf);
    }

    public byte[] xdrin_opaque(int len, byte[] buf) throws IOException {
        int i;
        int cc;
        int count = 0;
        while (count < len) {
            if (this.inbuffer == null || this.inindex == this.inbuffer.length) {
                this.fillbuf();
            }
            if ((cc = len - count) > this.inbuffer.length - this.inindex) {
                cc = this.inbuffer.length - this.inindex;
            }
            if (cc < 30) {
                i = 0;
                while (i < cc) {
                    buf[count + i] = this.inbuffer[this.inindex + i];
                    ++i;
                }
            } else {
                System.arraycopy(this.inbuffer, this.inindex, buf, count, cc);
            }
            this.inindex += cc;
            count += cc;
        }
        cc = 4 - (len & 3);
        if (this.inindex + (cc &= 3) > this.inbuffer.length) {
            i = 0;
            while (i < cc) {
                if (this.inindex == this.inbuffer.length) {
                    this.fillbuf();
                }
                ++this.inindex;
                ++i;
            }
        } else {
            this.inindex += cc;
        }
        return buf;
    }

    public boolean xdrin_pointer() throws IOException {
        return this.xdrin_bool();
    }

    public String xdrin_string() throws IOException {
        int len = (int)this.xdrin_u_int();
        if (len > 5000) {
            throw new IOException(String.valueOf(this.getClass().getName()) + ".xdrin_string: len == " + len);
        }
        this.xdrin_opaque(len, this.localbuf);
        String str = new String(this.localbuf, 0, len);
        return str;
    }

    public static byte[] xdrmem_xdrbytes(xdrout_upcall_priv obj) throws IOException {
        xdr_membuf_priv mxdrs = new xdr_membuf_priv();
        obj.xdrout(mxdrs);
        byte[] xbuf = new byte[mxdrs.outindex];
        System.arraycopy(mxdrs.outbuffer, 0, xbuf, 0, xbuf.length);
        return xbuf;
    }

    public void xdrout_array(xdrout_upcall_priv[] arr) throws IOException {
        xdr_basic xdrs = this;
        this.xdrout_u_int(arr.length);
        int i = 0;
        while (i < arr.length) {
            arr[i].xdrout(xdrs);
            ++i;
        }
    }

    public void xdrout_array_count(int len) throws IOException {
        this.xdrout_u_int(len);
    }

    public void xdrout_bytes(byte[] buf) throws IOException {
        this.xdrout_u_long(buf.length);
        this.xdrout_opaque(buf);
    }

    public void xdrout_bytes(byte[] buf, long max) throws IOException {
        if ((long)buf.length > max) {
            throw new IOException("buf.length > max");
        }
        this.xdrout_u_long(buf.length);
        this.xdrout_opaque(buf);
    }

    public void xdrout_opaque(byte[] buf) throws IOException {
        int i;
        int cc;
        int count = 0;
        while (count < buf.length) {
            if (this.outindex == this.outbuffer.length) {
                this.flushbuf(false);
                this.reset_outrecord();
            }
            if (this.outindex + (cc = buf.length - count) > this.outbuffer.length) {
                cc = this.outbuffer.length - this.outindex;
            }
            i = 0;
            while (i < cc) {
                this.outbuffer[this.outindex + i] = buf[count + i];
                ++i;
            }
            this.outindex += cc;
            count += cc;
        }
        cc = 4 - (buf.length & 3);
        cc &= 3;
        i = 0;
        while (i < cc) {
            if (this.outindex == this.outbuffer.length) {
                this.flushbuf(false);
                this.reset_outrecord();
            }
            this.outbuffer[this.outindex] = 0;
            ++this.outindex;
            ++i;
        }
    }

    public void xdrout_pointer(xdrout_upcall_priv xobj) throws IOException {
        if (xobj != null) {
            this.xdrout_bool(true);
            xobj.xdrout(this);
        } else {
            this.xdrout_bool(false);
        }
    }

    public void xdrout_string(String str) throws IOException {
        byte[] buf = str.getBytes();
        this.xdrout_u_int(buf.length);
        this.xdrout_opaque(buf);
    }
}

