/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.rpc;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import sunw.jdt.cal.rpc.dg_server_thread;
import sunw.jdt.cal.rpc.portmapper;
import sunw.jdt.cal.rpc.svc_upcall_priv;
import sunw.jdt.cal.rpc.xdr_dg;

public class rpc_server_dg
extends Thread {
    protected DatagramSocket anchor;
    protected static boolean trace = false;
    svc_upcall_priv msvc;

    public rpc_server_dg(long prog, long vers, svc_upcall_priv svc) throws IOException {
        this.msvc = svc;
        this.anchor = new DatagramSocket();
        rpc_server_dg.pm_register(prog, vers, this.anchor.getLocalPort());
    }

    public rpc_server_dg(long prog, long vers, svc_upcall_priv svc, int port) throws IOException {
        if (trace) {
            System.out.println("rpc_server_dg constructor with port# called");
            System.out.println("port = " + port);
        }
        this.msvc = svc;
        this.anchor = new DatagramSocket(port);
        if (trace) {
            System.out.println("port with datagramsocket = " + this.anchor.getLocalPort());
        }
    }

    private static void pm_register(long prog, long vers, int port) throws IOException {
        boolean reliable = false;
        if (trace) {
            System.out.println("rpc_server_dg: registering on port " + port);
        }
        portmapper pm = new portmapper();
        try {
            if (!pm.setport(prog, vers, reliable, port)) {
                throw new IOException("pm_register.setport: failed");
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            pm.close();
            throw throwable;
        }
        pm.close();
    }

    public void run() {
        try {
            while (true) {
                DatagramPacket pkt = new DatagramPacket(new byte[4096], 4096);
                this.anchor.receive(pkt);
                if (trace) {
                    System.out.println("rpc_server_dg: received packet");
                    System.out.println("length: " + pkt.getLength());
                }
                xdr_dg xdrs = new xdr_dg(pkt);
                dg_server_thread t = new dg_server_thread(xdrs, this.msvc);
                t.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

