/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.rpc;

import java.io.IOException;
import java.net.ServerSocket;
import sunw.jdt.cal.rpc.portmapper;
import sunw.jdt.cal.rpc.server_thread;
import sunw.jdt.cal.rpc.svc_upcall_priv;
import sunw.jdt.cal.rpc.xdr_vc;

public class rpc_server {
    protected static boolean trace = false;
    protected ServerSocket anchor;

    public rpc_server(long prog, long vers, svc_upcall_priv svc) throws IOException {
        this(prog, vers, svc, true);
    }

    public rpc_server(long prog, long vers, svc_upcall_priv svc, ServerSocket io) throws IOException {
        this.init(prog, vers, svc, io, false);
    }

    public rpc_server(long prog, long vers, svc_upcall_priv svc, boolean register) throws IOException {
        ServerSocket io = new ServerSocket(0);
        try {
            this.init(prog, vers, svc, io, register);
        }
        catch (IOException e) {
            try {
                io.close();
            }
            catch (IOException iOException) {}
            throw e;
        }
    }

    public synchronized long get_local_port() {
        return this.anchor.getLocalPort();
    }

    protected void init(long prog, long vers, svc_upcall_priv svc, ServerSocket io, boolean register) throws IOException {
        boolean reliable = true;
        this.anchor = io;
        if (register) {
            rpc_server.pm_register(prog, vers, this.anchor.getLocalPort(), reliable);
        }
        while (true) {
            xdr_vc xdrs = new xdr_vc(this.anchor.accept());
            server_thread t = new server_thread(xdrs, svc);
            t.start();
        }
    }

    private static void pm_register(long prog, long vers, int port, boolean reliable) throws IOException {
        if (trace) {
            System.err.println("registering on port " + port);
        }
        portmapper pm = new portmapper();
        try {
            pm.unsetport(prog, vers, reliable);
            if (!pm.setport(prog, vers, reliable, port)) {
                throw new IOException("register.setport: failed");
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            pm.close();
            throw throwable;
        }
        pm.close();
    }
}

