/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.rpc;

import java.io.IOException;
import sunw.jdt.cal.csa.AuthUser;
import sunw.jdt.cal.rpc.HardErrorException;
import sunw.jdt.cal.rpc.MsgDeniedException;
import sunw.jdt.cal.rpc.authsys_params;
import sunw.jdt.cal.rpc.call_body;
import sunw.jdt.cal.rpc.msg_type;
import sunw.jdt.cal.rpc.opaque_auth;
import sunw.jdt.cal.rpc.reply_body_u;
import sunw.jdt.cal.rpc.rpc_msg;
import sunw.jdt.cal.rpc.rpc_msg_u;
import sunw.jdt.cal.rpc.xdr_basic;
import sunw.jdt.cal.rpc.xdrin_upcall;
import sunw.jdt.cal.rpc.xdrout_upcall;
import sunw.jdt.cal.util.Debug;

public abstract class rpc_client {
    static final int RPC_MSG_VERSION = 2;
    static boolean trace = false;
    static boolean trace_close = false;
    private boolean close_called = false;
    protected rpc_msg call_msg = null;
    protected opaque_auth cred;
    protected opaque_auth verf;
    protected int security;
    private boolean my_xdrs;
    protected xdr_basic xdrs;
    private static long xid_seed;

    static {
        long val = System.currentTimeMillis();
        xid_seed = val | val * 1000L;
    }

    protected rpc_client(int sec) throws IOException {
        this(sec, null);
    }

    protected rpc_client(int sec, AuthUser authUser) throws IOException {
        switch (sec) {
            case 0: {
                this.cred = new opaque_auth(0);
                this.verf = new opaque_auth(0);
                break;
            }
            case 1: {
                this.cred = new opaque_auth(1);
                this.cred.auth = xdr_basic.xdrmem_xdrbytes(new authsys_params(authUser));
                this.verf = new opaque_auth(0);
                break;
            }
            default: {
                throw new IOException(String.valueOf(this.getClass().getName()) + ": bad security level");
            }
        }
        this.security = sec;
        if (trace || Debug.on) {
            System.err.println("security set to " + sec);
        }
        this.my_xdrs = false;
        this.xdrs = null;
    }

    public synchronized void cleanup() {
        try {
            this.close();
        }
        catch (IOException iOException) {}
    }

    public abstract void clnt_call(int var1, xdrout_upcall var2, xdrin_upcall var3) throws IOException;

    public synchronized void close() throws IOException {
        this.close_called = true;
        if (this.my_xdrs) {
            if (trace_close || Debug.on) {
                System.err.println("rpc_client: closing xdrs");
            }
            this.xdrs.close();
        }
        this.xdrs = null;
    }

    protected void conninit(xdr_basic xdrs_arg, boolean my_xdrs_arg, long prog, long vers) {
        this.call_msg = new rpc_msg();
        this.call_msg.ru = new rpc_msg_u();
        this.call_msg.ru.rm_direction = new msg_type();
        msg_type cfr_ignored_0 = this.call_msg.ru.rm_direction;
        this.call_msg.ru.rm_direction.value = 0;
        this.call_msg.ru.rm_direction__rm_cmb = new call_body();
        this.call_msg.ru.rm_direction__rm_cmb.cb_rpcvers = 2L;
        this.call_msg.ru.rm_direction__rm_cmb.cb_prog = prog;
        this.call_msg.ru.rm_direction__rm_cmb.cb_vers = vers;
        this.call_msg.ru.rm_direction__rm_cmb.cb_cred = this.cred;
        this.call_msg.ru.rm_direction__rm_cmb.cb_verf = this.verf;
        this.xdrs = xdrs_arg;
        this.my_xdrs = my_xdrs_arg;
    }

    public synchronized boolean get_assert_full_frame() {
        return this.xdrs.get_assert_full_frame();
    }

    protected static rpc_msg get_rply(xdr_basic xdrs, long call_xid) throws IOException {
        rpc_msg msg;
        block22: {
            block18: while (true) {
                msg = new rpc_msg(xdrs);
                if (trace) {
                    System.err.println("rpc_msg.xdrin: [0] got XID " + msg.rm_xid);
                    System.err.println("rpc_msg.xdrin: [1] got direction " + msg.ru.rm_direction.value);
                    System.err.println("rpc_msg.xdrin: [2] got rp_stat " + msg.ru.rm_direction__rm_rmb.rp_stat.value);
                }
                switch (msg.ru.rm_direction.value) {
                    case 0: {
                        System.err.println("clnt_call: callback not supported");
                        break;
                    }
                    default: {
                        System.err.println("clnt_call: bogus rm_directon");
                        continue block18;
                    }
                    case 1: 
                }
                if (msg.rm_xid == call_xid) break;
            }
            reply_body_u rmb = msg.ru.rm_direction__rm_rmb;
            switch (rmb.rp_stat.value) {
                case 1: {
                    if (trace) {
                        System.err.println("rj_stat = " + rmb.rp_stat__rp_dr.rj_stat.value);
                        switch (rmb.rp_stat__rp_dr.rj_stat.value) {
                            case 0: {
                                System.err.println("RPC_MISMATCH: vers = " + rmb.rp_stat__rp_dr.rj_stat__rj_version.low + ".." + rmb.rp_stat__rp_dr.rj_stat__rj_version.high);
                                break;
                            }
                            case 1: {
                                System.err.println("AUTH_ERROR: why = " + rmb.rp_stat__rp_dr.rj_stat__rj_why.value);
                                break;
                            }
                        }
                    }
                    throw new MsgDeniedException("rj_stat = " + rmb.rp_stat__rp_dr.rj_stat.value);
                }
                default: {
                    throw new HardErrorException("unknown rp_stat");
                }
                case 0: 
            }
            if (trace) {
                System.err.println("rpc_msg.xdrin: [3] got auth_flavor " + rmb.rp_stat__rp_ar.ar_verf.auth_flavor.value);
            }
            switch (rmb.rp_stat__rp_ar.ar_u.ar_stat.value) {
                case 1: {
                    throw new HardErrorException("PROG_UNAVAIL");
                }
                case 2: {
                    throw new HardErrorException("PROG_MISMATCH");
                }
                case 4: {
                    throw new HardErrorException("GARBAGE_ARGS");
                }
                default: {
                    System.err.println("rpc_msg.xdrin: ar_stat " + rmb.rp_stat__rp_ar.ar_u.ar_stat);
                    throw new HardErrorException("unknown ar_stat");
                }
                case 0: 
            }
            if (!trace) break block22;
            System.err.println("get_rply: got XID " + msg.rm_xid);
        }
        return msg;
    }

    protected static synchronized long next_xid() {
        ++xid_seed;
        return xid_seed &= 0xFFFFFFFFL;
    }

    public synchronized void set_assert_full_frame(boolean tf) {
        this.xdrs.set_assert_full_frame(tf);
    }
}

