/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.rpc;

import java.io.IOException;
import sunw.jdt.cal.rpc.PMapSvc;
import sunw.jdt.cal.rpc.ProgNotRegException;
import sunw.jdt.cal.rpc.clnt_service;
import sunw.jdt.cal.rpc.dump_ins;
import sunw.jdt.cal.rpc.dump_outs;
import sunw.jdt.cal.rpc.getport_outs;
import sunw.jdt.cal.rpc.gsport_ins;
import sunw.jdt.cal.rpc.pmapent;
import sunw.jdt.cal.rpc.rpc_client;
import sunw.jdt.cal.rpc.rpc_client_dg;
import sunw.jdt.cal.rpc.rpc_client_vc;
import sunw.jdt.cal.rpc.setport_outs;

public class portmapper
extends clnt_service {
    static final int PMAPPORT = 111;
    static final int PROC_NULL = 0;
    static final int PROC_SETPORT = 1;
    static final int PROC_UNSETPORT = 2;
    static final int PROC_GETPORT = 3;
    static final int PROC_DUMP = 4;
    static final int PMAP_IPPROTO_TCP = 6;
    static final int PMAP_IPPROTO_UDP = 17;
    static final boolean trace = false;
    static final int PMAP_PROG = 100000;
    static final int PMAP_VERS = 2;

    public portmapper() throws IOException {
        this("localhost", false);
        try {
            new PMapSvc();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public portmapper(String server, boolean use_stream) throws IOException {
        rpc_client c0 = use_stream ? new rpc_client_vc(server, 111, 100000L, 2L, 0) : new rpc_client_dg(server, 111, 100000L, 2L, 0, null);
        this.conninit(c0, true);
    }

    public pmapent[] dump() throws IOException {
        dump_ins ins = new dump_ins();
        dump_outs outs = new dump_outs();
        this.conn.clnt_call(4, ins, outs);
        return outs.pmlist;
    }

    public int getport(long prog, long vers, boolean reliable) throws IOException {
        int proto = reliable ? 6 : 17;
        gsport_ins ins = new gsport_ins(prog, vers, proto, 0L);
        getport_outs outs = new getport_outs();
        this.conn.clnt_call(3, ins, outs);
        if (outs.val == 0L) {
            throw new ProgNotRegException("program " + prog + "." + vers + " not registered");
        }
        return (int)outs.val;
    }

    public boolean setport(long prog, long vers, boolean reliable, long port) throws IOException {
        int proto = reliable ? 6 : 17;
        gsport_ins ins = new gsport_ins(prog, vers, proto, port);
        setport_outs outs = new setport_outs();
        this.conn.clnt_call(1, ins, outs);
        return outs.val;
    }

    public boolean unsetport(long prog, long vers, boolean reliable) throws IOException {
        int proto = reliable ? 6 : 17;
        gsport_ins ins = new gsport_ins(prog, vers, proto, 0L);
        setport_outs outs = new setport_outs();
        this.conn.clnt_call(2, ins, outs);
        return outs.val;
    }
}

