/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.rpc;

import java.io.IOException;
import java.net.InetAddress;
import sunw.jdt.cal.csa.AuthUser;
import sunw.jdt.cal.rpc.gid_t;
import sunw.jdt.cal.rpc.uid_t;
import sunw.jdt.cal.rpc.xdr_basic;
import sunw.jdt.cal.rpc.xdr_upcall;
import sunw.jdt.cal.util.Debug;

class authsys_params
implements xdr_upcall {
    long aup_time;
    String aup_machname;
    uid_t aup_uid;
    gid_t aup_gid;
    gid_t[] aup_gids;
    boolean trace = false;

    authsys_params() {
        this(null);
    }

    authsys_params(int uid, int gid) {
        this.init(uid, gid);
    }

    authsys_params(AuthUser authUser) {
        this.init(authUser.getUid(), authUser.getGid());
    }

    private void init(int uid, int gid) {
        String host;
        if (Debug.on) {
            System.err.println("+++HJV: uid = " + uid);
            System.err.println("+++HJV: gid = " + gid);
        }
        try {
            host = InetAddress.getLocalHost().getHostName();
            if (this.trace || Debug.on) {
                System.err.println("**** got host name " + host);
            }
        }
        catch (Exception e) {
            System.err.println("**** can't get host name");
            System.err.println(e);
            host = "bogus";
        }
        this.aup_time = System.currentTimeMillis() / 1000L;
        this.aup_machname = host;
        this.aup_uid = new uid_t(uid);
        this.aup_gid = new gid_t(gid);
        this.aup_gids = new gid_t[0];
    }

    public void xdrin(xdr_basic xdrs) throws IOException {
        throw new IOException(String.valueOf(this.getClass().getName()) + ".xdrin: unimplemented");
    }

    public void xdrout(xdr_basic xdrs) throws IOException {
        xdrs.xdrout_u_long(this.aup_time);
        xdrs.xdrout_string(this.aup_machname);
        this.aup_uid.xdrout(xdrs);
        this.aup_gid.xdrout(xdrs);
        xdrs.xdrout_array(this.aup_gids);
    }
}

