/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.rpc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import sunw.jdt.cal.util.Debug;

class ReadThread
extends Thread {
    protected static boolean trace = false;
    private Object waiting;
    private byte[] inbuffer;
    private InputStream istream = null;
    private DatagramSocket msocket = null;
    private byte[] inbuf;
    private boolean hangup = false;
    private IOException read_exception = null;
    private Object read_lock = new Object();
    private boolean producer_waiting = false;
    private boolean consumer_waiting = false;

    ReadThread(Object obj, InputStream s) {
        super("xdr_dg.ReadThread");
        this.istream = s;
        this.init(obj);
    }

    ReadThread(Object obj, DatagramSocket s) {
        super("xdr_dg.ReadThread");
        this.msocket = s;
        this.init(obj);
    }

    public synchronized void closeit() {
        if (trace || Debug.on) {
            System.out.println(String.valueOf(this.getClass().getName()) + ".closeit: call");
        }
        this.hangup = true;
        Object object = this.read_lock;
        synchronized (object) {
            if (this.producer_waiting) {
                if (trace || Debug.on) {
                    System.out.println(String.valueOf(this.getClass().getName()) + ".close: notify producer");
                }
                this.read_lock.notify();
            }
        }
    }

    protected synchronized void do_hangup() {
        if (trace) {
            System.out.println(String.valueOf(this.getClass().getName()) + ".do_hangup: closing fd");
        }
        if (this.istream != null) {
            try {
                this.istream.close();
                this.istream = null;
            }
            catch (IOException iOException) {}
        }
        Object object = this.read_lock;
        synchronized (object) {
            if (this.consumer_waiting) {
                if (trace) {
                    System.out.println("NOTIFY consumer (from do_hangup)");
                }
                this.read_lock.notify();
            }
        }
        this.stop();
    }

    protected synchronized byte[] get() {
        byte[] buf = this.inbuffer;
        this.inbuffer = null;
        return buf;
    }

    public byte[] get_or_wait(long msecs) throws IOException {
        Object object = this.read_lock;
        synchronized (object) {
            block10: {
                if (this.producer_waiting) {
                    if (trace || Debug.on) {
                        System.out.println("NOTIFY reader (producer) by consumer");
                    }
                    this.read_lock.notify();
                }
                this.consumer_waiting = true;
                try {
                    if (trace || Debug.on) {
                        System.out.println("WAIT on read_lock (producer) by consumer -- wait for data");
                    }
                    this.read_lock.wait(msecs);
                }
                catch (InterruptedException interruptedException) {
                    if (!trace && !Debug.on) break block10;
                    System.out.println("WAIT interrupted (consumer)");
                }
            }
            if (trace || Debug.on) {
                System.out.println("WAIT complete (consumer)");
            }
            this.consumer_waiting = false;
        }
        if (this.read_exception != null) {
            throw this.read_exception;
        }
        return this.get();
    }

    void init(Object obj) {
        this.setDaemon(true);
        this.waiting = obj;
        this.inbuffer = null;
        this.inbuf = new byte[9000];
    }

    public void run() {
        if (trace || Debug.on) {
            System.out.println(String.valueOf(this.getClass().getName()) + ".run: call");
        }
        while (true) {
            int payload;
            Object object = this.read_lock;
            synchronized (object) {
                if (!this.consumer_waiting) {
                    this.producer_waiting = true;
                    try {
                        if (trace || Debug.on) {
                            System.out.println("WAIT on read_lock (producer) -- no consumer");
                        }
                        this.read_lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        this.producer_waiting = false;
                        this.do_hangup();
                    }
                    this.producer_waiting = false;
                }
            }
            object = this;
            synchronized (object) {
                if (this.hangup) {
                    this.do_hangup();
                }
            }
            try {
                if (this.istream == null && this.msocket != null) {
                    Debug.print("xdr_dg:ReadThread:istream is null, get one from msocket");
                    DatagramPacket pkt = new DatagramPacket(new byte[4096], 4096);
                    this.msocket.receive(pkt);
                    this.istream = new ByteArrayInputStream(pkt.getData(), 0, pkt.getLength());
                    if (Debug.on) {
                        System.err.println("Data Length = " + pkt.getLength());
                    }
                }
                if (this.istream == null) {
                    Debug.print("xdr_dg:ReadThread:istream is null before read");
                }
                payload = this.istream.read(this.inbuf);
                try {
                    this.istream.close();
                }
                catch (IOException iOException) {}
                this.istream = null;
            }
            catch (IOException e) {
                if (trace) {
                    System.out.println(String.valueOf(this.getClass().getName()) + ".run: read error");
                    e.printStackTrace();
                }
                ReadThread readThread = this;
                synchronized (readThread) {
                    this.read_exception = e;
                    payload = 0;
                    this.do_hangup();
                }
            }
            if (trace) {
                System.out.println(String.valueOf(this.getClass().getName()) + ".run: read " + payload + " bytes");
            }
            ReadThread e = this;
            synchronized (e) {
                if (this.hangup) {
                    this.do_hangup();
                }
            }
            if (payload < 0) {
                System.out.println(String.valueOf(this.getClass().getName()) + ".run: read EOF");
                this.do_hangup();
            }
            if (payload == 0) {
                System.out.println(String.valueOf(this.getClass().getName()) + ".run: read 0 bytes");
                this.do_hangup();
            }
            byte[] tbuf = new byte[payload];
            System.arraycopy(this.inbuf, 0, tbuf, 0, tbuf.length);
            if (trace || Debug.on) {
                System.out.print(String.valueOf(this.getClass().getName()) + ".run: read ");
                System.out.println(String.valueOf(tbuf.length) + " data bytes:");
                int i = 0;
                while (i < payload) {
                    int val = tbuf[i] & 0xFF;
                    System.out.print(String.valueOf(val) + " ");
                    ++i;
                }
                System.out.println("");
            }
            Object i = this;
            synchronized (i) {
                this.inbuffer = tbuf;
            }
            i = this.read_lock;
            synchronized (i) {
                if (trace || Debug.on) {
                    System.out.println("NOTIFY read_lock (consumer) by producer -- data read");
                }
                this.read_lock.notify();
            }
        }
    }
}

