/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.csa;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import sunw.jdt.cal.cmsd5.cms_attr_name;
import sunw.jdt.cal.cmsd5.cms_attribute;
import sunw.jdt.cal.cmsd5.cms_create_args;
import sunw.jdt.cal.cmsd5.cms_delete_args;
import sunw.jdt.cal.cmsd5.cms_entries_res;
import sunw.jdt.cal.cmsd5.cms_entry;
import sunw.jdt.cal.cmsd5.cms_entry_res;
import sunw.jdt.cal.cmsd5.cms_get_cal_attr_args;
import sunw.jdt.cal.cmsd5.cms_get_cal_attr_res;
import sunw.jdt.cal.cmsd5.cms_insert_args;
import sunw.jdt.cal.cmsd5.cms_key;
import sunw.jdt.cal.cmsd5.cms_lookup_entries_args;
import sunw.jdt.cal.cmsd5.cms_open_args;
import sunw.jdt.cal.cmsd5.cms_open_res;
import sunw.jdt.cal.cmsd5.cms_reminder_args;
import sunw.jdt.cal.cmsd5.cms_reminder_ref;
import sunw.jdt.cal.cmsd5.cms_reminder_res;
import sunw.jdt.cal.cmsd5.cms_return_code;
import sunw.jdt.cal.cmsd5.cms_set_cal_attr_args;
import sunw.jdt.cal.cmsd5.cms_update_args;
import sunw.jdt.cal.cmsd5.int32;
import sunw.jdt.cal.csa.AccessListValue;
import sunw.jdt.cal.csa.AccessRights;
import sunw.jdt.cal.csa.Appointment;
import sunw.jdt.cal.csa.Attribute;
import sunw.jdt.cal.csa.AttributeValue;
import sunw.jdt.cal.csa.Calendar;
import sunw.jdt.cal.csa.CalendarConnection;
import sunw.jdt.cal.csa.CalendarException;
import sunw.jdt.cal.csa.Connection;
import sunw.jdt.cal.csa.CsaAccessEntry;
import sunw.jdt.cal.csa.CsaReturnCode;
import sunw.jdt.cal.csa.DateTimeValue;
import sunw.jdt.cal.csa.Entry;
import sunw.jdt.cal.csa.EntryAttribute;
import sunw.jdt.cal.csa.LocaleXlateTable;
import sunw.jdt.cal.csa.LookupCriteria;
import sunw.jdt.cal.csa.OpaqueData;
import sunw.jdt.cal.csa.OpaqueDataValue;
import sunw.jdt.cal.csa.ReminderRef;
import sunw.jdt.cal.csa.Scope;
import sunw.jdt.cal.csa.StringValue;
import sunw.jdt.cal.csa.Uint32Value;
import sunw.jdt.cal.csa.Util;
import sunw.jdt.cal.rpc.Buffer;
import sunw.jdt.cal.util.Debug;

class V5Connection
extends CalendarConnection {
    static final int _GETID = 0;
    static final int _GETUSER = 1;
    static final int _GETDESC = 2;
    String calname;

    V5Connection(Connection conn, Calendar calendar) throws CalendarException {
        this.mconn = conn;
        this.mcal = calendar;
        this.calname = calendar.getName();
    }

    void checkReturnCode(cms_return_code stat) throws CalendarException {
        if (stat.data != 0L) {
            throw CsaReturnCode.toCalendarException((int)stat.data);
        }
    }

    Entry[] convertEntries(cms_entry cmsEntries) {
        if (cmsEntries == null) {
            return null;
        }
        Vector<Entry> ve = new Vector<Entry>(1);
        while (cmsEntries != null) {
            Entry e = new Entry(this.mcal, cmsEntries);
            ve.addElement(e);
            cmsEntries = cmsEntries.next;
        }
        Object[] entries = new Entry[ve.size()];
        ve.copyInto(entries);
        return entries;
    }

    public void createCalendar() throws CalendarException {
        cms_create_args args = new cms_create_args();
        cms_return_code res = new cms_return_code();
        args.cal = new Buffer(this.calname);
        args.char_set = new Buffer(LocaleXlateTable.getCDELocale(this.mcal.mLocale));
        args.pid = new int32(2);
        args.attrs = new cms_attribute[0];
        try {
            if (this.mconn.svc5.CMS_CREATE_CALENDAR(args, res)) {
                this.registerCallback();
            }
            this.checkReturnCode(res);
        }
        catch (CalendarException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleException(e);
            throw new CalendarException(10, "CMS_CREATE_CALENDAR failed");
        }
    }

    public void deleteEntry(Appointment a, Scope scope) throws CalendarException {
        if (this.mconn.svc5 == null) {
            throw new CalendarException(10);
        }
        this.deleteEntry(a.mentry, scope);
    }

    void deleteEntry(Entry entry, Scope scope) throws CalendarException {
        cms_return_code res = new cms_return_code();
        cms_delete_args args = new cms_delete_args();
        args.cal = new Buffer(this.calname);
        args.pid = new int32(2);
        args.entry = new cms_key(entry.mtime, entry.mid);
        args.scope = new int32(scope.getValue());
        try {
            if (this.mconn.svc5.CMS_DELETE_ENTRY(args, res)) {
                this.registerCallback();
            }
            this.checkReturnCode(res);
        }
        catch (CalendarException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleException(e);
            throw new CalendarException(10, "CMS_DELETE_ENTRY failed");
        }
    }

    CsaAccessEntry[] fixAccessList(CsaAccessEntry[] entries, String userInfo) {
        if (this.mdataVersion < 4) {
            int i = 0;
            while (i < entries.length) {
                entries[i].useCSAModel(false);
                ++i;
            }
            return entries;
        }
        if (userInfo != null && userInfo.length() != 0) {
            StringTokenizer st = new StringTokenizer(userInfo, ":");
            String id = null;
            String user = null;
            String desc = null;
            int what = 0;
            if (Debug.on) {
                System.out.println("** userinfo =" + userInfo);
            }
            while (st.hasMoreElements()) {
                String next = st.nextToken();
                switch (what) {
                    case 0: {
                        id = next;
                        what = 1;
                        break;
                    }
                    case 1: {
                        user = next;
                        what = 2;
                        break;
                    }
                    case 2: {
                        desc = next;
                        what = 0;
                        int i = 0;
                        while (i < entries.length) {
                            if (user.equals(Util.getUserFromAddr(entries[i].getUser()))) {
                                entries[i].setId(id);
                                entries[i].setDesc(desc);
                            }
                            ++i;
                        }
                        what = 0;
                        break;
                    }
                }
            }
            if (what != 0) {
                Debug.print("** userinfo has bad format");
            }
        }
        return entries;
    }

    public CsaAccessEntry[] getAccessList() throws CalendarException {
        if (this.mconn.svc5 == null) {
            throw new CalendarException(10);
        }
        String[] names = new String[2];
        CsaAccessEntry[] accessEntries = null;
        String userInfo = null;
        names[0] = "-//XAPIA/CSA/CALATTR//NONSGML Access List//EN";
        names[1] = "-//SUNW_XAPIA_PRIVATE/CSA/CALATTR//NONSGML Access List Info//EN";
        Attribute[] attrs = this.getCalAttrs(names);
        if (attrs == null || attrs.length == 0) {
            return null;
        }
        int i = 0;
        while (i < attrs.length) {
            if (attrs[i].getName().equals("-//XAPIA/CSA/CALATTR//NONSGML Access List//EN")) {
                accessEntries = ((AccessListValue)attrs[i].getValue()).getAccessEntries();
            } else {
                userInfo = ((StringValue)attrs[i].getValue()).getString();
            }
            ++i;
        }
        if (accessEntries == null) {
            return null;
        }
        return this.fixAccessList(accessEntries, userInfo);
    }

    public Attribute[] getCalAttrs(String[] names) throws CalendarException {
        cms_get_cal_attr_res res = new cms_get_cal_attr_res();
        cms_get_cal_attr_args args = new cms_get_cal_attr_args();
        args.cal = new Buffer(this.calname);
        args.names = new cms_attr_name[names.length];
        int i = 0;
        while (i < names.length) {
            args.names[i] = new cms_attr_name();
            args.names[i].num = 0;
            args.names[i].name = new Buffer(names[i]);
            ++i;
        }
        try {
            if (this.mconn.svc5.CMS_GET_CALENDAR_ATTR(args, res)) {
                this.registerCallback();
            }
            this.checkReturnCode(res.stat);
            return Attribute.toAttributes(res.attrs);
        }
        catch (CalendarException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new CalendarException(10, "CMS_GET_CALENDAR_ATTR failed");
        }
    }

    cms_reminder_ref getCmsReminder(Date time, String[] names) throws CalendarException {
        int i;
        cms_reminder_res res = new cms_reminder_res();
        cms_reminder_args args = new cms_reminder_args();
        args.cal = new Buffer(this.calname);
        long secs = time.getTime() / 1000L;
        args.tick = new int32((int)secs);
        if (names != null) {
            args.names = new cms_attr_name[names.length];
            i = 0;
            while (i < names.length) {
                args.names[i] = new cms_attr_name();
                args.names[i].num = 0;
                args.names[i].name = new Buffer(names[i]);
                ++i;
            }
        } else {
            args.names = new cms_attr_name[0];
        }
        if (Debug.on) {
            System.out.println("\n(getReminder_v5):");
            System.out.println("date = " + time + "(" + time.getTime() / 1000L + ")");
            System.out.println("args.tick = " + secs);
            System.out.println("names (" + args.names.length + ")");
            if (args.names.length > 0) {
                i = 0;
                while (i < args.names.length) {
                    System.out.println(args.names[i].name.val);
                    ++i;
                }
            }
        }
        try {
            if (this.mconn.svc5.CMS_LOOKUP_REMINDER(args, res)) {
                this.registerCallback();
            }
            this.checkReturnCode(res.stat);
            if (Debug.on) {
                if (res.rems == null) {
                    System.out.println("no reminders returned from server");
                } else {
                    int i2 = 1;
                    cms_reminder_ref ptr = res.rems;
                    while (ptr != null) {
                        System.out.println("Reminder #" + i2);
                        System.out.println("attr name = " + ptr.reminder_name.val);
                        System.out.println("entryid = " + ptr.entryid.val);
                        System.out.println("cms_key.time = " + ptr.key.time.data);
                        System.out.println("cms_key.id = " + ptr.key.id.data);
                        System.out.println("runtime = " + ptr.runtime.data);
                        ptr = ptr.next;
                        ++i2;
                    }
                }
            }
            return res.rems;
        }
        catch (CalendarException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new CalendarException(10, "CMS_LOOKUP_REMINDER failed");
        }
    }

    public ReminderRef[] getReminder(Date time, String[] names) throws CalendarException {
        if (this.mconn.svc5 == null) {
            throw new CalendarException(10);
        }
        cms_reminder_ref remf;
        while ((remf = this.getCmsReminder(time, names)) != null) {
            ReminderRef[] rems = this.toReminderRef(remf);
            if (rems != null) {
                return rems;
            }
            time = new Date((long)remf.runtime.data * 1000L);
        }
        return null;
    }

    public Appointment insertEntry(Appointment appt) throws CalendarException {
        if (this.mconn.svc5 == null) {
            throw new CalendarException(10);
        }
        appt.prepareForInsert();
        Entry e = this.insertEntry(appt.mentry);
        if (e != null) {
            return new Appointment(e);
        }
        return null;
    }

    Entry insertEntry(Entry entry) throws CalendarException {
        cms_entry_res res = new cms_entry_res();
        cms_insert_args args = new cms_insert_args();
        args.cal = new Buffer(this.calname);
        args.pid = new int32(2);
        args.attrs = entry.getCmsAttrsForInsert(this.mdataVersion);
        if (Debug.on) {
            System.out.println("\n(insertEntry)attributes to be inserted:");
            int i = 0;
            while (i < args.attrs.length) {
                args.attrs[i].print();
                ++i;
            }
        }
        try {
            if (this.mconn.svc5.CMS_INSERT_ENTRY(args, res)) {
                this.registerCallback();
            }
            this.checkReturnCode(res.stat);
            return new Entry(this.mcal, res.entry);
        }
        catch (CalendarException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleException(e);
            throw new CalendarException(10, "CMS_INSERT_ENTRY failed");
        }
    }

    Appointment[] lookup(LookupCriteria lc) throws CalendarException {
        int i;
        cms_entries_res res = new cms_entries_res();
        cms_lookup_entries_args args = new cms_lookup_entries_args();
        args.cal = new Buffer(this.calname);
        args.char_set = new Buffer("");
        int size = lc != null ? lc.getSize() : 0;
        args.attrs = new cms_attribute[size];
        args.ops = new int32[size];
        if (lc != null) {
            Enumeration lcops = lc.getOps();
            Enumeration lcattrs = lc.getAttrs();
            i = 0;
            while (lcops.hasMoreElements()) {
                args.ops[i] = new int32((Integer)lcops.nextElement());
                args.attrs[i] = ((Attribute)lcattrs.nextElement()).toCmsAttribute();
                ++i;
            }
        }
        if (Debug.on) {
            System.out.println("cal=" + args.cal.val);
            System.out.println("charset=" + args.char_set.val);
            if (size > 0) {
                i = 0;
                while (i < args.ops.length) {
                    System.out.println("op=" + args.ops[i].data);
                    args.attrs[i].print();
                    ++i;
                }
            }
        }
        try {
            if (this.mconn.svc5.CMS_LOOKUP_ENTRIES(args, res)) {
                this.registerCallback();
            }
            this.checkReturnCode(res.stat);
            return Appointment.toAppointments(this.convertEntries(res.entries));
        }
        catch (CalendarException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new CalendarException(10, "CMS_LOOKUP_ENTRIES failed");
        }
    }

    public Appointment[] lookupEntries(LookupCriteria lc) throws CalendarException {
        if (this.mconn.svc5 == null) {
            throw new CalendarException(10);
        }
        return this.lookup(lc);
    }

    Attribute[] open() throws CalendarException {
        cms_open_res res = new cms_open_res();
        cms_open_args args = new cms_open_args();
        args.cal = new Buffer(this.calname);
        args.pid = new int32(2);
        try {
            if (this.mconn.svc5.CMS_OPEN_CALENDAR(args, res)) {
                this.registerCallback();
            }
            this.checkReturnCode(res.stat);
            if (res.user_access.data == 0L) {
                throw new CalendarException(3, "no authority");
            }
            this.mserverVersion = res.svr_vers;
            this.mdataVersion = res.file_vers;
            this.maccess = new AccessRights(res.user_access.data);
            if (this.mdataVersion < 4) {
                this.maccess.useCSAModel(false);
            }
            return Attribute.toAttributes(res.attrs);
        }
        catch (CalendarException e) {
            throw e;
        }
        catch (Exception e) {
            if (Debug.on) {
                System.out.println(e);
            }
            throw new CalendarException(10, "CMS_OPEN_CALENDAR failed");
        }
    }

    public Attribute[] openCalendar() throws CalendarException {
        if (this.mconn.svc5 == null) {
            throw new CalendarException(10);
        }
        return this.open();
    }

    public void setAccessList(CsaAccessEntry[] arr) throws CalendarException {
        Attribute[] attrs;
        if (this.mconn.svc5 == null) {
            throw new CalendarException(10);
        }
        StringBuffer buf = null;
        if (arr != null && this.mdataVersion >= 4) {
            attrs = new Attribute[2];
            buf = new StringBuffer(1);
            Hashtable<String, String> names = new Hashtable<String, String>();
            boolean first = true;
            int i = 0;
            while (i < arr.length) {
                String user;
                if (arr[i].getId() != null && arr[i].getId().length() > 0 && !names.containsKey(user = Util.getUserFromAddr(arr[i].getUser()))) {
                    names.put(user, user);
                    if (first) {
                        first = false;
                    } else {
                        buf.append(":");
                    }
                    buf.append(String.valueOf(arr[i].getId()) + ":" + user + ":" + arr[i].getDesc());
                }
                ++i;
            }
            attrs[1] = new Attribute("-//SUNW_XAPIA_PRIVATE/CSA/CALATTR//NONSGML Access List Info//EN", new StringValue(buf.length() > 0 ? buf.toString() : ""));
        } else {
            attrs = new Attribute[]{new Attribute("-//XAPIA/CSA/CALATTR//NONSGML Access List//EN", new AccessListValue(arr))};
        }
        if (Debug.on) {
            System.out.println("adding " + attrs.length + " attributes");
            if (attrs.length > 1) {
                System.out.println("info:\"" + buf + "\"");
            }
        }
        this.setCalAttrs(attrs);
    }

    public void setCalAttrs(Attribute[] attrs) throws CalendarException {
        cms_return_code res = new cms_return_code();
        cms_set_cal_attr_args args = new cms_set_cal_attr_args();
        args.cal = new Buffer(this.calname);
        args.pid = new int32(2);
        args.attrs = new cms_attribute[attrs.length];
        int i = 0;
        while (i < attrs.length) {
            args.attrs[i] = attrs[i].toCmsAttribute();
            ++i;
        }
        try {
            if (this.mconn.svc5.CMS_SET_CALENDAR_ATTR(args, res)) {
                this.registerCallback();
            }
            this.checkReturnCode(res);
        }
        catch (CalendarException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleException(e);
            throw new CalendarException(10, "CMS_SET_CALENDAR_ATTR failed");
        }
    }

    ReminderRef[] toReminderRef(cms_reminder_ref refs) throws CalendarException {
        Vector<ReminderRef> vf = new Vector<ReminderRef>(1);
        cms_reminder_ref ptr = refs;
        while (ptr != null) {
            cms_reminder_ref ptr2 = refs;
            while (ptr2 != ptr) {
                if (ptr.key.id.data == ptr2.key.id.data) break;
                ptr2 = ptr2.next;
            }
            if (ptr == ptr2) {
                LookupCriteria lc = new LookupCriteria();
                byte[] barry = ptr.entryid.val.getBytes();
                int len = barry.length;
                byte[] newarry = new byte[len + 1];
                int i = 0;
                while (i < len) {
                    newarry[i] = barry[i];
                    ++i;
                }
                newarry[len] = 0;
                lc.addCriterion(1, new Attribute("-//XAPIA/CSA/ENTRYATTR//NONSGML Reference Identifier//EN", new OpaqueDataValue(new OpaqueData(newarry))));
                lc.addCriterion(1, new Attribute("-//XAPIA/CSA/ENTRYATTR//NONSGML Start Date//EN", new DateTimeValue(new Date((long)ptr.key.time.data * 1000L))));
                lc.addCriterion(1, new Attribute("-//XAPIA/CSA/ENTRYATTR//NONSGML Type//EN", new Uint32Value(0L)));
                Appointment[] appts = this.lookupEntries(lc);
                if (Debug.on && appts == null) {
                    System.out.println("toReminderRef: no appt returned for id " + ptr.entryid.val);
                }
                if (appts != null && appts.length > 0) {
                    ReminderRef remRef = new ReminderRef((long)ptr.runtime.data * 1000L);
                    remRef.setAppointment(appts[0]);
                    vf.addElement(remRef);
                    appts[0] = null;
                }
            }
            ptr = ptr.next;
        }
        if (vf.size() > 0) {
            Object[] array = new ReminderRef[vf.size()];
            vf.copyInto(array);
            return array;
        }
        return null;
    }

    public Appointment updateEntry(Appointment a, Scope scope) throws CalendarException {
        if (this.mconn.svc5 == null) {
            throw new CalendarException(10);
        }
        a.prepareForUpdate();
        Entry e = this.updateEntry(a.mentry, scope);
        if (e != null) {
            if (a.getRepeat().repeats() && scope.getValue() == 0) {
                Date sdate = ((DateTimeValue)e.getAttribute(22).getValue()).getDate();
                Date newsdate = a.getStartDate();
                e.setAttribute(new EntryAttribute(22, (AttributeValue)new DateTimeValue(newsdate)), false);
                EntryAttribute attr = e.getAttribute(7);
                if (attr != null) {
                    Date edate = ((DateTimeValue)attr.getValue()).getDate();
                    Date newedate = new Date(newsdate.getTime() + (edate.getTime() - sdate.getTime()));
                    e.setAttribute(new EntryAttribute(7, (AttributeValue)new DateTimeValue(newedate)), false);
                }
            }
            return new Appointment(e);
        }
        return null;
    }

    Entry updateEntry(Entry entry, Scope scope) throws CalendarException {
        cms_entry_res res = new cms_entry_res();
        cms_update_args args = new cms_update_args();
        args.cal = new Buffer(this.calname);
        args.pid = new int32(2);
        args.entry = new cms_key(entry.mtime, entry.mid);
        args.scope = new int32(scope.getValue());
        args.attrs = entry.getCmsAttrsForUpdate(this.mdataVersion, scope);
        if (args.attrs == null) {
            if (Debug.on) {
                System.out.println("No attr to update");
            }
            return null;
        }
        if (Debug.on) {
            System.out.println("\n(updateEntry_v5)attributes to be updated:");
            int i = 0;
            while (i < args.attrs.length) {
                args.attrs[i].print();
                ++i;
            }
        }
        try {
            if (this.mconn.svc5.CMS_UPDATE_ENTRY(args, res)) {
                this.registerCallback();
            }
            this.checkReturnCode(res.stat);
            return new Entry(this.mcal, res.entry);
        }
        catch (CalendarException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleException(e);
            throw new CalendarException(10, "CMS_UPDATE_ENTRY failed");
        }
    }
}

