/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.csa;

import java.net.InetAddress;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import sunw.jdt.cal.cmsd4.Access_Args;
import sunw.jdt.cal.cmsd4.Access_Entry;
import sunw.jdt.cal.cmsd4.Access_Status;
import sunw.jdt.cal.cmsd4.Appt;
import sunw.jdt.cal.cmsd4.Apptid;
import sunw.jdt.cal.cmsd4.Id;
import sunw.jdt.cal.cmsd4.Options;
import sunw.jdt.cal.cmsd4.Range;
import sunw.jdt.cal.cmsd4.Table_Args;
import sunw.jdt.cal.cmsd4.Table_Args_Type;
import sunw.jdt.cal.cmsd4.Table_Op_Args;
import sunw.jdt.cal.cmsd4.Table_Res;
import sunw.jdt.cal.cmsd4.Table_Status;
import sunw.jdt.cal.cmsd4.Uid;
import sunw.jdt.cal.cmsd4.Uidopt;
import sunw.jdt.cal.cmsd4.V4Reminder;
import sunw.jdt.cal.csa.AccessRights;
import sunw.jdt.cal.csa.Appointment;
import sunw.jdt.cal.csa.Attribute;
import sunw.jdt.cal.csa.Calendar;
import sunw.jdt.cal.csa.CalendarConnection;
import sunw.jdt.cal.csa.CalendarException;
import sunw.jdt.cal.csa.Connection;
import sunw.jdt.cal.csa.CsaAccessEntry;
import sunw.jdt.cal.csa.CsaReturnCode;
import sunw.jdt.cal.csa.DateTimeValue;
import sunw.jdt.cal.csa.LookupCriteria;
import sunw.jdt.cal.csa.OWAppt;
import sunw.jdt.cal.csa.OpaqueDataValue;
import sunw.jdt.cal.csa.ReminderRef;
import sunw.jdt.cal.csa.Scope;
import sunw.jdt.cal.csa.StringValue;
import sunw.jdt.cal.csa.Uint32Value;
import sunw.jdt.cal.rpc.Buffer;

class V4Connection
extends CalendarConnection {
    String calname;

    V4Connection(Connection conn, Calendar calendar) throws CalendarException {
        this.mconn = conn;
        this.mcal = calendar;
        this.calname = calendar.getAddress();
    }

    void checkAccessStatus(Access_Status stat, boolean strict) throws CalendarException {
        if (stat.enum == 0) {
            return;
        }
        if (!strict && stat.enum == 3) {
            return;
        }
        switch (stat.enum) {
            case 3: {
                throw CsaReturnCode.toCalendarException(27);
            }
            case 6: {
                throw CsaReturnCode.toCalendarException(22);
            }
            case 4: {
                throw CsaReturnCode.toCalendarException(2);
            }
            case 7: {
                throw CsaReturnCode.toCalendarException(3);
            }
            case 8: {
                throw new CalendarException(23);
            }
        }
        throw new CalendarException(0);
    }

    void checkTableStatus(Table_Status stat) throws CalendarException {
        if (stat.value == 0) {
            return;
        }
        switch (stat.value) {
            case 4: 
            case 6: {
                throw CsaReturnCode.toCalendarException(27);
            }
            case 1: 
            case 7: {
                throw CsaReturnCode.toCalendarException(2);
            }
            case 3: {
                throw CsaReturnCode.toCalendarException(3);
            }
            case 8: {
                throw new CalendarException(23);
            }
        }
        throw new CalendarException(0);
    }

    public void createCalendar() throws CalendarException {
        if (this.mconn.svc4 == null) {
            throw new CalendarException(10);
        }
        Table_Op_Args args = new Table_Op_Args();
        Table_Status res = new Table_Status();
        args.target = new Buffer(this.calname);
        try {
            if (this.mconn.svc4.rtable_create(args, res)) {
                this.registerCallback();
            }
            this.checkTableStatus(res);
        }
        catch (CalendarException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new CalendarException(10, "rtable_create failed");
        }
    }

    void deleteAppt(Appt appt, Scope scope) throws CalendarException {
        Table_Res res = new Table_Res();
        Table_Args args = new Table_Args();
        args.target.val = this.calname;
        args.args.tag = new Table_Args_Type(6);
        args.args.uidopt = new Uidopt();
        args.args.uidopt.appt_id.tick = appt.appt_id.tick;
        args.args.uidopt.appt_id.key = appt.appt_id.key;
        args.args.uidopt.option.enum = scope.getValue();
        args.pid = 2;
        try {
            if (this.mconn.svc4.rtable_delete(args, res)) {
                this.registerCallback();
            }
            this.checkAccessStatus(res.status, true);
            if (res.res.a == null) {
                throw new CalendarException(29);
            }
        }
        catch (CalendarException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleException(e);
            throw new CalendarException(10, "rtable_delete failed");
        }
    }

    public void deleteEntry(Appointment a, Scope scope) throws CalendarException {
        if (this.mconn.svc4 == null) {
            throw new CalendarException(10);
        }
        if (!(a instanceof OWAppt)) {
            throw new CalendarException(0);
        }
        this.deleteAppt(((OWAppt)a).mappt, scope);
    }

    public CsaAccessEntry[] getAccessList() throws CalendarException {
        if (this.mconn.svc4 == null) {
            throw new CalendarException(10);
        }
        return this.toAccessEntry(this.getV4AccessList());
    }

    private int getEntryId(Attribute attr) {
        byte[] b = ((OpaqueDataValue)attr.getValue()).getOpaqueData().mbytes;
        String idstr = new String(b);
        int index = idstr.indexOf(":");
        return Integer.parseInt(idstr.substring(0, index));
    }

    public ReminderRef[] getReminder(Date time, String[] names) throws CalendarException {
        if (this.mconn.svc4 == null) {
            throw new CalendarException(10);
        }
        int tick = (int)(time.getTime() / 1000L);
        V4Reminder r;
        while ((r = this.lookupReminder((int)(time.getTime() / 1000L))) != null) {
            ReminderRef[] rems = this.toReminderRef(r, names);
            if (rems != null) {
                return rems;
            }
            tick = r.tick;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    AccessRights getUserAccess(Access_Entry ae) throws CalendarException {
        worlda = 0;
        userAta = 0;
        usera = 0;
        found = false;
        foundAt = false;
        if (ae != null) ** GOTO lbl19
        throw new CalendarException(3);
lbl-1000:
        // 1 sources

        {
            if (ae.who.val.equals("world")) {
                worlda = ae.access_type;
            } else if (this.isLocalUser(ae.who.val)) {
                found = true;
                if (ae.who.val.indexOf("@") > 0) {
                    foundAt = true;
                    userAta = ae.access_type;
                } else {
                    usera = ae.access_type;
                }
            }
            ae = ae.next;
lbl19:
            // 2 sources

            ** while (ae != null)
        }
lbl20:
        // 1 sources

        rights = found != false ? (long)(foundAt != false ? userAta : usera) : (long)worlda;
        if (rights == 0L) {
            throw new CalendarException(3);
        }
        access = new AccessRights(rights);
        access.useCSAModel(false);
        return access;
    }

    Access_Entry getV4AccessList() throws CalendarException {
        Access_Args res = new Access_Args();
        Access_Args args = new Access_Args();
        args.target = new Buffer(this.calname);
        try {
            if (this.mconn.svc4.rtable_get_access(args, res)) {
                this.registerCallback();
            }
            if (res.target == null || res.target.val == null || res.target.val.length() == 0) {
                throw new CalendarException(0, "Calendar protocol (version 4) error.");
            }
            return res.access_list;
        }
        catch (CalendarException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new CalendarException(10, "rtable_get_access failed");
        }
    }

    Appt insertAppt(Appt appt) throws CalendarException {
        Table_Res res = new Table_Res();
        Table_Args args = new Table_Args();
        args.target.val = this.calname;
        args.args.tag = new Table_Args_Type(3);
        args.args.appt = appt;
        args.pid = 2;
        try {
            if (this.mconn.svc4.rtable_insert(args, res)) {
                this.registerCallback();
            }
            this.checkAccessStatus(res.status, true);
            if (res.res.tag.enum != 0) {
                throw new CalendarException(0, "Unexpected data type returned");
            }
            return res.res.a;
        }
        catch (CalendarException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleException(e);
            throw new CalendarException(10, "rtable_insert failed");
        }
    }

    public Appointment insertEntry(Appointment appt) throws CalendarException {
        Appt newa;
        if (this.mconn.svc4 == null) {
            throw new CalendarException(10);
        }
        if (appt instanceof OWAppt) {
            newa = this.insertAppt(((OWAppt)appt).mappt);
        } else {
            Appt owappt = OWAppt.toAppt(appt);
            newa = this.insertAppt(owappt);
        }
        return new OWAppt(newa, this.mcal);
    }

    boolean isLocalUser(String guser) {
        String localhost;
        String username;
        try {
            username = System.getProperty("user.name", "nobody");
        }
        catch (Exception e) {
            e.printStackTrace();
            username = "nobody";
        }
        int index1 = guser.indexOf("@");
        String gname = index1 == -1 ? guser.substring(0) : guser.substring(0, index1);
        if (!username.equals(gname)) {
            return false;
        }
        if (index1 == -1) {
            return true;
        }
        try {
            localhost = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            e.printStackTrace();
            localhost = "localhost";
        }
        int index2 = guser.indexOf(".", index1 + 1);
        String ghost = index2 == -1 ? guser.substring(index1 + 1) : guser.substring(index1 + 1, index2);
        return ghost.equals(localhost);
    }

    Appointment[] lookup(LookupCriteria lc) throws CalendarException {
        Appt appts;
        Vector<Attribute> strings = null;
        Attribute id = null;
        Attribute type = null;
        long startdate = -1L;
        long start1 = -1L;
        long start2 = -1L;
        boolean needMatch = false;
        boolean matchExactDate = false;
        if (lc == null) {
            throw new CalendarException(14, "lookup criteria expected");
        }
        Enumeration lcops = lc.getOps();
        Enumeration lcattrs = lc.getAttrs();
        int i = 0;
        while (lcops.hasMoreElements()) {
            block20: {
                Attribute attr;
                block19: {
                    attr = (Attribute)lcattrs.nextElement();
                    int op = (Integer)lcops.nextElement();
                    if (!attr.getName().equals("-//XAPIA/CSA/ENTRYATTR//NONSGML Start Date//EN")) break block19;
                    startdate = ((DateTimeValue)attr.getValue()).getDate().getTime() / 1000L;
                    switch (op) {
                        case 1: {
                            matchExactDate = true;
                            start1 = startdate - 1L;
                            start2 = startdate + 1L;
                            break block20;
                        }
                        case 5: {
                            start1 = startdate - 1L;
                            break block20;
                        }
                        case 6: {
                            start2 = startdate + 1L;
                            break block20;
                        }
                        default: {
                            System.out.println("Operator " + op + " for START_DATE is not supported");
                            throw new CalendarException(23, "start date - operator not supported");
                        }
                    }
                }
                if (attr.getName().equals("-//XAPIA/CSA/ENTRYATTR//NONSGML Type//EN")) {
                    type = attr;
                    needMatch = true;
                } else if (attr.getName().equals("-//XAPIA/CSA/ENTRYATTR//NONSGML Reference Identifier//EN")) {
                    id = attr;
                    needMatch = true;
                } else if (attr.getName().equals("-//XAPIA/CSA/ENTRYATTR//NONSGML Summary//EN")) {
                    needMatch = true;
                    if (strings == null) {
                        strings = new Vector<Attribute>(1);
                    }
                    strings.addElement(attr);
                } else {
                    System.out.println("lookup by " + attr.getName() + " is not supported");
                    throw new CalendarException(23, "lookup by this attribute not supported");
                }
            }
            ++i;
        }
        if (startdate == -1L) {
            throw new CalendarException(23, "lookup without time range not supported");
        }
        if (id != null && matchExactDate) {
            Uid uid = new Uid();
            uid.appt_id.tick = (int)startdate;
            uid.appt_id.key = this.getEntryId(id);
            appts = this.lookupApptsByIds(uid, type);
        } else {
            appts = this.lookupAppts(start1, start2, id, type, strings);
        }
        if (appts == null) {
            System.out.println("V4Lookup: find no appts");
        } else {
            System.out.println("V4Lookup: find some appts");
        }
        return OWAppt.toAppointments(appts, this.mcal);
    }

    private Appt lookupAppts(long start1, long start2, Attribute id, Attribute type, Vector strings) throws CalendarException {
        Table_Res res = new Table_Res();
        Table_Args args = new Table_Args();
        args.target.val = this.calname;
        args.args.tag = new Table_Args_Type(4);
        args.args.range = new Range();
        args.args.range.key1 = (int)start1;
        args.args.range.key2 = (int)start2;
        args.args.range.next = null;
        try {
            if (this.mconn.svc4.rtable_lookup_range(args, res)) {
                this.registerCallback();
            }
            this.checkAccessStatus(res.status, false);
            if (res.res.tag.enum != 0) {
                throw new CalendarException(0, "Unexpected data type returned");
            }
            if (res.res.a == null) {
                return null;
            }
            return this.matchAppts(res.res.a, id, type, strings);
        }
        catch (CalendarException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new CalendarException(10, "rtable_lookup failed");
        }
    }

    Appt lookupApptsByIds(Uid uids, Attribute type) throws CalendarException {
        Table_Res res = new Table_Res();
        Table_Args args = new Table_Args();
        args.target.val = this.calname;
        args.args.tag = new Table_Args_Type(2);
        args.args.key = uids;
        try {
            if (this.mconn.svc4.rtable_lookup(args, res)) {
                this.registerCallback();
            }
            this.checkAccessStatus(res.status, false);
            if (res.res.tag.enum != 0) {
                throw new CalendarException(0, "Unexpected data type returned");
            }
            if (res.res.a == null) {
                return null;
            }
            if (type != null) {
                return this.matchAppts(res.res.a, null, type, null);
            }
            return res.res.a;
        }
        catch (CalendarException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new CalendarException(10, "rtable_lookup failed");
        }
    }

    public Appointment[] lookupEntries(LookupCriteria lc) throws CalendarException {
        if (this.mconn.svc4 == null) {
            throw new CalendarException(10);
        }
        return this.lookup(lc);
    }

    V4Reminder lookupReminder(int tick) throws CalendarException {
        Table_Res res = new Table_Res();
        Table_Args args = new Table_Args();
        args.target.val = this.calname;
        args.args.tag = new Table_Args_Type(0);
        args.args.tick = tick;
        args.pid = 2;
        try {
            if (this.mconn.svc4.rtable_lookup_next_reminder(args, res)) {
                this.registerCallback();
            }
            this.checkAccessStatus(res.status, true);
            if (res.res.tag.enum != 1) {
                throw new CalendarException(0, "Unexpected data type returned");
            }
            return res.res.r;
        }
        catch (CalendarException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new CalendarException(10, "rtable_lookup_next_reminder failed");
        }
    }

    Appt matchAppts(Appt appts, Attribute idAttr, Attribute typeAttr, Vector stringAttrs) {
        int i;
        int type = -1;
        int id = -1;
        int size = 0;
        String[] strings = null;
        Appt head = null;
        Appt freelist = null;
        Appt tail = null;
        if (typeAttr != null) {
            type = (int)((Uint32Value)typeAttr.getValue()).getLong();
        }
        if (idAttr != null) {
            id = this.getEntryId(idAttr);
        }
        if (stringAttrs != null) {
            size = stringAttrs.size();
            strings = new String[size];
            i = 0;
            while (i < size) {
                strings[i] = ((StringValue)((Attribute)stringAttrs.elementAt(i)).getValue()).getString();
                ++i;
            }
        }
        Appt aptr = appts;
        while (aptr != null) {
            Appt nptr = aptr.next;
            boolean match = true;
            if (typeAttr != null && aptr.tag.tag.enum != type || idAttr != null && aptr.appt_id.key != id) {
                match = false;
            }
            if (strings != null) {
                String what = aptr.what.val;
                i = 0;
                while (i < size) {
                    if (what == null || what.indexOf(strings[i]) == -1) {
                        match = false;
                        break;
                    }
                    ++i;
                }
            }
            if (match) {
                aptr.next = null;
                if (head == null) {
                    head = aptr;
                } else {
                    tail.next = aptr;
                }
                tail = aptr;
            } else {
                aptr.next = freelist;
                freelist = aptr;
            }
            aptr = nptr;
            aptr = nptr;
        }
        return head;
    }

    boolean matchNames(String val, String[] names) {
        String csaval = null;
        if (val.equals("bp")) {
            csaval = "-//XAPIA/CSA/ENTRYATTR//NONSGML Audio Reminder//EN";
        } else if (val.equals("ml")) {
            csaval = "-//XAPIA/CSA/ENTRYATTR//NONSGML Mail Reminder//EN";
        } else if (val.equals("fl")) {
            csaval = "-//XAPIA/CSA/ENTRYATTR//NONSGML Flashing Reminder//EN";
        } else if (val.equals("op")) {
            csaval = "-//XAPIA/CSA/ENTRYATTR//NONSGML Popup Reminder//EN";
        }
        int i = 0;
        while (i < names.length) {
            if (csaval.equals(names[i]) && names[i].equals(csaval)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    V4Reminder matchReminders(V4Reminder r4, String[] names) {
        V4Reminder head = null;
        while (r4 != null) {
            V4Reminder ptr = r4.next;
            if (this.matchNames(r4.attr.attr.val, names)) {
                r4.next = head;
                head = r4;
            }
            r4 = ptr;
        }
        return head;
    }

    public Attribute[] openCalendar() throws CalendarException {
        if (this.mconn.svc4 == null) {
            throw new CalendarException(10);
        }
        this.mserverVersion = 4;
        this.mdataVersion = 3;
        Appt appt = this.lookupAppts(0L, 0L, null, null, null);
        Access_Entry ae = this.getV4AccessList();
        try {
            this.setV4AccessList(ae);
            this.maccess = new AccessRights(32768L);
            this.maccess.useCSAModel(false);
        }
        catch (CalendarException e) {
            if (e.getErrorCode() != 10) {
                this.maccess = this.getUserAccess(ae);
            }
            throw e;
        }
        return null;
    }

    public void setAccessList(CsaAccessEntry[] arr) throws CalendarException {
        if (this.mconn.svc4 == null) {
            throw new CalendarException(10);
        }
        this.setV4AccessList(this.toAccess_Entry(arr));
    }

    void setV4AccessList(Access_Entry ae) throws CalendarException {
        Access_Status res = new Access_Status();
        Access_Args args = new Access_Args();
        args.target = new Buffer(this.calname);
        args.access_list = ae;
        try {
            if (this.mconn.svc4.rtable_set_access(args, res)) {
                this.registerCallback();
            }
            this.checkAccessStatus(res, true);
        }
        catch (CalendarException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleException(e);
            throw new CalendarException(10, "rtable_get_access failed");
        }
    }

    CsaAccessEntry[] toAccessEntry(Access_Entry e) {
        if (e == null) {
            return null;
        }
        Vector<CsaAccessEntry> v = new Vector<CsaAccessEntry>(1);
        while (e != null) {
            CsaAccessEntry ae = new CsaAccessEntry(e.who.val, e.access_type);
            ae.useCSAModel(false);
            v.addElement(ae);
            e = e.next;
        }
        Object[] res = new CsaAccessEntry[v.size()];
        v.copyInto(res);
        return res;
    }

    Access_Entry toAccess_Entry(CsaAccessEntry[] arr) {
        if (arr == null || arr.length == 0) {
            return null;
        }
        Access_Entry head = null;
        int i = 0;
        while (i < arr.length) {
            Access_Entry ptr = new Access_Entry();
            ptr.who = new Buffer(arr[i].getUser());
            ptr.access_type = (int)arr[i].getRights();
            ptr.next = null;
            ptr.next = head;
            head = ptr;
            ++i;
        }
        return head;
    }

    /*
     * Unable to fully structure code
     */
    ReminderRef[] toReminderRef(V4Reminder r4, String[] names) throws CalendarException {
        save = null;
        uidl = null;
        if (names != null) {
            r4 = this.matchReminders(r4, names);
        }
        if (r4 != null) ** GOTO lbl22
        return null;
lbl-1000:
        // 1 sources

        {
            ptr = r4.next;
            ptr2 = save;
            while (ptr2 != null) {
                if (r4.appt_id.key == ptr2.appt_id.key) break;
                ptr2 = ptr2.next;
            }
            if (ptr2 == null) {
                r4.next = save;
                save = r4;
                uid = new Uid();
                uid.appt_id.tick = r4.appt_id.tick;
                uid.appt_id.key = r4.appt_id.key;
                uid.next = uidl;
                uidl = uid;
            }
            r4 = ptr;
lbl22:
            // 2 sources

            ** while (r4 != null)
        }
lbl23:
        // 1 sources

        v4appts = this.lookupApptsByIds(uidl, new Attribute("-//XAPIA/CSA/ENTRYATTR//NONSGML Type//EN", new Uint32Value(0L)));
        if (v4appts == null) {
            return null;
        }
        vf = new Vector<ReminderRef>(1);
        while (save != null) {
            a = v4appts;
            prev = v4appts;
            while (a != null) {
                if (a.appt_id.key == save.appt_id.key) {
                    if (a == prev) {
                        v4appts = a.next;
                    } else {
                        prev.next = a.next;
                    }
                    a.next = null;
                    owappt = new OWAppt(a, this.mcal);
                    remRef = new ReminderRef((long)save.tick * 1000L);
                    remRef.setAppointment(owappt);
                    vf.addElement(remRef);
                    break;
                }
                prev = a;
                a = a.next;
            }
            save = save.next;
        }
        array = new ReminderRef[vf.size()];
        vf.copyInto(array);
        return array;
    }

    Appt updateAppt(Appt appt, Scope scope) throws CalendarException {
        Table_Res res = new Table_Res();
        Table_Args args = new Table_Args();
        args.target.val = this.calname;
        args.args.tag = new Table_Args_Type(1);
        args.args.apptid = new Apptid();
        args.args.apptid.oid = new Id();
        args.args.apptid.oid.tick = appt.appt_id.tick;
        args.args.apptid.oid.key = appt.appt_id.key;
        args.args.apptid.new_appt = appt;
        args.args.apptid.option = new Options();
        args.args.apptid.option.enum = scope.getValue();
        args.pid = 2;
        try {
            if (this.mconn.svc4.rtable_change(args, res)) {
                this.registerCallback();
            }
            this.checkAccessStatus(res.status, true);
            if (res.res.tag.enum != 0) {
                throw new CalendarException(0, "Unexpected data type returned");
            }
            return res.res.a;
        }
        catch (CalendarException e) {
            throw e;
        }
        catch (Exception e) {
            this.handleException(e);
            throw new CalendarException(10, "rtable_update failed");
        }
    }

    public Appointment updateEntry(Appointment a, Scope scope) throws CalendarException {
        if (this.mconn.svc4 == null) {
            throw new CalendarException(10);
        }
        if (a instanceof OWAppt) {
            Appt newa = this.updateAppt(((OWAppt)a).getApptForUpdate(scope), scope);
            if (newa != null) {
                if (a.getRepeat().repeats() && scope.getValue() == 0) {
                    int newsdate;
                    System.out.println("*** MESSAGE NEEDED ****");
                    OWAppt owa = (OWAppt)a;
                    int sdate = newa.appt_id.tick;
                    newa.appt_id.tick = newsdate = owa.mappt.appt_id.tick;
                }
                return new OWAppt(newa, this.mcal);
            }
            return null;
        }
        throw new CalendarException(0);
    }
}

