/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.csa;

import sunw.jdt.cal.csa.CalendarException;
import sunw.jdt.cal.csa.RepeatType;

public class Repeat
implements RepeatType {
    public static final int FOREVER = 0;
    int mtype;
    int mtimes;
    int mfrequency = 1;
    boolean mlastWeek = false;

    public Repeat() {
        this.mtype = 0;
    }

    public Repeat(int type, int times) throws CalendarException {
        if (type < 0 || type > 17) {
            throw new CalendarException(19, "wrong type");
        }
        if (times < 0) {
            throw new CalendarException(19, "time to repeat cannot be negative");
        }
        this.mtype = type;
        this.mtimes = times;
    }

    public Repeat(Repeat r) {
        this.mtype = r.mtype;
        this.mtimes = r.mtimes;
        this.mfrequency = 1;
        this.mlastWeek = r.mlastWeek;
    }

    public int getFrequency() throws CalendarException {
        if (this.mtype != 0) {
            return this.mfrequency;
        }
        throw new CalendarException(18, "type is one time");
    }

    public int getTimes() throws CalendarException {
        if (this.mtype != 0) {
            return this.mtimes;
        }
        throw new CalendarException(18, "type is one time");
    }

    public int getType() {
        return this.mtype;
    }

    public String getTypeString() {
        switch (this.mtype) {
            case 0: {
                return "One Time";
            }
            case 1: {
                return "Daily";
            }
            case 2: {
                return "Weekly";
            }
            case 3: {
                return "Every Two Weeks";
            }
            case 4: {
                return "Monthly by Weekday";
            }
            case 5: {
                return "Monthly by Date";
            }
            case 6: {
                return "Yearly";
            }
            case 7: {
                return "Every " + this.mfrequency + " Days";
            }
            case 8: {
                return "Every " + this.mfrequency + " Weeks";
            }
            case 9: {
                return "Every " + this.mfrequency + " Months";
            }
            case 10: {
                return "Monday thru Friday";
            }
            case 11: {
                return "Mon, Wed, Fri";
            }
            case 12: {
                return "Tuesday, Thursday";
            }
            case 13: {
                return "Weekday Combo";
            }
            case 15: {
                return "Other Weekly";
            }
            case 16: {
                return "Other Monthly";
            }
            case 17: {
                return "Other Yearly";
            }
        }
        return "Other";
    }

    public boolean lastWeek() {
        return this.mlastWeek;
    }

    public void print() {
        System.out.println(this.getTypeString());
        if (this.mtype == 0) {
            return;
        }
        if (this.mtimes == 0) {
            System.out.println(" forever");
        } else {
            System.out.println(" for " + this.mtimes + " times");
        }
    }

    public boolean repeats() {
        return this.mtype != 0;
    }

    public void setFrequency(int f) {
        this.mfrequency = f;
    }

    public void setLastWeek(boolean lastWeek) throws CalendarException {
        if (this.mtype != 4) {
            throw new CalendarException(18, "repeat type is not MONTHLY_BY_WEEKDAY");
        }
        this.mlastWeek = lastWeek;
    }

    public static int toV4RepeatType(int type) {
        switch (type) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 6;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 11;
            }
            case 11: {
                return 12;
            }
            case 12: {
                return 13;
            }
            case 13: {
                return 14;
            }
        }
        return 10;
    }
}

