/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.csa;

import sunw.jdt.cal.cmsd5.attr_value_type;
import sunw.jdt.cal.cmsd5.cms_attribute_value;
import sunw.jdt.cal.cmsd5.cms_opaque_data;
import sunw.jdt.cal.cmsd5.cms_reminder;
import sunw.jdt.cal.cmsd5.uint32;
import sunw.jdt.cal.csa.AttributeValue;
import sunw.jdt.cal.csa.CalendarException;
import sunw.jdt.cal.csa.Iso8601;
import sunw.jdt.cal.csa.OpaqueData;
import sunw.jdt.cal.csa.Reminder;
import sunw.jdt.cal.rpc.Buffer;

public class ReminderValue
extends AttributeValue {
    Reminder mvalue;

    public ReminderValue(cms_attribute_value cms) throws CalendarException {
        if (cms.type.value != 13) {
            throw new CalendarException(4, "wrong type");
        }
        int leadTime = Iso8601.toDuration(cms.type__reminder_value.lead_time.val);
        int snoozeTime = cms.type__reminder_value.snooze_time.val != null && cms.type__reminder_value.snooze_time.val.length() > 0 ? Iso8601.toDuration(cms.type__reminder_value.snooze_time.val) : 0;
        int snoozeCount = (int)cms.type__reminder_value.repeat_count.data;
        OpaqueData data = cms.type__reminder_value.reminder_data != null && cms.type__reminder_value.reminder_data.data != null && cms.type__reminder_value.reminder_data.data.length > 0 ? new OpaqueData(cms.type__reminder_value.reminder_data.data) : null;
        this.mvalue = new Reminder(leadTime, snoozeTime, snoozeCount, data);
        this.mtype = 24;
    }

    public ReminderValue(Reminder value) {
        this.mtype = 24;
        this.mvalue = value;
    }

    public Object clone() {
        ReminderValue v = new ReminderValue(new Reminder(this.mvalue));
        return v;
    }

    public Reminder getReminder() {
        return this.mvalue;
    }

    public void print() {
        System.out.print("Reminder:lead=" + this.mvalue.getLeadTime() + ", snooze=" + this.mvalue.getSnoozeTime() + ", count=" + this.mvalue.getSnoozeCount() + ", data=");
        if (this.mvalue.getData() != null) {
            this.mvalue.getData().print();
        }
    }

    public cms_attribute_value toCmsValue() {
        cms_reminder r = new cms_reminder();
        r.lead_time = new Buffer(Iso8601.toIsoDuration(this.mvalue.getLeadTime()));
        r.snooze_time = new Buffer(Iso8601.toIsoDuration(this.mvalue.getSnoozeTime()));
        r.repeat_count = new uint32(this.mvalue.getSnoozeCount());
        r.reminder_data = new cms_opaque_data();
        r.reminder_data.data = this.mvalue.getData() != null ? this.mvalue.getData().getBytes() : new byte[0];
        cms_attribute_value cms = new cms_attribute_value();
        cms.type = new attr_value_type(13);
        cms.type__reminder_value = r;
        return cms;
    }
}

