/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.csa;

import java.util.Enumeration;
import java.util.Hashtable;
import sunw.jdt.cal.csa.CBListener;
import sunw.jdt.cal.csa.CalEvent;
import sunw.jdt.cal.csa.CalServer;
import sunw.jdt.cal.csa.CalendarException;
import sunw.jdt.cal.csa.ClientRegistry;
import sunw.jdt.cal.csa.CsaEventHandler;
import sunw.jdt.cal.csa.RpcCBHandler;
import sunw.jdt.cal.util.Debug;

public class ProxyClient
implements RpcCBHandler {
    static RpcCBHandler mhandler = null;
    static Hashtable mregistries = new Hashtable();

    static synchronized RpcCBHandler getHandler() {
        if (mhandler == null) {
            mhandler = new ProxyClient();
        }
        return mhandler;
    }

    static String getHostName(String name) {
        int atIndex = name.indexOf("@");
        String loc = name.substring(atIndex + 1);
        int dotIndex = loc.indexOf(".");
        if (dotIndex >= 0) {
            loc = loc.substring(0, dotIndex);
        }
        return loc;
    }

    public void handleEvent(CalEvent evt) {
        String host;
        Hashtable regs;
        if (Debug.on) {
            System.out.println("ProxyClient.handleEvent called");
        }
        if ((regs = (Hashtable)mregistries.get(host = ProxyClient.getHostName(evt.getHost()))) != null) {
            Enumeration e = regs.elements();
            while (e.hasMoreElements()) {
                ClientRegistry reg = (ClientRegistry)e.nextElement();
                reg.handleEvent(evt);
            }
        } else if (Debug.on) {
            System.out.println("No one registered for " + evt.getCalendar());
        }
    }

    public static void register(int events, CsaEventHandler h) throws CalendarException {
        ClientRegistry reg;
        String calname = h.getCalendar();
        String host = ProxyClient.getHostName(calname);
        Hashtable hashtable = mregistries;
        synchronized (hashtable) {
            Hashtable<String, ClientRegistry> regs = (Hashtable<String, ClientRegistry>)mregistries.get(host);
            if (regs == null) {
                regs = new Hashtable<String, ClientRegistry>();
                mregistries.put(host, regs);
                reg = null;
            } else {
                reg = (ClientRegistry)regs.get(calname);
            }
            if (reg == null) {
                reg = new ClientRegistry(calname, h.getServerVersion());
                regs.put(calname, reg);
            }
        }
        reg.register(events, h);
    }

    public static void registerAgain(String host) {
        Hashtable hashtable = mregistries;
        synchronized (hashtable) {
            Hashtable regs = (Hashtable)mregistries.get(ProxyClient.getHostName(host));
            if (regs != null) {
                Enumeration elems = regs.elements();
                while (elems.hasMoreElements()) {
                    ClientRegistry reg = (ClientRegistry)elems.nextElement();
                    reg.registerAgain();
                }
            }
        }
    }

    static void registerWithServer(String cal, int events) throws CalendarException {
        block3: {
            Object s = null;
            boolean closeit = true;
            try {
                CalServer.register(cal, events, ProxyClient.getHandler());
                if (Debug.on) {
                    System.out.println("registered cb directly with server for " + cal);
                }
            }
            catch (Exception e) {
                if (!Debug.on) break block3;
                e.printStackTrace();
            }
        }
    }

    public static void unregister(CsaEventHandler h) {
        Hashtable regs;
        ClientRegistry reg = null;
        String calname = h.getCalendar();
        String host = ProxyClient.getHostName(calname);
        Hashtable hashtable = mregistries;
        synchronized (hashtable) {
            regs = (Hashtable)mregistries.get(host);
            if (regs == null) {
                if (Debug.on) {
                    System.out.println("ProxyClient.unregister: no registries exist for host " + host);
                }
            } else {
                reg = (ClientRegistry)regs.get(calname);
                if (reg == null && Debug.on) {
                    System.out.println("ProxyClient.unregister: registry for " + calname + " does not exists");
                }
            }
        }
        if (reg != null && reg.unregister(h)) {
            hashtable = mregistries;
            synchronized (hashtable) {
                regs = (Hashtable)mregistries.get(host);
                if (regs != null) {
                    regs.remove(calname);
                    if (regs.size() == 0) {
                        mregistries.remove(host);
                        if (mregistries.isEmpty()) {
                            CBListener.cleanup();
                        }
                    }
                }
            }
        }
    }

    static void unregisterWithServer(String cal, int events) throws CalendarException {
        block3: {
            Object s = null;
            try {
                CalServer.unregister(cal, events, ProxyClient.getHandler());
                if (Debug.on) {
                    System.out.println("unregister cb directly with server for " + cal);
                }
            }
            catch (Exception e) {
                if (!Debug.on) break block3;
                e.printStackTrace();
            }
        }
    }
}

