/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.csa;

import java.util.Date;
import java.util.Vector;
import sunw.jdt.cal.cmsd4.Appt;
import sunw.jdt.cal.cmsd4.ApptAttribute;
import sunw.jdt.cal.csa.Appointment;
import sunw.jdt.cal.csa.Calendar;
import sunw.jdt.cal.csa.CalendarException;
import sunw.jdt.cal.csa.Classification;
import sunw.jdt.cal.csa.Reminder;
import sunw.jdt.cal.csa.Repeat;
import sunw.jdt.cal.csa.Scope;

public class OWAppt
extends Appointment {
    Calendar mcal;
    Appt mappt;
    int oldRepeatType = -1;

    public OWAppt(Date start, Date end) throws CalendarException {
        if (start == null || end == null) {
            throw new CalendarException(13, "missing start and/or end date");
        }
        long stime = start.getTime();
        long etime = end.getTime();
        this.mappt = new Appt((int)(stime / 1000L), (int)(etime / 1000L));
        this.mstart = new Date(stime);
        this.mend = new Date(etime);
        this.mrepeat = new Repeat();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    OWAppt(Appt appt, Calendar cookie) {
        this.mcal = cookie;
        this.mappt = appt;
        this.mstart = new Date((long)appt.appt_id.tick * 1000L);
        this.mend = new Date((long)(appt.appt_id.tick + appt.duration) * 1000L);
        this.oldRepeatType = appt.period.period.enum;
        if (appt.period.period.enum == 0) {
            this.mrepeat = new Repeat();
            return;
        }
        try {
            this.mrepeat = new Repeat(appt.period.period.enum, appt.ntimes == 999999999 ? 0 : appt.ntimes);
            if (appt.period.period.enum == 6 && appt.period.nth == -1) {
                this.mrepeat.setLastWeek(true);
                return;
            }
            switch (appt.period.period.enum) {
                case 7: 
                case 8: 
                case 9: {
                    this.mrepeat.setFrequency(appt.period.nth);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (CalendarException e) {
            System.out.println(e.toString());
            System.out.println("invalid repeat info from back end");
        }
    }

    public Object clone() {
        return new OWAppt((Appt)this.mappt.clone(), this.mcal);
    }

    Appt getApptForUpdate(Scope scope) {
        if (this.oldRepeatType != 0 && scope.mvalue == 1 && !this.mrepeatChanged) {
            Appt appt = (Appt)this.mappt.clone();
            appt.period.period.enum = 0;
            return appt;
        }
        return this.mappt;
    }

    public Classification getClassification() {
        try {
            return new Classification(this.mappt.privacy.enum);
        }
        catch (CalendarException e) {
            System.out.println(e.toString());
            return new Classification();
        }
    }

    Object getCookie() {
        return this.mcal;
    }

    public Date getDateCreated() {
        return null;
    }

    public Date getEndDate() {
        return new Date(this.mend.getTime());
    }

    public int getIdentifier() {
        return this.mappt.appt_id.key;
    }

    public String getMailId() {
        return null;
    }

    public String getOrganizer() {
        return this.mappt.author.val;
    }

    public Reminder getReminder() {
        if (this.mappt.attr == null) {
            return null;
        }
        return new Reminder(Integer.parseInt(this.mappt.attr.value.val));
    }

    public Repeat getRepeat() {
        return this.mrepeat;
    }

    public boolean getShowTime() {
        return this.mappt.tag.showtime != 0;
    }

    public Date getStartDate() {
        return new Date(this.mstart.getTime());
    }

    public String getSummary() {
        return this.mappt.what.val;
    }

    public void print() {
        this.mappt.print();
    }

    public Classification setClassification(Classification c) throws CalendarException {
        if (c == null) {
            throw new CalendarException(19, "classification cannot take null value");
        }
        int oldvalue = this.mappt.privacy.enum;
        this.mappt.privacy.enum = c.getValue();
        try {
            return new Classification(oldvalue);
        }
        catch (Exception exception) {
            return new Classification();
        }
    }

    public Date setEndDate(Date date) throws CalendarException {
        if (date.before(this.mstart)) {
            throw new CalendarException(19, "Invalid End date.");
        }
        Date oldtime = this.mend;
        long etime = date.getTime();
        this.mappt.duration = (int)(etime / 1000L) - this.mappt.appt_id.tick;
        this.mend = new Date(etime);
        return oldtime;
    }

    public String setMailId(String mailId) throws CalendarException {
        throw new CalendarException(23, "attribute not supported");
    }

    public Reminder setReminder(Reminder reminder) throws CalendarException {
        ApptAttribute attr;
        ApptAttribute oldattr = this.mappt.attr;
        this.mappt.attr = reminder == null ? null : (attr = new ApptAttribute("op", reminder.getLeadTime()));
        if (oldattr != null) {
            return new Reminder(Integer.parseInt(oldattr.value.val));
        }
        return null;
    }

    public Repeat setRepeat(Repeat r) throws CalendarException {
        this.mrepeatChanged = true;
        if (r == null) {
            throw new CalendarException(19, "repeat information cannot take null value");
        }
        Repeat old = this.mrepeat;
        this.mrepeat = r;
        this.mappt.period.period.enum = r.getType();
        this.mappt.ntimes = r.getTimes() == 0 ? 999999999 : r.getTimes();
        switch (this.mappt.period.period.enum) {
            case 6: {
                if (!r.lastWeek()) break;
                this.mappt.period.nth = -1;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                this.mappt.period.nth = r.getFrequency();
                break;
            }
        }
        return old;
    }

    public boolean setShowTime(boolean s) throws CalendarException {
        boolean oldvalue = this.mappt.tag.showtime != 0;
        this.mappt.tag.showtime = s ? 1 : 0;
        return oldvalue;
    }

    public Date setStartDate(Date date) throws CalendarException {
        if (date == null) {
            throw new CalendarException(19, "start date cannot take null value");
        }
        if (date.after(this.mend)) {
            throw new CalendarException(19, "Invalid Start date.");
        }
        Date oldtime = this.mstart;
        long stime = date.getTime();
        this.mappt.appt_id.tick = (int)(stime / 1000L);
        this.mstart = new Date(stime);
        return oldtime;
    }

    public String setSummary(String s) throws CalendarException {
        String oldvalue = this.mappt.what.val;
        this.mappt.what.val = s;
        return oldvalue;
    }

    static Appointment[] toAppointments(Appt as, Calendar cookie) {
        if (as == null) {
            return null;
        }
        Vector<OWAppt> v = new Vector<OWAppt>(1);
        while (as != null) {
            OWAppt a = new OWAppt(as, cookie);
            v.addElement(a);
            as = as.next;
        }
        Object[] appts = new OWAppt[v.size()];
        v.copyInto(appts);
        return appts;
    }

    /*
     * Exception decompiling
     */
    static Appt toAppt(Appointment appt) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

