/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.csa;

import java.util.Enumeration;
import java.util.Vector;
import sunw.jdt.cal.csa.Attribute;
import sunw.jdt.cal.csa.CalendarException;

public class LookupCriteria {
    public static final int MATCH_ANY = 0;
    public static final int EQUAL_TO = 1;
    public static final int NOT_EQUAL_TO = 2;
    public static final int GREATER_THAN = 3;
    public static final int LESS_THAN = 4;
    public static final int GREATER_THAN_OR_EQUAL_TO = 5;
    public static final int LESS_THAN_OR_EQUAL_TO = 6;
    public static final int CONTAIN = 7;
    Vector mops;
    Vector mattrs;

    public LookupCriteria() {
        this.init(1);
    }

    public LookupCriteria(int initialCapacity) {
        this.init(initialCapacity);
    }

    LookupCriteria(LookupCriteria lc) {
        int size;
        if (lc != null && (size = lc.getSize()) != 0) {
            this.mops = new Vector(size);
            this.mattrs = new Vector(size);
            int i = 0;
            while (i < size) {
                this.mops.addElement(lc.mops.elementAt(i));
                this.mattrs.addElement(lc.mattrs.elementAt(i));
                ++i;
            }
        } else {
            this.init(1);
        }
    }

    public void addCriterion(int op, Attribute attr) throws CalendarException {
        if (op < 0 || op > 7) {
            throw new CalendarException(17, "invalid operator");
        }
        this.mops.addElement(new Integer(op));
        this.mattrs.addElement(attr);
    }

    public Enumeration getAttrs() {
        return this.mattrs.elements();
    }

    public Enumeration getOps() {
        return this.mops.elements();
    }

    public int getSize() {
        return this.mops.size();
    }

    void init(int size) {
        this.mops = new Vector(size);
        this.mattrs = new Vector(size);
    }
}

