/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.csa;

import java.util.Hashtable;
import java.util.Locale;
import sunw.jdt.cal.util.Debug;

public class LocaleXlateTable {
    static final int CDE_LOCALE = 0;
    static final int LANG = 1;
    static final int COUNTRY = 2;
    static final int CLIENT_ENCODING = 3;
    static final int OPTIONAL = 4;
    static final int SERVER_ENCODING = 5;
    static Hashtable toCDE;
    static Hashtable fromCDE;
    private static final String[][] mappings;

    static {
        mappings = new String[][]{{"C.ISO-8859-1", "en", "US", "ISO-8859-1", "true", ""}, {"en_US.ISO-8859-1", "en", "US", "ISO-8859-1", "true", ""}, {"en_AU.ISO-8859-1", "en", "AU", "ISO-8859-1", "false", ""}, {"en_CA.ISO-8859-1", "en", "CA", "ISO-8859-1", "false", ""}, {"en_IE.ISO-8859-1", "en", "IE", "ISO-8859-1", "false", ""}, {"en_NZ.ISO-8859-1", "en", "NZ", "ISO-8859-1", "false", ""}, {"en_UK.ISO-8859-1", "en", "UK", "ISO-8859-1", "false", ""}, {"en_US.UTF-8", "en", "US", "UTF-8", "true", ""}, {"cz_CZ.ISO-8859-2", "cz", "CZ", "ISO-8859-2", "true", ""}, {"da_DK.ISO-8859-1", "da", "DK", "ISO-8859-1", "true", ""}, {"de_DE.ISO-8859-1", "de", "DE", "ISO-8859-1", "true", ""}, {"de_AT.ISO-8859-1", "de", "AT", "ISO-8859-1", "false", ""}, {"de_CH.ISO-8859-1", "de", "CH", "ISO-8859-1", "false", ""}, {"el_GR.ISO-8859-7", "el", "GR", "ISO-8859-7", "true", ""}, {"es_ES.ISO-8859-1", "es", "ES", "ISO-8859-1", "true", ""}, {"es_AR.ISO-8859-1", "es", "AR", "ISO-8859-1", "false", ""}, {"es_BO.ISO-8859-1", "es", "BO", "ISO-8859-1", "false", ""}, {"es_CL.ISO-8859-1", "es", "CL", "ISO-8859-1", "false", ""}, {"es_CO.ISO-8859-1", "es", "CO", "ISO-8859-1", "false", ""}, {"es_CR.ISO-8859-1", "es", "CR", "ISO-8859-1", "false", ""}, {"es_EC.ISO-8859-1", "es", "EC", "ISO-8859-1", "false", ""}, {"es_GT.ISO-8859-1", "es", "GT", "ISO-8859-1", "false", ""}, {"es_MX.ISO-8859-1", "es", "MX", "ISO-8859-1", "false", ""}, {"es_NI.ISO-8859-1", "es", "NI", "ISO-8859-1", "false", ""}, {"es_PA.ISO-8859-1", "es", "PA", "ISO-8859-1", "false", ""}, {"es_PE.ISO-8859-1", "es", "PE", "ISO-8859-1", "false", ""}, {"es_PY.ISO-8859-1", "es", "PY", "ISO-8859-1", "false", ""}, {"es_SV.ISO-8859-1", "es", "SV", "ISO-8859-1", "false", ""}, {"es_UY.ISO-8859-1", "es", "UY", "ISO-8859-1", "false", ""}, {"es_VE.ISO-8859-1", "es", "VE", "ISO-8859-1", "false", ""}, {"et_EE.ISO-8859-1", "et", "EE", "ISO-8859-1", "true", ""}, {"fr_FR.ISO-8859-1", "fr", "FR", "ISO-8859-1", "true", ""}, {"fr_BE.ISO-8859-1", "fr", "BE", "ISO-8859-1", "false", ""}, {"fr_CA.ISO-8859-1", "fr", "CA", "ISO-8859-1", "false", ""}, {"fr_CH.ISO-8859-1", "fr", "CH", "ISO-8859-1", "false", ""}, {"hu_HU.ISO-8859-2", "hu", "HU", "ISO-8859-2", "true", ""}, {"it_IT.ISO-8859-1", "it", "IT", "ISO-8859-1", "true", ""}, {"ja_JP.EUC-JP", "ja", "JP", "ISO-2022-JP", "true", "EUC-JP"}, {"ja_JP.PCK", "ja", "JP", "ISO-2022-JP", "true", "Shift_JIS"}, {"ko_KR.EUC-KR", "ko", "KR", "EUC-KR", "true", "ISO-2022-KR"}, {"lt_LT.ISO-8859-4", "lt", "LT", "ISO-8859-4", "true", ""}, {"lv_LV.ISO-8859-4", "lv", "LV", "ISO-8859-4", "true", ""}, {"nl_NL.ISO-8859-1", "nl", "NL", "ISO-8859-1", "true", ""}, {"nl_BE.ISO-8859-1", "nl", "BE", "ISO-8859-1", "false", ""}, {"no_NO.ISO-8859-1", "no", "NO", "ISO-8859-1", "true", ""}, {"pl_PL.ISO-8859-2", "pl", "PL", "ISO-8859-2", "true", ""}, {"pt_PT.ISO-8859-1", "pt", "PT", "ISO-8859-1", "true", ""}, {"pt_BR.ISO-8859-1", "pt", "BR", "ISO-8859-1", "false", ""}, {"ru_RU.ISO-8859-5", "ru", "RU", "ISO-8859-5", "true", ""}, {"su_FI.ISO-8859-1", "su", "FI", "ISO-8859-1", "true", ""}, {"sv_SE.ISO-8859-1", "sv", "SE", "ISO-8859-1", "true", ""}, {"tr_TR.ISO-8859-9", "tr", "TR", "ISO-8859-9", "true", ""}, {"zh_CN.EUC-CN", "zh", "CN", "GB2312", "true", ""}, {"zh_TW.EUC-TW", "zh", "TW", "CNS11643", "true", "BIG5"}, {"zh_TW.BIG5", "zh", "TW", "BIG5", "true", ""}};
        fromCDE = new Hashtable(mappings.length);
        int i = 0;
        while (i < mappings.length) {
            fromCDE.put(mappings[i][0], mappings[i]);
            ++i;
        }
        toCDE = new Hashtable(mappings.length);
        int i2 = 0;
        while (i2 < mappings.length) {
            toCDE.put(String.valueOf(mappings[i2][1]) + "_" + mappings[i2][2], mappings[i2]);
            if (mappings[i2][4].equals("true")) {
                toCDE.put(mappings[i2][1], mappings[i2]);
            }
            ++i2;
        }
    }

    static String getCDELocale(Locale aLocale) {
        String cdelocale = null;
        if (aLocale == null) {
            return null;
        }
        String lang = aLocale.getLanguage();
        String country = aLocale.getCountry();
        String key = country != null && country.length() != 0 ? new String(String.valueOf(lang) + "_" + country) : lang;
        String[] mapping = (String[])toCDE.get(key);
        if (mapping != null) {
            cdelocale = mapping[0];
        }
        if (Debug.on) {
            System.out.println("LocaleXlateTable.getCDELocale: " + key + " -> " + cdelocale);
        }
        return cdelocale;
    }

    static String getCountry(String cdelocale) {
        String country = null;
        String[] mapping = (String[])fromCDE.get(cdelocale);
        if (mapping != null) {
            country = mapping[2];
        }
        if (Debug.on) {
            System.out.println("LocaleXlateTable.getCountry: " + cdelocale + "->" + country);
        }
        return country;
    }

    public static String getEncoding(String cdelocale) {
        return LocaleXlateTable.getEncoding(cdelocale, false);
    }

    public static String getEncoding(String cdelocale, boolean server) {
        String encoding = null;
        String[] mapping = (String[])fromCDE.get(cdelocale);
        if (mapping != null) {
            encoding = mapping[3];
            if (server && !mapping[5].trim().equals("")) {
                encoding = mapping[5];
            }
        }
        if (Debug.on) {
            System.out.println("LocaleXlateTable.getEncoding: " + cdelocale + "->" + encoding);
        }
        return encoding;
    }

    static String getLang(String cdelocale) {
        String lang = null;
        String[] mapping = (String[])fromCDE.get(cdelocale);
        if (mapping != null) {
            lang = mapping[1];
        }
        if (Debug.on) {
            System.out.println("LocaleXlateTable.getLang: " + cdelocale + "->" + lang);
        }
        return lang;
    }

    static boolean isCountryOptional(String cdelocale) {
        String[] mapping = (String[])fromCDE.get(cdelocale);
        if (mapping != null) {
            return mapping[4].equals("true");
        }
        return false;
    }
}

