/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.csa;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import sunw.jdt.cal.csa.CalendarException;

public class Iso8601 {
    static final int ISO8601_UTC_TIME_LENGTH = 16;
    static final int T_POS = 8;
    static final int Z_POS = 15;

    public static Date toDate(String s) throws CalendarException {
        if (s.length() != 16 || s.charAt(8) != 'T' || s.charAt(15) != 'Z') {
            throw new CalendarException(15, "invalid date time");
        }
        int year = Integer.parseInt(s.substring(0, 4));
        int month = Integer.parseInt(s.substring(4, 6));
        int date = Integer.parseInt(s.substring(6, 8));
        int hrs = Integer.parseInt(s.substring(9, 11));
        int min = Integer.parseInt(s.substring(11, 13));
        int sec = Integer.parseInt(s.substring(13, 15));
        if (month < 1 || month > 12 || date < 1 || date > 31 || hrs < 0 || hrs > 24 || min < 0 || min > 59 || sec < 0 || sec > 59) {
            throw new CalendarException(15, "invalid date time");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        calendar.set(year, month - 1, date, hrs, min, sec);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static int toDuration(String s) throws CalendarException {
        boolean negative = false;
        int index = 0;
        int p = 1;
        int t = 2;
        char first = s.charAt(index);
        if (first == '+') {
            negative = false;
        } else if (first == '-') {
            negative = true;
        } else if (first == 'P') {
            --p;
            --t;
        } else {
            throw new CalendarException(16, "invalid iso 8601 format");
        }
        if (s.charAt(p) != 'P' || s.charAt(t) != 'T') {
            throw new CalendarException(16, "invalid iso 8601 format");
        }
        index = t + 1;
        while (index < s.length()) {
            if (!Character.isDigit(s.charAt(index))) break;
            ++index;
        }
        if (index != s.length() - 1 || s.charAt(index) != 'S') {
            throw new CalendarException(16, "invalid iso 8601 format");
        }
        int num = Integer.parseInt(s.substring(t + 1, index));
        return negative ? -num : num;
    }

    public static String toIsoDate(Date date) {
        return Iso8601.toIsoDate(date, TimeZone.getDefault());
    }

    public static String toIsoDate(Date date, TimeZone tz) {
        Calendar calendar = Calendar.getInstance(tz);
        calendar.setTime(date);
        int offset = calendar.getTimeZone().getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), calendar.get(14));
        calendar.add(14, -offset);
        int[] times = new int[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13)};
        StringBuffer iso = new StringBuffer(16);
        iso.append(times[0]);
        int i = 1;
        while (i < 6) {
            if (times[i] > 9) {
                iso.append(times[i]);
            } else {
                iso.append(0);
                iso.append(times[i]);
            }
            if (i == 2) {
                iso.append('T');
            }
            ++i;
        }
        iso.append('Z');
        return iso.toString();
    }

    public static String toIsoDuration(int d) {
        int num = d < 0 ? -d : d;
        return String.valueOf(d < 0 ? "-" : "+") + "PT" + String.valueOf(num) + "S";
    }
}

