/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.csa;

import sunw.jdt.cal.cmsd5.cms_attribute;
import sunw.jdt.cal.csa.Attribute;
import sunw.jdt.cal.csa.AttributeValue;
import sunw.jdt.cal.csa.CalendarException;
import sunw.jdt.cal.csa.EntryAttributeNames;

public class EntryAttribute
extends Attribute {
    int mindex = -1;

    public EntryAttribute(int nameIndex, AttributeValue value) throws CalendarException {
        super(EntryAttributeNames.getName(nameIndex));
        if (this.mname == null) {
            throw new CalendarException(22, "the name index is not valid");
        }
        this.mindex = nameIndex;
        if (value != null) {
            this.checkType(value.getType());
        }
        this.mvalue = value;
    }

    public EntryAttribute(String name) {
        super(name);
    }

    public EntryAttribute(String name, AttributeValue value) throws CalendarException {
        super(name);
        if (value != null) {
            this.checkType(value.getType());
        }
        this.mvalue = value;
    }

    protected EntryAttribute(cms_attribute cms) {
        super(cms.name.name.val);
        this.mindex = EntryAttributeNames.getIndex(this.mname);
        try {
            this.mvalue = Attribute.toAttributeValue(cms.value);
        }
        catch (CalendarException e) {
            System.out.print("EntryAttribute(cms_attribute cms): " + e.toString());
        }
    }

    private void checkType(int atype) throws CalendarException {
        if (this.mindex < 0) {
            this.mindex = EntryAttributeNames.getIndex(this.mname);
        }
        if (this.mindex >= 0 && EntryAttributeNames.getType(this.mindex) != atype) {
            throw new CalendarException(4, "wrong attribute type");
        }
    }

    public Object clone() {
        EntryAttribute v = null;
        try {
            v = new EntryAttribute(this.mindex, (AttributeValue)this.mvalue.clone());
        }
        catch (Exception exception) {}
        return v;
    }

    public static EntryAttribute[] fromCmsAttrs(cms_attribute[] cmsAttrs) {
        if (cmsAttrs == null) {
            return null;
        }
        EntryAttribute[] attrs = new EntryAttribute[cmsAttrs.length];
        int i = 0;
        while (i < cmsAttrs.length) {
            if (cmsAttrs[i] != null) {
                attrs[i] = new EntryAttribute(cmsAttrs[i]);
            }
            ++i;
        }
        return attrs;
    }

    protected int getIndex() {
        return this.mindex;
    }

    public AttributeValue setValue(AttributeValue value) throws CalendarException {
        if (value != null) {
            if (this.mvalue != null && this.mvalue.getType() != value.getType()) {
                throw new CalendarException(4, "wrong attribute type");
            }
            this.checkType(value.getType());
        }
        AttributeValue old = this.mvalue;
        this.mvalue = value;
        return old;
    }
}

