/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.csa;

import java.util.Date;
import java.util.Vector;
import sunw.jdt.cal.cmsd5.cms_attribute;
import sunw.jdt.cal.cmsd5.cms_entry;
import sunw.jdt.cal.csa.AttributeValue;
import sunw.jdt.cal.csa.Calendar;
import sunw.jdt.cal.csa.CalendarException;
import sunw.jdt.cal.csa.DateTimeValue;
import sunw.jdt.cal.csa.EntryAttribute;
import sunw.jdt.cal.csa.EntryAttributeNames;
import sunw.jdt.cal.csa.Iso8601;
import sunw.jdt.cal.csa.LocaleXlateTable;
import sunw.jdt.cal.csa.Scope;
import sunw.jdt.cal.csa.Sint32Value;
import sunw.jdt.cal.csa.StringValue;
import sunw.jdt.cal.csa.Uint32Value;
import sunw.jdt.cal.util.Debug;

public class Entry {
    Calendar mcal;
    EntryAttribute[] mattrs = new EntryAttribute[37];
    boolean[] changed;
    int mid;
    int mtime;
    Uint32Value mrt = null;
    String charset = null;

    public Entry() {
    }

    Entry(Calendar cal, cms_entry e) {
        this(EntryAttribute.fromCmsAttrs(e.attrs));
        this.mid = e.key.id.data;
        this.mtime = e.key.time.data;
        this.mcal = cal;
        this.charset = this.mattrs[35] != null ? ((StringValue)this.mattrs[35].getValue()).getString() : this.mcal.mcalLocale;
        String encoding = null;
        if (this.charset != null) {
            encoding = LocaleXlateTable.getEncoding(this.charset, true);
        }
        if (encoding != null) {
            ((StringValue)this.mattrs[25].getValue()).setEncoding(encoding);
        }
    }

    public Entry(Entry e) {
        this();
        int i = 0;
        while (i < e.mattrs.length) {
            if (e.mattrs[i] != null) {
                this.mattrs[i] = (EntryAttribute)e.mattrs[i].clone();
            }
            ++i;
        }
    }

    Entry(EntryAttribute[] attrs) {
        this();
        if (attrs == null) {
            return;
        }
        int i = 0;
        while (i < attrs.length) {
            this.setAttribute(attrs[i], false);
            ++i;
        }
    }

    void fixAttrsForV3() throws CalendarException {
        if (this.changed[22]) {
            this.changed[7] = true;
        }
        if (this.changed[30] || this.changed[31]) {
            this.fixV3RepeatTimes();
        }
    }

    void fixAttrsForV4() throws CalendarException {
        if (this.changed[29] || this.changed[30] || this.changed[31] || this.changed[32]) {
            this.setRecurrenceRule();
            if (this.mattrs[17] != null) {
                this.setChanged(17);
            }
        }
    }

    void fixV3RepeatTimes() throws CalendarException {
        if (this.mattrs[30] == null) {
            return;
        }
        Uint32Value rt = (Uint32Value)this.mattrs[30].getValue();
        if (rt.getLong() == 0L) {
            this.mrt = rt;
            this.mattrs[30].setValue(new Uint32Value(999999999L));
        } else {
            int type = ((Sint32Value)this.mattrs[29].getValue()).getInt();
            if (type == 7 || type == 8 || type == 9) {
                this.mrt = rt;
                int f = (int)((Uint32Value)this.mattrs[31].getValue()).getLong();
                int t = (int)rt.getLong();
                this.mattrs[30].setValue(new Uint32Value(f * t));
            } else {
                this.mrt = null;
            }
        }
    }

    public EntryAttribute getAttribute(int nameIndex) {
        if (nameIndex >= 0 && nameIndex <= 37) {
            return this.mattrs[nameIndex];
        }
        System.out.println("can't get attribute for index " + nameIndex);
        return null;
    }

    public EntryAttribute getAttribute(String name) {
        int index = EntryAttributeNames.getIndex(name);
        if (index >= 0) {
            return this.mattrs[index];
        }
        System.out.println("can't get index for " + name);
        return null;
    }

    public AttributeValue getAttributeValue(int nameIndex) {
        EntryAttribute e = this.getAttribute(nameIndex);
        if (e != null) {
            return e.getValue();
        }
        return null;
    }

    public AttributeValue getAttributeValue(String name) {
        EntryAttribute e = this.getAttribute(name);
        if (e != null) {
            return e.getValue();
        }
        return null;
    }

    protected String getCharset() {
        return this.charset;
    }

    cms_attribute[] getCmsAttrsForInsert(int v) throws CalendarException {
        if (v >= 4) {
            this.setRecurrenceRule();
        } else {
            this.fixV3RepeatTimes();
        }
        Vector<cms_attribute> va = new Vector<cms_attribute>(10);
        int i = 0;
        while (i < this.mattrs.length) {
            boolean insert = v >= 4 ? EntryAttributeNames.v4new[i] : EntryAttributeNames.v3new[i];
            if (insert && this.mattrs[i] != null) {
                va.addElement(this.mattrs[i].toCmsAttribute());
            }
            ++i;
        }
        this.unfixV3RepeatTimes();
        int size = va.size();
        if (size > 0) {
            Object[] cms = new cms_attribute[size];
            va.copyInto(cms);
            return cms;
        }
        if (Debug.on) {
            System.out.println("getCmsAttrsForInsert: no attrs");
        }
        return null;
    }

    synchronized cms_attribute[] getCmsAttrsForUpdate(int v, Scope scope) throws CalendarException {
        if (this.changed == null) {
            return null;
        }
        if (v >= 4) {
            this.fixAttrsForV4();
        } else {
            this.fixAttrsForV3();
        }
        Vector<cms_attribute> va = new Vector<cms_attribute>(10);
        int i = 0;
        while (i < this.mattrs.length) {
            boolean update = v >= 4 ? EntryAttributeNames.v4update[i] : EntryAttributeNames.v3update[i];
            if (this.changed[i] && update) {
                va.addElement(this.mattrs[i].toCmsAttribute());
            }
            ++i;
        }
        if (v < 4) {
            va.addElement(this.mattrs[22].toCmsAttribute());
            if (this.mattrs[7] != null) {
                va.addElement(this.mattrs[7].toCmsAttribute());
            }
            if (!(scope.mvalue != 1 || this.changed[29] || this.changed[30] || this.changed[31] || this.changed[32])) {
                va.addElement(new EntryAttribute(29, (AttributeValue)new Sint32Value(0)).toCmsAttribute());
            }
        }
        this.unfixV3RepeatTimes();
        int size = va.size();
        if (size > 0) {
            Object[] cms = new cms_attribute[size];
            va.copyInto(cms);
            return cms;
        }
        if (Debug.on) {
            System.out.println("no attrs changed");
        }
        return null;
    }

    private String getWeekDay(java.util.Calendar cal) {
        switch (cal.get(7)) {
            case 1: {
                return "SU";
            }
            case 2: {
                return "MO";
            }
            case 3: {
                return "TU";
            }
            case 4: {
                return "WE";
            }
            case 5: {
                return "TH";
            }
            case 6: {
                return "FR";
            }
            case 7: {
                return "SA";
            }
        }
        return null;
    }

    public void print() {
        System.out.println("Entry information:");
        int i = 0;
        while (i < this.mattrs.length) {
            if (this.mattrs[i] != null) {
                System.out.println("index " + i + ":");
                this.mattrs[i].print();
            }
            ++i;
        }
    }

    public EntryAttribute setAttribute(EntryAttribute attr) {
        return this.setAttribute(attr, true);
    }

    EntryAttribute setAttribute(EntryAttribute attr, boolean update) {
        int index = attr.getIndex();
        if (index >= 0) {
            if (update) {
                this.setChanged(index);
            }
            EntryAttribute old = this.mattrs[index];
            this.mattrs[index] = attr;
            return old;
        }
        return null;
    }

    public AttributeValue setAttributeValue(int nameIndex, AttributeValue value) throws CalendarException {
        AttributeValue old = null;
        if (nameIndex >= 0 && nameIndex <= 37) {
            this.setChanged(nameIndex);
            if (this.mattrs[nameIndex] == null) {
                this.mattrs[nameIndex] = new EntryAttribute(nameIndex, value);
            } else {
                old = this.mattrs[nameIndex].setValue(value);
            }
            return old;
        }
        return null;
    }

    synchronized void setChanged(int index) {
        if (this.changed == null) {
            this.changed = new boolean[this.mattrs.length];
        }
        this.changed[index] = true;
        if (Debug.on) {
            System.out.println("Entry.setChanged() called for index " + index);
        }
    }

    protected void setCharset(String charset) {
        this.charset = charset;
    }

    private void setRecurrenceRule() throws CalendarException {
        Date enddate;
        int type = ((Sint32Value)this.mattrs[29].getValue()).getInt();
        if (type == 0) {
            if (this.mattrs[17] != null) {
                this.mattrs[17].setValue(null);
            }
            return;
        }
        int times = (int)((Uint32Value)this.mattrs[30].getValue()).getLong();
        StringBuffer sb = new StringBuffer(20);
        switch (type) {
            case 1: {
                sb.append("D1");
                break;
            }
            case 2: {
                sb.append("W1");
                break;
            }
            case 3: {
                sb.append("W2");
                break;
            }
            case 4: {
                java.util.Calendar cal = java.util.Calendar.getInstance();
                Date sdate = ((DateTimeValue)this.mattrs[22].getValue()).getDate();
                cal.setTime(sdate);
                sb.append("MP1");
                if (this.mattrs[32] == null || ((Sint32Value)this.mattrs[32].getValue()).getInt() != -1) break;
                sb.append(" 1- " + this.getWeekDay(cal));
                break;
            }
            case 5: {
                sb.append("MD1");
                break;
            }
            case 6: {
                sb.append("YM1");
                break;
            }
            case 10: {
                sb.append("W1 MO TU WE TH FR");
                break;
            }
            case 11: {
                sb.append("W1 MO WE FR");
                break;
            }
            case 12: {
                sb.append("W1 TU TH");
                break;
            }
            case 7: {
                sb.append("D");
                break;
            }
            case 8: {
                sb.append("W");
                break;
            }
            case 9: {
                sb.append("MD");
                break;
            }
            default: {
                throw new CalendarException(23, "repeat type not support");
            }
        }
        if (type == 7 || type == 8 || type == 9) {
            sb.append(((Uint32Value)this.mattrs[31].getValue()).getLong());
        }
        sb.append(" #");
        sb.append(times);
        EntryAttribute a = this.mattrs[33];
        if (a != null && (enddate = ((DateTimeValue)a.getValue()).getDate()).getTime() != 0L) {
            sb.append(" ");
            sb.append(Iso8601.toIsoDate(enddate));
        }
        if (Debug.on) {
            System.out.println(sb.toString());
        }
        this.mattrs[17] = new EntryAttribute(17, (AttributeValue)new StringValue(sb.toString()));
    }

    void unfixV3RepeatTimes() throws CalendarException {
        if (this.mrt != null) {
            this.mattrs[30].setValue(this.mrt);
            this.mrt = null;
        }
    }
}

