/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.csa;

import java.util.Date;
import java.util.TimeZone;
import sunw.jdt.cal.cmsd5.attr_value_type;
import sunw.jdt.cal.cmsd5.cms_attribute_value;
import sunw.jdt.cal.csa.AttributeValue;
import sunw.jdt.cal.csa.CalendarException;
import sunw.jdt.cal.csa.Iso8601;
import sunw.jdt.cal.rpc.Buffer;
import sunw.jdt.cal.util.Debug;

public class DateTimeValue
extends AttributeValue {
    String misoString;
    Date mdate = null;

    public DateTimeValue(String value) throws CalendarException {
        this.mtype = 18;
        this.fromString(value);
    }

    public DateTimeValue(Date value) {
        this(value, TimeZone.getDefault());
    }

    public DateTimeValue(Date value, TimeZone tz) {
        this.mtype = 18;
        this.fromDate(value, tz);
    }

    public DateTimeValue(cms_attribute_value cms) throws CalendarException {
        if (cms.type.value != 7) {
            throw new CalendarException(4, "wrong type");
        }
        this.mtype = 18;
        this.fromString(cms.type__date_time_value.val);
    }

    public Object clone() {
        try {
            DateTimeValue v = new DateTimeValue(this.misoString);
            return v;
        }
        catch (Exception e) {
            Debug.dumpException(e);
            return null;
        }
    }

    void fromDate(Date value, TimeZone tz) {
        this.mdate = new Date(value.getTime());
        this.misoString = Iso8601.toIsoDate(value, tz);
    }

    void fromString(String value) throws CalendarException {
        this.misoString = value;
    }

    public Date getDate() {
        if (this.mdate == null) {
            try {
                this.mdate = Iso8601.toDate(this.misoString);
            }
            catch (Exception e) {
                Debug.dumpException(e);
                return null;
            }
        }
        return new Date(this.mdate.getTime());
    }

    public String getIso8601() {
        return this.misoString;
    }

    public void print() {
        System.out.println("Date(" + this.misoString + "): " + this.mdate);
    }

    public cms_attribute_value toCmsValue() {
        cms_attribute_value cms = new cms_attribute_value();
        cms.type = new attr_value_type(7);
        cms.type__date_time_value = new Buffer(this.misoString);
        return cms;
    }
}

