/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.csa;

import java.util.Date;
import java.util.Vector;
import sunw.jdt.cal.cmsd5.attr_value_type;
import sunw.jdt.cal.cmsd5.cms_attribute_value;
import sunw.jdt.cal.cmsd5.cms_date_time_entry;
import sunw.jdt.cal.csa.AttributeValue;
import sunw.jdt.cal.csa.CalendarException;
import sunw.jdt.cal.csa.DateTimeValue;
import sunw.jdt.cal.rpc.Buffer;
import sunw.jdt.cal.util.Debug;

public class DateTimeListValue
extends AttributeValue {
    DateTimeValue[] mvalue = null;

    public DateTimeListValue(cms_attribute_value cms) throws CalendarException {
        if (cms.type.value != 12) {
            throw new CalendarException(4, "wrong type");
        }
        this.mtype = 23;
        Vector<DateTimeValue> v = new Vector<DateTimeValue>();
        cms_date_time_entry entry = cms.type__date_time_list_value;
        while (entry != null) {
            DateTimeValue item = new DateTimeValue(entry.date_time.val);
            v.addElement(item);
            entry = entry.next;
        }
        if (v.size() > 0) {
            this.mvalue = new DateTimeValue[v.size()];
            v.copyInto(this.mvalue);
        } else {
            this.mvalue = null;
        }
    }

    public DateTimeListValue(DateTimeValue[] dateTimeArray) {
        this.mtype = 23;
        int len = dateTimeArray.length;
        if (len > 0) {
            this.mvalue = new DateTimeValue[len];
            System.arraycopy(dateTimeArray, 0, this.mvalue, 0, len);
        }
    }

    public Object clone() {
        try {
            DateTimeListValue v = new DateTimeListValue(this.mvalue);
            return v;
        }
        catch (Exception e) {
            Debug.dumpException(e);
            return null;
        }
    }

    public Date[] getDateList() {
        Date[] dates = null;
        if (this.mvalue != null) {
            dates = new Date[this.mvalue.length];
            int i = 0;
            while (i < this.mvalue.length) {
                dates[i] = this.mvalue[i].getDate();
                ++i;
            }
        }
        return dates;
    }

    public DateTimeValue[] getDateTimeEntries() {
        return this.mvalue;
    }

    public Vector getDateVector() {
        Vector<Date> dates = null;
        if (this.mvalue != null) {
            dates = new Vector<Date>(this.mvalue.length);
            int i = 0;
            while (i < this.mvalue.length) {
                dates.addElement(this.mvalue[i].getDate());
                ++i;
            }
        }
        return dates;
    }

    public void print() {
        System.out.print("DateTimeList: ");
        if (this.mvalue == null) {
            System.out.println("null");
        } else {
            int i = 0;
            while (i < this.mvalue.length) {
                System.out.print("\n" + this.mvalue[i].getIso8601());
                ++i;
            }
            System.out.println(" ");
        }
    }

    public cms_attribute_value toCmsValue() {
        cms_attribute_value cms = new cms_attribute_value();
        cms.type = new attr_value_type(12);
        if (this.mvalue == null) {
            cms.type__date_time_list_value = null;
        } else {
            cms_date_time_entry prev = null;
            cms_date_time_entry entry = null;
            int i = 0;
            while (i < this.mvalue.length) {
                entry = new cms_date_time_entry();
                entry.date_time = new Buffer(this.mvalue[i].getIso8601());
                entry.next = prev;
                prev = entry;
                ++i;
            }
            cms.type__date_time_list_value = entry;
        }
        return cms;
    }
}

