/*
 * Decompiled with CFR 0.152.
 */
package sunw.jdt.cal.csa;

import sunw.jdt.cal.csa.CalendarException;
import sunw.jdt.cal.util.Debug;

public class CsaReturnCode {
    public static final int CSA_SUCCESS = 0;
    public static final int CSA_E_CALENDAR_EXISTS = 2;
    public static final int CSA_E_CALENDAR_NOT_EXIST = 3;
    public static final int CSA_E_FAILURE = 6;
    public static final int CSA_E_INSUFFICIENT_MEMORY = 9;
    public static final int CSA_E_INVALID_ATTRIBUTE = 10;
    public static final int CSA_E_INVALID_ATTRIBUTE_VALUE = 11;
    public static final int CSA_E_INVALID_DATE_TIME = 15;
    public static final int CSA_E_INVALID_PARAMETER = 22;
    public static final int CSA_E_NO_AUTHORITY = 27;
    public static final int CSA_X_DT_E_BACKING_STORE_PROBLEM = 150994975;

    public static CalendarException toCalendarException(int code) {
        if (code == 0) {
            return null;
        }
        return new CalendarException(CsaReturnCode.toErrorCode(code), CsaReturnCode.toString(code));
    }

    private static int toErrorCode(int code) {
        switch (code) {
            case 2: {
                return 11;
            }
            case 3: {
                return 1;
            }
            case 9: {
                return 12;
            }
            case 10: {
                return 13;
            }
            case 11: {
                return 14;
            }
            case 15: {
                return 15;
            }
            case 22: {
                return 19;
            }
            case 27: {
                return 3;
            }
            case 150994975: {
                return 21;
            }
        }
        if (Debug.on) {
            System.out.println("CSA_return_code " + code + " not recognized");
        }
        return 0;
    }

    private static String toString(int code) {
        switch (code) {
            case 2: {
                return "Calendar exists";
            }
            case 3: {
                return "Calendar not exist";
            }
            case 9: {
                return "no memory";
            }
            case 10: {
                return "Invalid attribute";
            }
            case 11: {
                return "invalid attribute value";
            }
            case 15: {
                return "invalid date time";
            }
            case 22: {
                return "invalid parameter";
            }
            case 27: {
                return "no authority";
            }
            case 150994975: {
                return "backing store problem";
            }
        }
        if (Debug.on) {
            System.out.println("CSA_return_code " + code + " not recognized");
        }
        return "operation failed";
    }
}

